/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hands;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;

public class GoldenHookItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"hook").stat(StatData.builder((String)"amount").icon(StatIcons.MULTIPLIER).initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 6, 10).star(1, 10, 5).star(2, 15, 10).star(3, 10, 18).star(4, 7, 23).star(5, 13, 23).link(0, 1).link(1, 2).link(2, 3).link(4, 5).link(3, 4).link(3, 5).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.BASTION).build()).build();
    }

    @EventBusSubscriber
    public static class GoldenHookEvent {
        @SubscribeEvent
        public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
            Player player = event.getAttackingPlayer();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.GOLDEN_HOOK.value()));
            Item item = stack.getItem();
            if (!(item instanceof GoldenHookItem)) {
                return;
            }
            GoldenHookItem relic = (GoldenHookItem)item;
            double boostedExperience = (double)event.getOriginalExperience() * relic.getStatValue(stack, "hook", "amount");
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            event.setDroppedExperience((int)((double)event.getOriginalExperience() + boostedExperience));
        }
    }
}

