/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemFishedEvent;

public class AnglersHatItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"catch").stat(StatData.builder((String)"chance").icon(StatIcons.CHANCE).initialValue(0.1, 0.2).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.25).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 16, 2).star(1, 12, 5).star(2, 5, 4).star(3, 10, 10).star(4, 6, 15).star(5, 5, 24).star(6, 16, 15).star(7, 18, 21).link(0, 1).link(1, 2).link(2, 3).link(3, 4).link(4, 5).link(3, 6).link(6, 7).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.AQUATIC).build()).build();
    }

    @EventBusSubscriber
    public static class AnglersHatEvents {
        @SubscribeEvent
        public static void onItemFished(ItemFishedEvent event) {
            AnglersHatItem relic;
            ItemStack stack;
            FishingHook fishingHook;
            Level level;
            Player player;
            block7: {
                block6: {
                    player = event.getEntity();
                    level = player.getCommandSenderWorld();
                    fishingHook = event.getHookEntity();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.ANGLERS_HAT.value()));
                    Item item = stack.getItem();
                    if (!(item instanceof AnglersHatItem)) break block6;
                    relic = (AnglersHatItem)item;
                    if (!level.isClientSide()) break block7;
                }
                return;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            RandomSource random = serverLevel.getRandom();
            int rolls = MathUtils.multicast((RandomSource)random, (double)relic.getStatValue(stack, "catch", "chance"), (double)1.0);
            if (rolls > 0) {
                relic.spreadRelicExperience((LivingEntity)player, stack, random.nextInt(rolls) + 1);
            }
            LootTable loottable = serverLevel.getServer().reloadableRegistries().getLootTable(BuiltInLootTables.FISHING);
            LootParams lootparams = new LootParams.Builder(serverLevel).withParameter(LootContextParams.ORIGIN, (Object)player.position()).withParameter(LootContextParams.TOOL, (Object)stack).withParameter(LootContextParams.THIS_ENTITY, (Object)player).create(LootContextParamSets.FISHING);
            for (int i = 0; i < rolls; ++i) {
                ObjectArrayList drop = loottable.getRandomItems(lootparams);
                for (ItemStack itemstack : drop) {
                    ItemEntity itementity = new ItemEntity((Level)serverLevel, fishingHook.getX(), fishingHook.getY(), fishingHook.getZ(), itemstack);
                    double x = player.getX() - fishingHook.getX();
                    double y = player.getY() - fishingHook.getY();
                    double z = player.getZ() - fishingHook.getZ();
                    itementity.setDeltaMovement(x * 0.1, y * 0.1 + Math.sqrt(Math.sqrt(x * x + y * y + z * z)) * 0.08, z * 0.1);
                    serverLevel.addFreshEntity((Entity)itementity);
                    serverLevel.addFreshEntity((Entity)new ExperienceOrb((Level)serverLevel, player.getX(), player.getY() + 0.5, player.getZ() + 0.5, random.nextInt(6) + 1));
                }
            }
        }
    }
}

