/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.hat;

import artifacts.registry.ModItems;
import artifacts.registry.ModSoundEvents;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

public class WhoopeeCushionItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"push").stat(StatData.builder((String)"radius").icon(StatIcons.DISTANCE).initialValue(3.0, 5.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.06).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"chance").icon(StatIcons.CHANCE).initialValue(0.2, 0.4).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.075).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).research(ResearchData.builder().star(0, 4, 13).star(1, 13, 8).star(2, 18, 14).star(3, 10, 19).link(0, 1).link(1, 2).link(3, 2).link(3, 0).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.VILLAGE).build()).build();
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player;
        block6: {
            block5: {
                LivingEntity livingEntity = slotContext.entity();
                if (!(livingEntity instanceof Player)) break block5;
                player = (Player)livingEntity;
                if (!player.level().isClientSide) break block6;
            }
            return;
        }
        boolean isSneaking = player.isShiftKeyDown();
        boolean crouchState = (Boolean)stack.getOrDefault((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
        if (isSneaking && !crouchState) {
            Random random = new Random();
            if (random.nextDouble() < 0.2) {
                WhoopeeCushionItem.createWhoopee(player.level(), player, this, stack);
            }
        }
        stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)isSneaking);
    }

    public static void createWhoopee(Level level, Player player, WhoopeeCushionItem relic, ItemStack stack) {
        level.playSound(null, player.blockPosition(), (SoundEvent)ModSoundEvents.FART.value(), player.getSoundSource(), 1.0f, 0.75f + new Random().nextFloat(1.0f) * 0.5f);
        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
        double radius = relic.getStatValue(stack, "push", "radius");
        for (Mob mob : level.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(radius))) {
            mob.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 60, 1));
            mob.setDeltaMovement(mob.position().subtract(player.position()).normalize());
        }
    }

    @EventBusSubscriber
    public static class WhoopeeCushionEvent {
        @SubscribeEvent
        public static void onAttackPlayer(LivingIncomingDamageEvent event) {
            WhoopeeCushionItem relic;
            Level level;
            ItemStack stack;
            Player player;
            block5: {
                block4: {
                    Entity attacker = event.getSource().getEntity();
                    LivingEntity livingEntity = event.getEntity();
                    if (!(livingEntity instanceof Player) || attacker == (player = (Player)livingEntity)) {
                        return;
                    }
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.WHOOPEE_CUSHION.value()));
                    level = player.level();
                    Item item = stack.getItem();
                    if (!(item instanceof WhoopeeCushionItem)) break block4;
                    relic = (WhoopeeCushionItem)item;
                    Random random = new Random();
                    if (!(random.nextDouble(1.0) > relic.getStatValue(stack, "push", "chance"))) break block5;
                }
                return;
            }
            WhoopeeCushionItem.createWhoopee(level, player, relic, stack);
        }
    }
}

