/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicAttributeModifier;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import top.theillusivec4.curios.api.SlotContext;

public class CharmOfShrinkingItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"shrinking").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"time").icon(StatIcons.DURATION).initialValue(8.0, 10.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> (int)MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 11, 28).star(1, 11, 17).star(2, 11, 11).star(3, 11, 4).star(4, 6, 21).star(5, 16, 21).star(6, 4, 17).star(7, 18, 17).star(8, 2, 14).star(9, 20, 14).link(0, 1).link(1, 2).link(2, 3).link(1, 4).link(1, 5).link(2, 6).link(2, 7).link(3, 8).link(3, 9).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.SCULK).build()).build();
    }

    @Nullable
    public RelicAttributeModifier getRelicAttributeModifiers(ItemStack stack) {
        if (this.isAbilityTicking(stack, "shrinking")) {
            return RelicAttributeModifier.builder().attribute(new RelicAttributeModifier.Modifier(Attributes.SCALE, -0.5f)).build();
        }
        return super.getRelicAttributeModifiers(stack);
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (stage == CastStage.START) {
            this.playSound(player, SoundEvents.PUFFER_FISH_BLOW_OUT);
        } else if (stage == CastStage.END) {
            this.playSound(player, SoundEvents.PUFFER_FISH_BLOW_UP);
            this.setAbilityCooldown(stack, "shrinking", 200);
            this.removeAttribute((LivingEntity)player, stack);
        }
        if (player.tickCount % 20 == 0) {
            this.setCurrentTick(stack, 1);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity = slotContext.entity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        double time = this.getStatValue(stack, "shrinking", "time");
        if ((double)this.getCurrentTick(stack) >= time) {
            this.playSound(player, SoundEvents.PUFFER_FISH_BLOW_UP);
            this.setAbilityCooldown(stack, "shrinking", 200);
            this.setCurrentTick(stack, -this.getCurrentTick(stack));
            this.removeAttribute((LivingEntity)player, stack);
        }
        if (player.tickCount % 20 == 0 && this.isAbilityTicking(stack, "shrinking")) {
            this.spreadRelicExperience((LivingEntity)player, stack, 1);
        }
    }

    public void playSound(Player player, SoundEvent events) {
        player.playSound(events, 1.0f, 0.75f + new Random().nextFloat(1.0f) * 0.5f);
    }

    public void setCurrentTick(ItemStack stack, int val) {
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)(this.getCurrentTick(stack) + val));
    }

    public int getCurrentTick(ItemStack stack) {
        return (Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0);
    }

    private void removeAttribute(LivingEntity entity, ItemStack stack) {
        EntityUtils.removeAttribute((LivingEntity)entity, (ItemStack)stack, (Holder)Attributes.SCALE, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    }
}

