/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import java.util.HashSet;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;

public class PanicNecklaceItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"panic").stat(StatData.builder((String)"movement").initialValue(1.0, 2.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"radius").initialValue(6.0, 8.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).build();
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        LivingEntity livingEntity;
        if (stack.getItem() == newStack.getItem() || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        EntityUtils.removeAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        LivingEntity livingEntity;
        if (slotContext.entity().level().isClientSide || !((livingEntity = slotContext.entity()) instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        float modifierMovementSpeed = (float)this.getStatValue(stack, "panic", "movement") / 10.0f * (float)this.getLengthRadius(player, player.level(), stack);
        EntityUtils.resetAttribute((LivingEntity)player, (ItemStack)stack, (Holder)Attributes.MOVEMENT_SPEED, (float)modifierMovementSpeed, (AttributeModifier.Operation)AttributeModifier.Operation.ADD_MULTIPLIED_BASE);
    }

    public int getLengthRadius(Player player, Level level, ItemStack stack) {
        HashSet<Mob> trackedMobs = new HashSet<Mob>();
        for (Mob mob2 : level.getEntitiesOfClass(Mob.class, player.getBoundingBox().inflate(this.getStatValue(stack, "panic", "radius")), entity -> entity instanceof Mob)) {
            if (mob2.getTarget() != player) continue;
            trackedMobs.add(mob2);
        }
        trackedMobs.removeIf(mob -> mob.getTarget() != player || !mob.isAlive() || !mob.getBoundingBox().intersects(player.getBoundingBox().inflate(this.getStatValue(stack, "panic", "radius"))));
        return trackedMobs.toArray().length;
    }
}

