/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.octostudios.rarcompat.network.packets.CreateZonePacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.init.EffectRegistry;
import it.hurts.sskirillss.relics.init.HotkeyRegistry;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.CastData;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastStage;
import it.hurts.sskirillss.relics.items.relics.base.data.cast.misc.CastType;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import it.hurts.sskirillss.relics.utils.data.WorldPosition;
import java.awt.Color;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.InputEvent;
import top.theillusivec4.curios.api.SlotContext;

public class ScarfOfInvisibilityItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"invisible").active(CastData.builder().type(CastType.TOGGLEABLE).build()).stat(StatData.builder((String)"threshold").icon(StatIcons.SPEED).initialValue(0.07, 0.08).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.03).formatValue(value -> {
            if (value >= 0.1) {
                return MathUtils.round((double)value, (int)1);
            }
            return MathUtils.round((double)value, (int)3);
        }).build()).stat(StatData.builder((String)"radius").icon(StatIcons.DISTANCE).initialValue(8.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, -0.05).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).research(ResearchData.builder().star(0, 11, 27).star(1, 11, 12).star(2, 11, 8).star(3, 17, 12).star(4, 6, 12).star(5, 6, 17).link(0, 1).link(1, 2).link(1, 3).link(1, 4).link(4, 5).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.ANTHROPOGENIC).build()).build();
    }

    public void castActiveAbility(ItemStack stack, Player player, String ability, CastType type, CastStage stage) {
        if (stack.get((Supplier)DataComponentRegistry.WORLD_POSITION) == null) {
            double thresholdValue = this.getStatValue(stack, "invisible", "threshold");
            if (Math.abs(player.getKnownMovement().y) > thresholdValue) {
                return;
            }
            if ((double)player.getSpeed() <= thresholdValue) {
                player.addEffect(new MobEffectInstance((Holder)EffectRegistry.VANISHING, 5, 0, false, false));
                if (player.tickCount % 20 == 0) {
                    this.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            } else if (player.isShiftKeyDown() && thresholdValue < (double)0.9f) {
                player.addEffect(new MobEffectInstance((Holder)EffectRegistry.VANISHING, 5, 0, false, false));
                if (player.tickCount % 20 == 0) {
                    this.spreadRelicExperience((LivingEntity)player, stack, 1);
                }
            } else if (Math.abs(player.getKnownMovement().x) <= 0.01 && Math.abs(player.getKnownMovement().z) <= 0.01 && player.getSpeed() == 0.1f) {
                player.addEffect(new MobEffectInstance((Holder)EffectRegistry.VANISHING, 5, 0, false, false));
            }
        } else {
            ScarfOfInvisibilityItem.updateInvisibilityZone(player.level(), player, this.getStatValue(stack, "invisible", "radius"), stack);
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack newStack, ItemStack stack) {
        if (newStack == stack) {
            return;
        }
        stack.set((Supplier)DataComponentRegistry.WORLD_POSITION, null);
    }

    public static void updateInvisibilityZone(Level level, Player player, double radius, ItemStack itemStack) {
        if (player == null) {
            return;
        }
        RandomSource random = player.getRandom();
        if (level.isClientSide) {
            return;
        }
        ScarfOfInvisibilityItem.checkDistance(player, radius);
        ScarfOfInvisibilityItem.createCyl(ParticleUtils.constructSimpleSpark((Color)new Color(random.nextInt(50), random.nextInt(50), 50 + random.nextInt(55)), (float)0.5f, (int)1, (float)1.0f), ScarfOfInvisibilityItem.getBlockPos(itemStack), level, radius, 0.1f);
    }

    public static void createCyl(ParticleOptions particle, Vec3 center, Level level, double radius, float step) {
        int offset = 16;
        double len = Math.PI * 2 * radius;
        int num = (int)(len / (double)step);
        for (int i = 0; i < num; ++i) {
            int tries;
            double angle = Math.toRadians((double)(360.0f / (float)num * (float)i) + 360.0 * ((len / (double)step - (double)num) / (double)num / len));
            double extraX = radius * Math.sin(angle) + center.x();
            double extraZ = radius * Math.cos(angle) + center.z();
            double extraY = center.y();
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(extraX, extraY, extraZ);
                BlockPos pos = new BlockPos(Mth.floor((double)extraX), Mth.floor((double)extraY), Mth.floor((double)extraZ));
                BlockState state = level.getBlockState(pos);
                VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos);
                if (state.getBlock() instanceof LiquidBlock) {
                    shape = Shapes.block();
                }
                if (shape.isEmpty()) {
                    if (!foundPos) {
                        extraY -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.isEmpty()) break;
                AABB aabb = shape.bounds();
                if (!aabb.move(pos).contains(vec)) {
                    if (!(aabb.maxY >= 1.0)) break;
                    extraY += 1.0;
                    continue;
                }
                extraY += (double)step;
            }
            if (tries >= offset * 2) continue;
            ((ServerLevel)level).sendParticles(particle, extraX, extraY + (double)0.1f, extraZ, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    private static void checkDistance(Player playerOwner, double radius) {
        Level level = playerOwner.level();
        if (level.isClientSide) {
            return;
        }
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerOwner, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.value()));
        int offset = 16;
        if (ScarfOfInvisibilityItem.getBlockPos(stack).distanceTo(playerOwner.position()) <= radius) {
            return;
        }
        RandomSource random = playerOwner.getRandom();
        int particleCount = (int)(radius * 75.0);
        for (int i = 0; i < particleCount; ++i) {
            int tries;
            double angle = (double)i * (Math.PI * 2 / (double)particleCount);
            double x = radius * Math.cos(angle) + ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).x;
            double y = ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).y;
            double z = radius * Math.sin(angle) + ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).z;
            boolean foundPos = false;
            for (tries = 0; tries < offset * 2; ++tries) {
                Vec3 vec = new Vec3(x, y, z);
                BlockPos pos = new BlockPos(Mth.floor((double)x), Mth.floor((double)y), Mth.floor((double)z));
                BlockState state = level.getBlockState(pos);
                VoxelShape shape = state.getCollisionShape((BlockGetter)level, pos);
                if (state.getBlock() instanceof LiquidBlock) {
                    shape = Shapes.block();
                }
                if (shape.isEmpty()) {
                    if (!foundPos) {
                        y -= 1.0;
                        continue;
                    }
                } else {
                    foundPos = true;
                }
                if (shape.isEmpty()) break;
                AABB aabb = shape.bounds();
                if (!aabb.move(pos).contains(vec)) {
                    if (!(aabb.maxY >= 1.0)) break;
                    y += 1.0;
                    continue;
                }
                y += (double)0.1f;
            }
            if (tries >= offset * 2) continue;
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(random.nextInt(50), random.nextInt(50), 50 + random.nextInt(55)), (float)0.5f, (int)((int)(radius * (40.0 / radius))), (float)0.9f), x, y, z, 2, 0.0, 0.02 + random.nextDouble() * 0.02, 0.0, 0.1);
        }
        stack.set((Supplier)DataComponentRegistry.WORLD_POSITION, null);
    }

    private static Vec3 getBlockPos(ItemStack stack) {
        if (stack.get((Supplier)DataComponentRegistry.WORLD_POSITION) == null) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        return ((WorldPosition)stack.get((Supplier)DataComponentRegistry.WORLD_POSITION)).getPos();
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class Events {
        @SubscribeEvent
        public static void onMouseInput(InputEvent.MouseButton.Pre event) {
            LocalPlayer playerClient = Minecraft.getInstance().player;
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)playerClient, (Item)((Item)ModItems.SCARF_OF_INVISIBILITY.value()));
            Item item = stack.getItem();
            if (item instanceof ScarfOfInvisibilityItem) {
                ScarfOfInvisibilityItem relic = (ScarfOfInvisibilityItem)item;
                if (playerClient != null && !HotkeyRegistry.ABILITY_LIST.isDown() && event.getButton() != HotkeyRegistry.ABILITY_LIST.getKey().getValue() && playerClient.hasEffect((Holder)EffectRegistry.VANISHING) && !playerClient.hasContainerOpen() && Minecraft.getInstance().screen == null) {
                    NetworkHandler.sendToServer((CustomPacketPayload)new CreateZonePacket());
                    Events.createBallParticles((Player)playerClient, stack, relic.getStatValue(stack, "invisible", "radius"));
                }
            }
        }

        public static void createBallParticles(Player player, ItemStack stack, double radius) {
            Level level = player.level();
            RandomSource random = player.getRandom();
            int i = 0;
            while ((double)i < radius * 50.0) {
                double theta = Math.PI * 2 * random.nextDouble();
                double phi = Math.acos(2.0 * random.nextDouble() - 1.0);
                double velocityX = radius * Math.sin(phi) * Math.cos(theta);
                double velocityY = radius * Math.sin(phi) * Math.sin(theta);
                double velocityZ = radius * Math.cos(phi);
                level.addParticle(ParticleUtils.constructSimpleSpark((Color)new Color(random.nextInt(50), random.nextInt(50), 50 + random.nextInt(55)), (float)0.5f, (int)((int)(radius * (17.0 / radius))), (float)0.9f), ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).x, ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).y + 1.0, ScarfOfInvisibilityItem.getBlockPos((ItemStack)stack).z, velocityX * 0.055, velocityY * 0.055, velocityZ * 0.055);
                ++i;
            }
        }
    }
}

