/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class ShockPendantItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"lightning").stat(StatData.builder((String)"damage").icon(StatIcons.DEALT_DAMAGE).initialValue(1.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.2).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"chance").icon(StatIcons.CHANCE).initialValue(0.2, 0.3).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)2)).build()).research(ResearchData.builder().star(0, 10, 18).star(1, 4, 14).star(2, 11, 13).star(3, 16, 16).star(4, 12, 29).link(1, 0).link(2, 0).link(3, 0).link(4, 0).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry("minecraft:chests/ancient_city", 0.5f).build()).build();
    }

    @EventBusSubscriber
    public static class Event {
        @SubscribeEvent
        public static void onReceivingDamage(LivingIncomingDamageEvent event) {
            ShockPendantItem relic;
            ItemStack stack;
            Level level;
            Random random;
            Player player;
            Entity attacker;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            attacker = event.getSource().getEntity();
                            LivingEntity livingEntity = event.getEntity();
                            if (!(livingEntity instanceof Player)) break block4;
                            player = (Player)livingEntity;
                            if (attacker != null && attacker != player) break block5;
                        }
                        return;
                    }
                    random = new Random();
                    level = attacker.level();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.SHOCK_PENDANT.value()));
                    Item item = stack.getItem();
                    if (!(item instanceof ShockPendantItem)) break block6;
                    relic = (ShockPendantItem)item;
                    if (!level.isClientSide && !((double)random.nextInt() > relic.getStatValue(stack, "lightning", "chance"))) break block7;
                }
                return;
            }
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            LightningBolt lightningBolt = new LightningBolt(EntityType.LIGHTNING_BOLT, level);
            lightningBolt.setVisualOnly(true);
            lightningBolt.setPos(attacker.position());
            level.addFreshEntity((Entity)lightningBolt);
            attacker.hurt(lightningBolt.damageSources().lightningBolt(), (float)relic.getStatValue(stack, "lightning", "damage"));
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(random.nextInt(50), random.nextInt(50), 50 + random.nextInt(55)), (float)0.4f, (int)30, (float)0.95f), attacker.getX(), attacker.getY() + (double)(attacker.getBbHeight() / 2.0f), attacker.getZ(), 10, (double)(attacker.getBbWidth() / 2.0f), (double)(attacker.getBbHeight() / 2.0f), (double)(attacker.getBbWidth() / 2.0f), (double)0.025f);
        }
    }
}

