/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.items.necklace;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.WearableRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilitiesData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.LevelingData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.misc.UpgradeOperation;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.LootData;
import it.hurts.sskirillss.relics.items.relics.base.data.loot.misc.LootCollections;
import it.hurts.sskirillss.relics.items.relics.base.data.misc.StatIcons;
import it.hurts.sskirillss.relics.items.relics.base.data.research.ResearchData;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.MathUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;

public class ThornPendantItem
extends WearableRelicItem {
    public RelicData constructDefaultRelicData() {
        return RelicData.builder().abilities(AbilitiesData.builder().ability(AbilityData.builder((String)"poison").stat(StatData.builder((String)"multiplier").icon(StatIcons.MULTIPLIER).initialValue(0.05, 0.1).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.1).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)1)).build()).stat(StatData.builder((String)"time").icon(StatIcons.DURATION).initialValue(2.0, 3.0).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.3).formatValue(value -> MathUtils.round((double)value, (int)1)).build()).stat(StatData.builder((String)"chance").icon(StatIcons.CHANCE).initialValue(0.1, 0.15).upgradeModifier(UpgradeOperation.MULTIPLY_BASE, 0.15).formatValue(value -> MathUtils.round((double)(value * 100.0), (int)2)).build()).research(ResearchData.builder().star(0, 10, 18).star(1, 4, 14).star(2, 11, 13).star(3, 16, 16).star(4, 12, 29).link(1, 0).link(2, 0).link(3, 0).link(4, 0).build()).build()).build()).leveling(new LevelingData(100, 10, 100)).loot(LootData.builder().entry(LootCollections.JUNGLE).build()).build();
    }

    @EventBusSubscriber
    public static class Event {
        @SubscribeEvent
        public static void onReceivingDamage(LivingIncomingDamageEvent event) {
            ThornPendantItem relic;
            Random random;
            ItemStack stack;
            Level level;
            LivingEntity attacker;
            Player player;
            block7: {
                block6: {
                    block5: {
                        block4: {
                            Entity entityAttacker = event.getSource().getEntity();
                            LivingEntity livingEntity = event.getEntity();
                            if (!(livingEntity instanceof Player)) break block4;
                            player = (Player)livingEntity;
                            if (entityAttacker instanceof LivingEntity && (attacker = (LivingEntity)entityAttacker) != player) break block5;
                        }
                        return;
                    }
                    level = attacker.level();
                    stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.THORN_PENDANT.value()));
                    random = new Random();
                    Item item = stack.getItem();
                    if (!(item instanceof ThornPendantItem)) break block6;
                    relic = (ThornPendantItem)item;
                    if (!level.isClientSide && !((double)random.nextInt() > relic.getStatValue(stack, "poison", "chance"))) break block7;
                }
                return;
            }
            float multiplier = (float)relic.getStatValue(stack, "poison", "multiplier");
            int time = (int)(relic.getStatValue(stack, "poison", "time") * 20.0);
            relic.spreadRelicExperience((LivingEntity)player, stack, 1);
            attacker.hurt(event.getSource(), event.getAmount() * multiplier);
            attacker.addEffect(new MobEffectInstance(MobEffects.POISON, time, 1));
            ((ServerLevel)level).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(50 + random.nextInt(50), 200 + random.nextInt(55), 50 + random.nextInt(50)), (float)0.4f, (int)30, (float)0.95f), attacker.getX(), attacker.getY() + (double)(attacker.getBbHeight() / 2.0f), attacker.getZ(), 10, (double)(attacker.getBbWidth() / 2.0f), (double)(attacker.getBbHeight() / 2.0f), (double)(attacker.getBbWidth() / 2.0f), (double)0.025f);
        }
    }
}

