/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.mixin;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.hat.VillagerHatItem;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractVillager.class})
public abstract class AbstractVillagerMixin {
    @Shadow
    private Player tradingPlayer;
    @Shadow
    protected MerchantOffers offers;

    @Inject(method={"notifyTrade "}, at={@At(value="HEAD")})
    private void notifyTrade(MerchantOffer p_35274_, CallbackInfo ci) {
        VillagerHatItem hat;
        ItemStack relicStack;
        block5: {
            block4: {
                Item item;
                relicStack = EntityUtils.findEquippedCurio((Entity)this.tradingPlayer, (Item)((Item)ModItems.VILLAGER_HAT.value()));
                if (relicStack == null || !((item = relicStack.getItem()) instanceof VillagerHatItem)) break block4;
                hat = (VillagerHatItem)item;
                if (this.offers != null) break block5;
            }
            return;
        }
        int newPrice = (int)Math.round((double)p_35274_.getItemCostA().count() * hat.getStatValue(relicStack, "discount", "multiplier"));
        if (newPrice > 1) {
            hat.spreadRelicExperience((LivingEntity)this.tradingPlayer, relicStack, 1 + this.tradingPlayer.getRandom().nextInt(newPrice) + 1);
        }
    }

    @Inject(method={"getOffers"}, at={@At(value="HEAD")})
    private void getOffers(CallbackInfoReturnable<MerchantOffers> cir) {
        VillagerHatItem hat;
        ItemStack relicStack;
        block4: {
            block3: {
                Object object;
                relicStack = EntityUtils.findEquippedCurio((Entity)this.tradingPlayer, (Item)((Item)ModItems.VILLAGER_HAT.value()));
                if (relicStack == null || !((object = relicStack.getItem()) instanceof VillagerHatItem)) break block3;
                hat = (VillagerHatItem)((Object)object);
                if (this.offers != null) break block4;
            }
            return;
        }
        for (MerchantOffer offer : this.offers) {
            int newPrice = (int)Math.round((double)offer.getItemCostA().count() * hat.getStatValue(relicStack, "discount", "multiplier") / 100.0);
            offer.setSpecialPriceDiff(-newPrice);
        }
    }
}

