/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import artifacts.registry.ModItems;
import it.hurts.octostudios.rarcompat.items.belt.CloudInBottleItem;
import it.hurts.octostudios.rarcompat.network.packets.PlayerMotionPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class DoubleJumpPacket
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<DoubleJumpPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rarcompat", (String)"check_double_jump"));
    public static final StreamCodec<RegistryFriendlyByteBuf, DoubleJumpPacket> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DoubleJumpPacket>(){

        public void encode(RegistryFriendlyByteBuf p_320158_, DoubleJumpPacket p_320396_) {
        }

        @Nonnull
        public DoubleJumpPacket decode(@Nonnull RegistryFriendlyByteBuf buf) {
            return new DoubleJumpPacket();
        }
    };

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> {
            Player player = ctx.player();
            ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.CLOUD_IN_A_BOTTLE.value()));
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof CloudInBottleItem) {
                CloudInBottleItem relic = (CloudInBottleItem)patt0$temp;
                if (!player.onGround()) {
                    stack.set((Supplier)DataComponentRegistry.COUNT, (Object)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)0) + 1));
                    if ((long)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.COUNT, (Object)0)).intValue() <= Math.round(relic.getStatValue(stack, "jump", "count"))) {
                        double upwardsMotion = 0.9;
                        if (player.hasEffect(MobEffects.JUMP)) {
                            upwardsMotion += 0.1 * (double)(Objects.requireNonNull(player.getEffect(MobEffects.JUMP)).getAmplifier() + 1);
                        }
                        float direction = (float)((double)player.getYRot() * Math.PI / 180.0);
                        double horizontalFactor = 4.0;
                        relic.spreadRelicExperience((LivingEntity)player, stack, 1);
                        player.hasImpulse = true;
                        player.awardStat(Stats.JUMP);
                        NetworkHandler.sendToClient((CustomPacketPayload)new PlayerMotionPacket((double)(-Mth.sin((float)direction)) / horizontalFactor, upwardsMotion, (double)Mth.cos((float)direction) / horizontalFactor), (ServerPlayer)((ServerPlayer)player));
                        player.level().playSound(null, (Entity)player, SoundEvents.CHAIN_BREAK, SoundSource.PLAYERS, 1.0f, 0.9f + player.getRandom().nextFloat() * 0.2f);
                        this.createJumpParticles(player, (ServerLevel)player.level());
                    }
                } else {
                    stack.set((Supplier)DataComponentRegistry.COUNT, (Object)0);
                }
            }
        });
    }

    private void createJumpParticles(Player player, ServerLevel level) {
        int particleCount = 70;
        double radius = 1.0;
        double speed = 0.2;
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double xOffset = Math.cos(angle) * radius;
            double zOffset = Math.sin(angle) * radius;
            level.sendParticles((ParticleOptions)ParticleTypes.CLOUD, player.getX() + xOffset, player.getY(), player.getZ() + zOffset, 1, speed, 0.0, speed, 0.0);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }
}

