/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.octostudios.rarcompat.network.packets;

import artifacts.registry.ModItems;
import io.netty.buffer.ByteBuf;
import it.hurts.octostudios.rarcompat.items.feet.BunnyHoppersItem;
import it.hurts.octostudios.rarcompat.network.packets.PlayerMotionPacket;
import it.hurts.sskirillss.relics.init.DataComponentRegistry;
import it.hurts.sskirillss.relics.network.NetworkHandler;
import it.hurts.sskirillss.relics.utils.EntityUtils;
import it.hurts.sskirillss.relics.utils.ParticleUtils;
import java.awt.Color;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class PowerJumpPacket
implements CustomPacketPayload {
    private final int action;
    public static final CustomPacketPayload.Type<PowerJumpPacket> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rarcompat", (String)"power_jump"));
    public static final StreamCodec<ByteBuf, PowerJumpPacket> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PowerJumpPacket::getAction, PowerJumpPacket::new);

    public void handle(IPayloadContext ctx) {
        ctx.enqueueWork(() -> PowerJumpPacket.createJump(this.getAction(), (ServerPlayer)ctx.player()));
    }

    public static void createJump(int action, ServerPlayer player) {
        ItemStack stack = EntityUtils.findEquippedCurio((Entity)player, (Item)((Item)ModItems.BUNNY_HOPPERS.value()));
        Item item = stack.getItem();
        if (!(item instanceof BunnyHoppersItem)) {
            return;
        }
        BunnyHoppersItem relic = (BunnyHoppersItem)item;
        double limit = relic.getStatValue(stack, "hold", "distance");
        stack.set((Supplier)DataComponentRegistry.TIME, (Object)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0) + 1));
        if (action == 0) {
            stack.set((Supplier)DataComponentRegistry.TOGGLED, (Object)false);
            stack.set((Supplier)DataComponentRegistry.TIME, (Object)0);
        } else if (player.onGround()) {
            stack.set((Supplier)DataComponentRegistry.TIME, (Object)0);
        }
        if (Boolean.TRUE.equals(stack.get((Supplier)DataComponentRegistry.TOGGLED)) && (double)((Integer)stack.getOrDefault((Supplier)DataComponentRegistry.TIME, (Object)0)).intValue() <= limit) {
            NetworkHandler.sendToClient((CustomPacketPayload)new PlayerMotionPacket(0.0, 0.2, 0.0), (ServerPlayer)player);
            Random random = new Random();
            ((ServerLevel)player.level()).sendParticles(ParticleUtils.constructSimpleSpark((Color)new Color(200 + random.nextInt(56), 200 + random.nextInt(56), 200 + random.nextInt(56)), (float)0.7f, (int)40, (float)0.9f), player.getX(), player.getY() + 0.1, player.getZ(), 10, 0.3, 0.3, 0.3, 0.02);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public int getAction() {
        return this.action;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PowerJumpPacket)) {
            return false;
        }
        PowerJumpPacket other = (PowerJumpPacket)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getAction() == other.getAction();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PowerJumpPacket;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getAction();
        return result;
    }

    public String toString() {
        return "PowerJumpPacket(action=" + this.getAction() + ")";
    }

    public PowerJumpPacket(int action) {
        this.action = action;
    }
}

