/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityArgument;
import it.hurts.sskirillss.relics.commands.arguments.RelicAbilityStatArgument;
import it.hurts.sskirillss.relics.items.relics.base.IRelicItem;
import it.hurts.sskirillss.relics.items.relics.base.data.RelicData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.AbilityData;
import it.hurts.sskirillss.relics.items.relics.base.data.leveling.StatData;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.server.command.EnumArgument;

public class RelicsCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"relics").requires(sender -> sender.m_6761_(2))).then(Commands.m_82127_((String)"maximize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt1617$temp = stack.m_41720_();
            if (!(patt1617$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt1617$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                AbilityData abilityInfo = abilityEntry.getValue();
                relic.setAbilityPoints(stack, abilityId, abilityInfo.getMaxLevel());
                for (Map.Entry<String, StatData> statEntry : abilityInfo.getStats().entrySet()) {
                    relic.setAbilityValue(stack, abilityId, statEntry.getKey(), (Double)statEntry.getValue().getInitialValue().getValue());
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"minimize").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt3163$temp = stack.m_41720_();
            if (!(patt3163$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt3163$temp;
            RelicData relicData = relic.getRelicData();
            relic.setLevel(stack, relicData.getLeveling().getMaxLevel());
            for (Map.Entry<String, AbilityData> abilityEntry : relicData.getAbilities().getAbilities().entrySet()) {
                String abilityId = abilityEntry.getKey();
                relic.setAbilityPoints(stack, abilityId, 0);
                for (Map.Entry<String, StatData> statEntry : abilityEntry.getValue().getStats().entrySet()) {
                    relic.setAbilityValue(stack, abilityId, statEntry.getKey(), (Double)statEntry.getValue().getInitialValue().getKey());
                }
            }
            return 1;
        }))).then(Commands.m_82127_((String)"level").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt4876$temp = stack.m_41720_();
            if (!(patt4876$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt4876$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int level = IntegerArgumentType.getInteger((CommandContext)context, (String)"level");
            switch (action) {
                case SET: {
                    relic.setLevel(stack, level);
                    break;
                }
                case ADD: {
                    relic.addLevel(stack, level);
                    break;
                }
                case TAKE: {
                    relic.addLevel(stack, -level);
                }
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"experience").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"experience", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt6517$temp = stack.m_41720_();
            if (!(patt6517$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt6517$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int experience = IntegerArgumentType.getInteger((CommandContext)context, (String)"experience");
            switch (action) {
                case SET: {
                    relic.setExperience(stack, experience);
                    break;
                }
                case ADD: {
                    relic.addExperience(stack, experience);
                    break;
                }
                case TAKE: {
                    relic.addExperience(stack, -experience);
                }
            }
            return 1;
        }))))).then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt8190$temp = stack.m_41720_();
            if (!(patt8190$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt8190$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            switch (action) {
                case SET: {
                    relic.setPoints(stack, points);
                    break;
                }
                case ADD: {
                    relic.addPoints(stack, points);
                    break;
                }
                case TAKE: {
                    relic.addPoints(stack, -points);
                }
            }
            return 1;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"ability").then(Commands.m_82127_((String)"points").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"points", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt10086$temp = stack.m_41720_();
            if (!(patt10086$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt10086$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            int points = IntegerArgumentType.getInteger((CommandContext)context, (String)"points");
            if (ability.equals("all")) {
                for (String entry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    switch (action) {
                        case SET: {
                            relic.setAbilityPoints(stack, entry, points);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityPoints(stack, entry, points);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityPoints(stack, entry, -points);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        relic.setAbilityPoints(stack, ability, points);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityPoints(stack, ability, points);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityPoints(stack, ability, -points);
                    }
                }
            }
            return 1;
        })))))).then(Commands.m_82127_((String)"value").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"value", (ArgumentType)DoubleArgumentType.doubleArg()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt13474$temp = stack.m_41720_();
            if (!(patt13474$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt13474$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            double value = DoubleArgumentType.getDouble((CommandContext)context, (String)"value");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            switch (action) {
                                case SET: {
                                    relic.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                switch (action) {
                    case SET: {
                        relic.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"quality").then(Commands.m_82129_((String)"action", (ArgumentType)EnumArgument.enumArgument(CommandAction.class)).then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).then(Commands.m_82129_((String)"quality", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt19612$temp = stack.m_41720_();
            if (!(patt19612$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt19612$temp;
            CommandAction action = (CommandAction)((Object)((Object)context.getArgument("action", CommandAction.class)));
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            int quality = IntegerArgumentType.getInteger((CommandContext)context, (String)"quality");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            double value = relic.getStatByQuality(abilityEntry, statEntry, quality);
                            switch (action) {
                                case SET: {
                                    relic.setAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case ADD: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, value);
                                    break;
                                }
                                case TAKE: {
                                    relic.addAbilityValue(stack, abilityEntry, statEntry, -value);
                                }
                            }
                        }
                        continue;
                    }
                    double value = relic.getStatByQuality(abilityEntry, stat, quality);
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, abilityEntry, stat, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, abilityEntry, stat, -value);
                        }
                    }
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    double value = relic.getStatByQuality(ability, statEntry, quality);
                    switch (action) {
                        case SET: {
                            relic.setAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case ADD: {
                            relic.addAbilityValue(stack, ability, statEntry, value);
                            break;
                        }
                        case TAKE: {
                            relic.addAbilityValue(stack, ability, statEntry, -value);
                        }
                    }
                }
            } else {
                double value = relic.getStatByQuality(ability, stat, quality);
                switch (action) {
                    case SET: {
                        relic.setAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case ADD: {
                        relic.addAbilityValue(stack, ability, stat, value);
                        break;
                    }
                    case TAKE: {
                        relic.addAbilityValue(stack, ability, stat, -value);
                    }
                }
            }
            return 1;
        }))))))).then(Commands.m_82127_((String)"randomize").then(Commands.m_82129_((String)"ability", (ArgumentType)RelicAbilityArgument.ability()).then(Commands.m_82129_((String)"stat", (ArgumentType)RelicAbilityStatArgument.abilityStat()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ItemStack stack = player.m_21120_(InteractionHand.MAIN_HAND);
            Item patt26041$temp = stack.m_41720_();
            if (!(patt26041$temp instanceof IRelicItem)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"command.relics.base.not_relic"));
                return 0;
            }
            IRelicItem relic = (IRelicItem)patt26041$temp;
            String ability = RelicAbilityArgument.getAbility(context, "ability");
            String stat = RelicAbilityStatArgument.getAbilityStat(context, "stat");
            if (ability.equals("all")) {
                for (String abilityEntry : relic.getRelicData().getAbilities().getAbilities().keySet()) {
                    if (stat.equals("all")) {
                        for (String statEntry : relic.getAbilityData(abilityEntry).getStats().keySet()) {
                            relic.randomizeStat(stack, abilityEntry, statEntry);
                        }
                        continue;
                    }
                    relic.randomizeStat(stack, abilityEntry, stat);
                }
            } else if (stat.equals("all")) {
                for (String statEntry : relic.getAbilityData(ability).getStats().keySet()) {
                    relic.randomizeStat(stack, ability, statEntry);
                }
            } else {
                relic.randomizeStat(stack, ability, stat);
            }
            return 1;
        }))))));
    }

    public static enum CommandAction {
        SET,
        ADD,
        TAKE;

    }
}

