/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.logging.LogUtils;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewer;
import io.github.lgatodu47.screenshot_viewer.ScreenshotViewerUtils;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfig;
import io.github.lgatodu47.screenshot_viewer.config.ScreenshotViewerConfigListener;
import io.github.lgatodu47.screenshot_viewer.screens.IconButtonWidget;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ConfirmDeletionScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.EnlargedScreenshotScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageHolder;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotList;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotPropertiesMenu;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotWidget;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ManageScreenshotsScreen
extends Screen
implements ScreenshotViewerConfigListener {
    static final ScreenshotViewerConfig CONFIG = ScreenshotViewer.getInstance().getConfig();
    static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation CONFIG_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/config.png");
    private static final ResourceLocation REFRESH_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/refresh.png");
    private static final ResourceLocation ASCENDING_ORDER_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/ascending_order.png");
    private static final ResourceLocation DESCENDING_ORDER_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/descending_order.png");
    private static final ResourceLocation OPEN_FOLDER_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/open_folder.png");
    private static final ResourceLocation FAST_DELETE_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/delete.png");
    private static final ResourceLocation FAST_DELETE_ENABLED_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/fast_delete_enabled.png");
    private final Screen parent;
    private final EnlargedScreenshotScreen enlargedScreenshot;
    private final ScreenshotPropertiesMenu screenshotProperties;
    private ScreenshotList list;
    private boolean fastDelete;
    @Nullable
    private Screen dialogScreen;
    @Nullable
    private File enlargedScreenshotFile;
    private boolean enlargeAnimation;
    private float screenshotScaleAnimation;
    private boolean isCtrlDown;

    public ManageScreenshotsScreen(Screen parent) {
        super(ScreenshotViewerTexts.MANAGE_SCREENSHOTS);
        this.parent = parent;
        this.enlargedScreenshot = new EnlargedScreenshotScreen(this::showScreenshotProperties);
        this.screenshotProperties = new ScreenshotPropertiesMenu(this::client);
        this.enlargeAnimation = (Boolean)ManageScreenshotsScreen.CONFIG.enableScreenshotEnlargementAnimation.get();
        ScreenshotViewer.getInstance().registerConfigListener(this);
    }

    public ManageScreenshotsScreen(Screen parent, @Nullable File enlargedScreenshotFile) {
        this(parent);
        this.enlargedScreenshotFile = enlargedScreenshotFile;
    }

    Minecraft client() {
        return this.f_96541_;
    }

    public boolean isFastDeleteToggled() {
        return this.fastDelete;
    }

    public void m_86600_() {
        if (this.dialogScreen != null) {
            this.dialogScreen.m_86600_();
        }
    }

    protected void m_7856_() {
        if (this.f_96541_ == null) {
            return;
        }
        int spacing = 8;
        int btnHeight = 20;
        this.enlargedScreenshot.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        int contentWidth = this.f_96543_ - 24;
        int contentHeight = this.f_96544_ - 40 - 20;
        if (this.list == null) {
            this.list = new ScreenshotList(this, 12, 24, this.f_96543_ - 24, this.f_96544_ - 40 - 20);
            this.list.init();
        } else {
            this.list.updateSize(contentWidth, contentHeight);
            this.list.updateChildren(false);
        }
        this.m_7787_((GuiEventListener)this.list);
        int btnY = this.f_96544_ - 8 - 20;
        int btnSize = 20;
        int bigBtnWidth = 200;
        Optional<BiFunction<Minecraft, Screen, Screen>> configScreenFactory = ScreenshotViewer.getInstance().getConfigScreenFactory();
        ExtendedTexturedButtonWidget configButton = new ExtendedTexturedButtonWidget(2, 2, 20, 20, CONFIG_ICON, button -> configScreenFactory.ifPresent(f -> this.f_96541_.m_91152_((Screen)f.apply(this.f_96541_, this))), configScreenFactory.isPresent() ? ScreenshotViewerTexts.CONFIG : ScreenshotViewerTexts.NO_CONFIG, configScreenFactory.isPresent() ? ScreenshotViewerTexts.CONFIG : ScreenshotViewerTexts.NO_CONFIG).offsetTooltip();
        configButton.f_93623_ = configScreenFactory.isPresent();
        this.m_142416_((GuiEventListener)configButton);
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(8, btnY, 20, 20, null, button -> {
            if (this.list != null) {
                this.list.invertOrder();
            }
        }, null, ScreenshotViewerTexts.ORDER){

            @Override
            @Nullable
            protected Component getTooltipText() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? ScreenshotViewerTexts.DESCENDING_ORDER : ScreenshotViewerTexts.ASCENDING_ORDER);
            }

            @Override
            @Nullable
            public ResourceLocation getIconTexture() {
                return ManageScreenshotsScreen.this.list == null ? null : (ManageScreenshotsScreen.this.list.isInvertedOrder() ? DESCENDING_ORDER_ICON : ASCENDING_ORDER_ICON);
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(36, btnY, 20, 20, OPEN_FOLDER_ICON, btn -> Util.m_137581_().m_137644_(new File((String)ManageScreenshotsScreen.CONFIG.screenshotsFolder.get())), ScreenshotViewerTexts.OPEN_FOLDER, ScreenshotViewerTexts.OPEN_FOLDER));
        this.m_142416_((GuiEventListener)new ExtendedButtonWidget((this.f_96543_ - 200) / 2, btnY, 200, 20, CommonComponents.f_130655_, button -> {
            List<ScreenshotWidget> toDelete = this.list.deletionList();
            if (this.fastDelete && !toDelete.isEmpty()) {
                if (((Boolean)ManageScreenshotsScreen.CONFIG.promptWhenDeletingScreenshot.get()).booleanValue()) {
                    this.setDialogScreen((Screen)new ConfirmDeletionScreen(value -> {
                        if (value) {
                            toDelete.forEach(ScreenshotWidget::deleteScreenshot);
                            this.fastDelete = false;
                        }
                        this.setDialogScreen(null);
                    }, (Component)Component.m_237110_((String)"screen.screenshot_viewer.screenshot_manager.delete_n_screenshots", (Object[])new Object[]{toDelete.size()}), toDelete.size() == 1 ? ScreenshotViewerTexts.DELETE_WARNING_MESSAGE : ScreenshotViewerTexts.DELETE_MULTIPLE_WARNING_MESSAGE));
                } else {
                    toDelete.forEach(ScreenshotWidget::deleteScreenshot);
                    this.fastDelete = false;
                }
                return;
            }
            this.m_7379_();
        }){

            @NotNull
            public Component m_6035_() {
                List<ScreenshotWidget> toDelete = ManageScreenshotsScreen.this.list.deletionList();
                if (ManageScreenshotsScreen.this.fastDelete && !toDelete.isEmpty()) {
                    return Component.m_237110_((String)"screen.screenshot_viewer.screenshot_manager.delete_n_screenshots", (Object[])new Object[]{toDelete.size()}).m_130940_(ChatFormatting.RED);
                }
                return super.m_6035_();
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(this.f_96543_ - 16 - 40, btnY, 20, 20, null, button -> {
            boolean bl = this.fastDelete = !this.fastDelete;
            if (!this.fastDelete) {
                this.list.resetDeleteSelection();
            }
        }, ScreenshotViewerTexts.FAST_DELETE, ScreenshotViewerTexts.FAST_DELETE){

            @Override
            public ResourceLocation getIconTexture() {
                return ManageScreenshotsScreen.this.fastDelete ? FAST_DELETE_ENABLED_ICON : FAST_DELETE_ICON;
            }
        });
        this.m_142416_((GuiEventListener)new ExtendedTexturedButtonWidget(this.f_96543_ - 8 - 20, btnY, 20, 20, REFRESH_ICON, button -> this.list.init(), ScreenshotViewerTexts.REFRESH, ScreenshotViewerTexts.REFRESH));
        if (this.enlargedScreenshotFile != null) {
            this.list.findByFileName(this.enlargedScreenshotFile).ifPresentOrElse(this::enlargeScreenshot, () -> LOGGER.warn("Tried to enlarge screenshot with a path '{}' that could not be located in the screenshots folder!", (Object)this.enlargedScreenshotFile.getAbsolutePath()));
            this.enlargedScreenshotFile = null;
        }
    }

    public void m_6574_(@NotNull Minecraft client, int width, int height) {
        super.m_6574_(client, width, height);
        this.enlargedScreenshot.m_6574_(client, width, height);
        if (this.dialogScreen != null) {
            this.dialogScreen.m_6574_(client, width, height);
        }
        this.screenshotProperties.hide();
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        if (this.list != null) {
            this.list.render(graphics, mouseX, mouseY, delta, !this.enlargedScreenshot.renders() && !this.screenshotProperties.renders() && this.dialogScreen == null);
        }
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 8, 0xFFFFFF);
        this.renderActionText(graphics);
        ScreenshotViewerUtils.forEachDrawable(this, drawable -> drawable.m_88315_(graphics, mouseX, mouseY, delta));
        this.screenshotProperties.m_88315_(graphics, mouseX, mouseY, delta);
        PoseStack pose = graphics.m_280168_();
        if (this.enlargedScreenshot.renders()) {
            float animationTime = 1.0f;
            if (this.enlargeAnimation && this.screenshotScaleAnimation < 1.0f) {
                animationTime = (float)(1.0 - Math.pow(1.0f - (this.screenshotScaleAnimation += 0.03f), 3.0));
            }
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 1.0f);
            this.enlargedScreenshot.m_280273_(graphics);
            pose.m_85836_();
            pose.m_252880_((float)this.enlargedScreenshot.f_96543_ / 2.0f * (1.0f - animationTime), (float)this.enlargedScreenshot.f_96544_ / 2.0f * (1.0f - animationTime), 0.0f);
            pose.m_85841_(animationTime, animationTime, animationTime);
            this.enlargedScreenshot.renderImage(graphics);
            pose.m_85849_();
            this.enlargedScreenshot.render(graphics, mouseX, mouseY, delta, !this.screenshotProperties.renders() && this.dialogScreen == null);
            pose.m_85849_();
        } else {
            if (this.screenshotScaleAnimation > 0.0f) {
                this.screenshotScaleAnimation = 0.0f;
            }
            if (!this.screenshotProperties.renders() && this.dialogScreen == null) {
                for (GuiEventListener element : this.m_6702_()) {
                    if (!(element instanceof CustomHoverState)) continue;
                    CustomHoverState hover = (CustomHoverState)element;
                    hover.updateHoveredState(mouseX, mouseY);
                }
            }
        }
        if (this.dialogScreen != null) {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 5.0f);
            this.dialogScreen.m_88315_(graphics, mouseX, mouseY, delta);
            pose.m_85849_();
        } else {
            pose.m_85836_();
            pose.m_252880_(0.0f, 0.0f, 2.0f);
            this.screenshotProperties.m_88315_(graphics, mouseX, mouseY, delta);
            pose.m_85849_();
        }
    }

    private void renderActionText(GuiGraphics context) {
        Component text = this.fastDelete ? ScreenshotViewerTexts.FAST_DELETE_MODE : ScreenshotViewerTexts.ZOOM_MODE;
        context.m_280430_(this.f_96547_, text, this.f_96543_ - this.f_96547_.m_92852_((FormattedText)text) - 8, 8, this.fastDelete ? 15417396 : (this.isCtrlDown ? 1629753 : 15780386));
    }

    void enlargeScreenshot(@Nullable ScreenshotImageHolder showing) {
        if (showing == null) {
            this.enlargedScreenshot.m_7379_();
        }
        this.enlargedScreenshot.show(showing, this.list);
    }

    void showScreenshotProperties(double mouseX, double mouseY, ScreenshotImageHolder widget) {
        if (this.list == null) {
            return;
        }
        this.screenshotProperties.show((int)mouseX, (int)mouseY, this.f_96543_, this.f_96544_, widget);
    }

    void setDialogScreen(Screen screen) {
        if (this.f_96541_ == null) {
            return;
        }
        this.dialogScreen = screen;
        if (this.dialogScreen != null) {
            this.dialogScreen.m_6575_(this.f_96541_, this.f_96543_, this.f_96544_);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7933_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7933_(keyCode, scanCode, modifiers);
        }
        boolean bl = this.isCtrlDown = keyCode == 341 || keyCode == 345;
        if (keyCode == 294) {
            this.list.init();
            return true;
        }
        if (this.list != null && this.list.m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_7920_(keyCode, scanCode, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7920_(keyCode, scanCode, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7920_(keyCode, scanCode, modifiers);
        }
        if (this.isCtrlDown) {
            this.isCtrlDown = false;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_5534_(chr, modifiers);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_5534_(chr, modifiers);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_5534_(chr, modifiers);
        }
        return super.m_5534_(chr, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double verticalMovement) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_6050_(mouseX, mouseY, verticalMovement);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6050_(mouseX, mouseY, verticalMovement);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6050_(mouseX, mouseY, verticalMovement);
        }
        if (this.list != null) {
            if (this.isCtrlDown) {
                this.list.updateScreenshotsPerRow(verticalMovement);
                return true;
            }
            return this.list.m_6050_(mouseX, mouseY, verticalMovement);
        }
        return super.m_6050_(mouseX, mouseY, verticalMovement);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_6375_(mouseX, mouseY, button);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6375_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6375_(mouseX, mouseY, button);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_6348_(mouseX, mouseY, button);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_6348_(mouseX, mouseY, button);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_6348_(mouseX, mouseY, button);
        }
        if (this.list != null) {
            return this.list.m_6348_(mouseX, mouseY, button);
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    @NotNull
    public Optional<GuiEventListener> m_94729_(double mouseX, double mouseY) {
        if (this.dialogScreen != null) {
            return this.dialogScreen.m_94729_(mouseX, mouseY);
        }
        if (this.screenshotProperties.renders()) {
            return this.screenshotProperties.m_94729_(mouseX, mouseY);
        }
        if (this.enlargedScreenshot.renders()) {
            return this.enlargedScreenshot.m_94729_(mouseX, mouseY);
        }
        return super.m_94729_(mouseX, mouseY);
    }

    public void m_7379_() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_(this.parent);
        }
        ScreenshotViewer.getInstance().unregisterConfigListener(this);
    }

    public void m_7861_() {
        this.list.close();
    }

    @Override
    public void onConfigReloaded() {
        this.list.configUpdated();
        this.enlargeAnimation = (Boolean)ManageScreenshotsScreen.CONFIG.enableScreenshotEnlargementAnimation.get();
    }

    public static class ExtendedTexturedButtonWidget
    extends IconButtonWidget
    implements CustomHoverState {
        @Nullable
        private final Component tooltip;
        private boolean offsetTooltip;

        public ExtendedTexturedButtonWidget(int x, int y, int width, int height, @Nullable ResourceLocation texture, Button.OnPress pressAction, @Nullable Component tooltip, Component text) {
            super(x, y, width, height, text, texture, pressAction);
            this.tooltip = tooltip;
            if (tooltip != null) {
                this.m_257544_(Tooltip.m_257550_((Component)tooltip));
            }
        }

        ExtendedTexturedButtonWidget offsetTooltip() {
            this.offsetTooltip = true;
            return this;
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (!this.f_93624_) {
                return;
            }
            this.m_87963_(graphics, mouseX, mouseY, delta);
            this.m_257936_();
        }

        private void m_257936_() {
            Screen screen;
            Component tooltip = this.getTooltipText();
            if (tooltip != null && this.m_274382_() && (screen = Minecraft.m_91087_().f_91080_) != null) {
                screen.m_262791_(Tooltip.m_257550_((Component)tooltip), this.m_262860_(), this.m_93696_());
            }
        }

        @Nullable
        protected Component getTooltipText() {
            return this.tooltip;
        }

        @NotNull
        protected ClientTooltipPositioner m_262860_() {
            ClientTooltipPositioner positioner = DefaultTooltipPositioner.f_262752_;
            return this.offsetTooltip ? (screen_width, screen_height, x, y, w, h) -> positioner.m_262814_(screen_width, screen_height, x, y + this.f_93619_, w, h) : positioner;
        }

        public boolean m_198029_() {
            return this.m_274382_();
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        }
    }

    public static interface CustomHoverState {
        public void updateHoveredState(int var1, int var2);
    }

    public static class ExtendedButtonWidget
    extends Button
    implements CustomHoverState {
        ExtendedButtonWidget(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, Supplier::get);
        }

        public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float delta) {
            if (!this.f_93624_) {
                return;
            }
            super.m_87963_(graphics, mouseX, mouseY, delta);
        }

        public boolean m_198029_() {
            return this.m_274382_();
        }

        @Override
        public void updateHoveredState(int mouseX, int mouseY) {
            this.f_93622_ = mouseX >= this.m_252754_() && mouseY >= this.m_252907_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY < this.m_252907_() + this.f_93619_;
        }
    }
}

