/*
 * Decompiled with CFR 0.152.
 */
package io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lgatodu47.screenshot_viewer.screens.IconButtonWidget;
import io.github.lgatodu47.screenshot_viewer.screens.ScreenshotViewerTexts;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ManageScreenshotsScreen;
import io.github.lgatodu47.screenshot_viewer.screens.manage_screenshots.ScreenshotImageHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.AbstractContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ScreenshotPropertiesMenu
extends AbstractContainerEventHandler
implements Renderable {
    private static final ResourceLocation BACKGROUND_TEXTURE = new ResourceLocation("screenshot_viewer", "textures/gui/screenshot_properties_background.png");
    static final ResourceLocation OPEN_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/open_folder.png");
    static final ResourceLocation COPY_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/copy.png");
    static final ResourceLocation DELETE_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/delete.png");
    static final ResourceLocation RENAME_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/rename.png");
    private static final ResourceLocation CLOSE_ICON = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/icons/close.png");
    private static final int BUTTON_SIZE = 19;
    private final Supplier<Minecraft> mcSupplier;
    private final List<Button> buttons = new ArrayList<Button>();
    private int x;
    private int y;
    private int width;
    private int height;
    private ScreenshotImageHolder targetScreenshot;
    private boolean shouldRender;

    ScreenshotPropertiesMenu(Supplier<Minecraft> mcSupplier) {
        this.mcSupplier = mcSupplier;
        this.addButton(OPEN_ICON, ScreenshotViewerTexts.OPEN_FILE, ScreenshotImageHolder::openFile);
        this.addButton(COPY_ICON, ScreenshotViewerTexts.COPY, ScreenshotImageHolder::copyScreenshot);
        this.addButton(DELETE_ICON, ScreenshotViewerTexts.DELETE, ScreenshotImageHolder::requestFileDeletion);
        this.addButton(RENAME_ICON, ScreenshotViewerTexts.RENAME_FILE, ScreenshotImageHolder::renameFile);
        this.addButton(CLOSE_ICON, ScreenshotViewerTexts.CLOSE_PROPERTIES, null);
    }

    private void addButton(ResourceLocation texture, Component description, @Nullable Consumer<ScreenshotImageHolder> action) {
        this.buttons.add(new Button(texture, description, btn -> {
            if (action != null && this.targetScreenshot != null) {
                action.accept(this.targetScreenshot);
            }
            this.hide();
        }));
    }

    void show(int x, int y, int parentWidth, int parentHeight, ScreenshotImageHolder targetScreenshot) {
        this.targetScreenshot = targetScreenshot;
        int spacing = 2;
        Font font = this.mcSupplier.get().f_91062_;
        int largestTextWidth = this.buttons.stream().map(AbstractWidget::m_6035_).mapToInt(arg_0 -> ((Font)font).m_92852_(arg_0)).max().orElse(0);
        this.width = 4 + Math.max(font.m_92895_(targetScreenshot.getScreenshotFile().getName()), 19 + largestTextWidth + 4);
        Objects.requireNonNull(font);
        this.height = 6 + 9 + 19 * this.buttons.size();
        this.x = x + this.width > parentWidth ? x - this.width : x;
        this.y = y + this.height > parentHeight ? y - this.height : y;
        for (int i = 0; i < this.buttons.size(); ++i) {
            Objects.requireNonNull(font);
            this.buttons.get(i).setDimensionsAndPosition(this.width - 4, this.x + 2, this.y + 4 + 9 + 19 * i);
        }
        this.shouldRender = true;
    }

    void hide() {
        this.shouldRender = false;
        this.height = 0;
        this.width = 0;
        this.y = 0;
        this.x = 0;
    }

    boolean renders() {
        return this.shouldRender;
    }

    public void m_88315_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.shouldRender) {
            PoseStack matrices = context.m_280168_();
            matrices.m_85836_();
            matrices.m_252880_(0.0f, 0.0f, 1.0f);
            int spacing = 2;
            context.m_280163_(BACKGROUND_TEXTURE, this.x, this.y, 0.0f, 0.0f, 2, 2, 8, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y, 6.0f, 0.0f, 2, 2, 8, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x, this.y + this.height - 2, 0.0f, 6.0f, 2, 2, 8, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y + this.height - 2, 6.0f, 6.0f, 2, 2, 8, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + 2, this.y, (float)(this.width * 3) / 2.0f, 0.0f, this.width - 4, 2, this.width * 4, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x, this.y + 2, 0.0f, (float)(this.height * 3) / 2.0f, 2, this.height - 4, 8, this.height * 4);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + 2, this.y + this.height - 2, (float)(this.width * 3) / 2.0f, 6.0f, this.width - 4, 2, this.width * 4, 8);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + this.width - 2, this.y + 2, 6.0f, (float)(this.height * 3) / 2.0f, 2, this.height - 4, 8, this.height * 4);
            context.m_280163_(BACKGROUND_TEXTURE, this.x + 2, this.y + 2, (float)(this.width * 3) / 2.0f, (float)(this.height * 3) / 2.0f, this.width - 4, this.height - 4, this.width * 4, this.height * 4);
            context.m_280488_(this.mcSupplier.get().f_91062_, this.targetScreenshot.getScreenshotFile().getName(), this.x + 2, this.y + 2, -1);
            for (AbstractWidget abstractWidget : this.buttons) {
                abstractWidget.m_88315_(context, mouseX, mouseY, delta);
                matrices.m_85836_();
                matrices.m_252880_(0.0f, 0.0f, 1.0f);
                context.m_280430_(this.mcSupplier.get().f_91062_, abstractWidget.m_6035_(), abstractWidget.m_252754_() + 19 + 2, (int)((float)abstractWidget.m_252907_() + (float)(abstractWidget.m_93694_() - 9) / 2.0f + 2.0f), -1);
                matrices.m_85849_();
            }
            matrices.m_85849_();
        }
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return List.copyOf(this.buttons);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX > (double)(this.x + this.width) || mouseY > (double)(this.y + this.height)) {
            this.hide();
            return false;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.hide();
            return true;
        }
        return false;
    }

    private static final class Button
    extends IconButtonWidget {
        private static final ResourceLocation BUTTON_ENABLED = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/properties_button_enabled.png");
        private static final ResourceLocation BUTTON_DISABLED = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/properties_button.png");
        private static final ResourceLocation BUTTON_HOVERED = new ResourceLocation("screenshot_viewer", "textures/gui/sprites/widget/properties_button_hovered.png");
        private boolean renderWide;

        public Button(ResourceLocation texture, Component title, Button.OnPress pressAction) {
            super(0, 0, 19, 19, title, texture, pressAction);
            this.renderWide = (Boolean)ManageScreenshotsScreen.CONFIG.renderWidePropertiesButton.get();
        }

        public void setDimensionsAndPosition(int width, int x, int y) {
            this.renderWide = (Boolean)ManageScreenshotsScreen.CONFIG.renderWidePropertiesButton.get();
            if (this.renderWide) {
                this.m_93674_(width);
            }
            this.m_264152_(x, y);
        }

        @Override
        public void m_87963_(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
            context.m_280246_(1.0f, 1.0f, 1.0f, this.f_93625_);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            ResourceLocation backgroundTexture = this.getBackgroundTexture(this.f_93623_, this.m_198029_());
            if (this.renderWide) {
                context.m_280163_(backgroundTexture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 1, this.m_93694_(), 19, 19);
                context.m_280411_(backgroundTexture, this.m_252754_() + 1, this.m_252907_(), this.m_5711_() - 2, this.m_93694_(), 1.0f, 0.0f, 17, 19, 19, 19);
                context.m_280163_(backgroundTexture, this.m_252754_() + this.m_5711_() - 1, this.m_252907_(), 18.0f, 0.0f, 1, this.m_93694_(), 19, 19);
            } else {
                context.m_280163_(backgroundTexture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.m_5711_(), this.m_93694_(), 19, 19);
            }
            ResourceLocation icon = this.getIconTexture();
            if (icon != null) {
                context.m_280163_(icon, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, 19, this.m_93694_(), 19, 19);
            }
            context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        }

        public boolean m_198029_() {
            return this.f_93622_;
        }

        public ResourceLocation getBackgroundTexture(boolean enabled, boolean focused) {
            return !enabled ? BUTTON_DISABLED : (focused ? BUTTON_HOVERED : BUTTON_ENABLED);
        }
    }
}

