/*
 * Decompiled with CFR 0.152.
 */
package com.misterpemodder.shulkerboxtooltip.impl.network.forge;

import com.misterpemodder.shulkerboxtooltip.impl.network.ServerNetworking;
import com.misterpemodder.shulkerboxtooltip.impl.network.forge.ChannelListener;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.C2SMessages;
import com.misterpemodder.shulkerboxtooltip.impl.network.message.S2CMessages;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public final class ServerNetworkingImpl {
    @SubscribeEvent
    public static void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        C2SMessages.registerAllFor((ServerPlayer)event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerDisconnect(PlayerEvent.PlayerLoggedOutEvent event) {
        ServerNetworking.removeClient((ServerPlayer)event.getEntity());
    }

    public static void init() {
        C2SMessages.init();
        S2CMessages.init();
        MinecraftForge.EVENT_BUS.register(ServerNetworkingImpl.class);
    }

    public static void registerC2SReceiver(ResourceLocation channelId, ServerPlayer player, ServerNetworking.PacketReceiver receiver) {
        ChannelListener.get((ResourceLocation)channelId).c2sPacketReceiver = receiver;
    }

    public static void unregisterC2SReceiver(ResourceLocation channelId, ServerPlayer player) {
        ChannelListener.get((ResourceLocation)channelId).c2sPacketReceiver = null;
    }

    public static void addRegistrationChangeListener(ResourceLocation channelId, ServerNetworking.RegistrationChangeListener listener) {
        ChannelListener.get((ResourceLocation)channelId).c2sRegChangeListener = listener;
    }
}

