/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.block.entity;

import javax.annotation.Nullable;
import me.dantaeusb.zetter.block.entity.container.ArtistTableGridContainer;
import me.dantaeusb.zetter.core.ItemStackHandlerListener;
import me.dantaeusb.zetter.core.ZetterBlockEntities;
import me.dantaeusb.zetter.menu.ArtistTableMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;

public class ArtistTableBlockEntity
extends BlockEntity
implements ItemStackHandlerListener,
MenuProvider {
    private static final String NBT_TAG_DEPRECATED_ARTIST_TABLE_CANVAS_STORAGE = "canvas_storage";
    private static final String NBT_TAG_ARTIST_TABLE_CANVAS_STORAGE = "CanvasStorage";
    private static final String NBT_TAG_ARTIST_TABLE_MODE = "Mode";
    public static final int DATA_MODE = 0;
    private final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int slot) {
            if (slot == 0) {
                return ArtistTableBlockEntity.this.mode.getId();
            }
            return 0;
        }

        public void m_8050_(int slot, int value) {
            if (slot == 0) {
                ArtistTableBlockEntity.this.mode = ArtistTableMenu.Mode.getById((byte)value);
            }
        }

        public int m_6499_() {
            return 1;
        }
    };
    private ArtistTableGridContainer artistTableGridContainer;
    private final LazyOptional<ItemStackHandler> artistTableContainerOptional = LazyOptional.of(() -> this.artistTableGridContainer);
    private ArtistTableMenu.Mode mode = ArtistTableMenu.Mode.COMBINE;

    public ArtistTableBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ZetterBlockEntities.ARTIST_TABLE_BLOCK_ENTITY.get(), pos, state);
        this.createInventory();
    }

    public ArtistTableMenu.Mode getMode() {
        return this.mode;
    }

    public void setMode(ArtistTableMenu.Mode mode) {
        this.mode = mode;
    }

    protected void createInventory() {
        ArtistTableGridContainer currentArtistTableContainer = this.artistTableGridContainer;
        this.artistTableGridContainer = new ArtistTableGridContainer(this);
        if (currentArtistTableContainer != null) {
            int i = Math.min(currentArtistTableContainer.getSlots(), this.artistTableGridContainer.getSlots());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = currentArtistTableContainer.getStackInSlot(j);
                if (itemstack.m_41619_()) continue;
                this.artistTableGridContainer.setStackInSlot(j, itemstack.m_41777_());
            }
        }
        this.artistTableGridContainer.addListener(this);
    }

    public boolean canPlayerAccessInventory(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public void containerChanged(ItemStackHandler container, int slot) {
        this.m_6596_();
    }

    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_(), this.m_58899_().m_7918_(1, 1, 1));
    }

    public void m_183515_(CompoundTag compoundTag) {
        CompoundTag gridContainer = this.artistTableGridContainer.serializeNBT();
        compoundTag.m_128365_(NBT_TAG_ARTIST_TABLE_CANVAS_STORAGE, (Tag)gridContainer);
        compoundTag.m_128344_(NBT_TAG_ARTIST_TABLE_MODE, this.mode.getId());
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        CompoundTag canvasStorageTag = compoundTag.m_128441_(NBT_TAG_ARTIST_TABLE_CANVAS_STORAGE) ? compoundTag.m_128469_(NBT_TAG_ARTIST_TABLE_CANVAS_STORAGE) : compoundTag.m_128469_(NBT_TAG_DEPRECATED_ARTIST_TABLE_CANVAS_STORAGE);
        this.artistTableGridContainer.deserializeNBT(canvasStorageTag);
        if (this.artistTableGridContainer.getSlots() != 16) {
            throw new IllegalArgumentException("Corrupted NBT: Number of inventory slots did not match expected.");
        }
        if (compoundTag.m_128441_(NBT_TAG_ARTIST_TABLE_MODE)) {
            byte modeId = compoundTag.m_128445_(NBT_TAG_ARTIST_TABLE_MODE);
            this.mode = ArtistTableMenu.Mode.getById(modeId);
        } else {
            this.mode = ArtistTableMenu.Mode.COMBINE;
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public CompoundTag m_5995_() {
        CompoundTag nbtTagCompound = new CompoundTag();
        this.m_183515_(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }

    public void dropAllContents(Level world, BlockPos blockPos) {
        for (int i = 0; i < this.artistTableGridContainer.getSlots(); ++i) {
            Containers.m_18992_((Level)this.f_58857_, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)this.artistTableGridContainer.getStackInSlot(i));
        }
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"container.zetter.artistTable");
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction direction) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && (direction == null || direction == Direction.UP || direction == Direction.DOWN)) {
            return this.artistTableContainerOptional.cast();
        }
        return super.getCapability(capability, direction);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowID, Inventory playerInventory, Player playerEntity) {
        return ArtistTableMenu.createMenuServerSide(windowID, playerInventory, this.artistTableGridContainer, this.dataAccess, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.m_58899_()));
    }
}

