/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.canvastracker;

import com.google.common.collect.Maps;
import java.util.BitSet;
import java.util.Map;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.client.renderer.CanvasRenderer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterNetwork;
import me.dantaeusb.zetter.event.CanvasRegisterEvent;
import me.dantaeusb.zetter.event.CanvasUnregisterEvent;
import me.dantaeusb.zetter.menu.artisttable.CanvasCombinationAction;
import me.dantaeusb.zetter.network.packet.CCanvasUnloadRequestPacket;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasData;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class CanvasClientTracker
implements CanvasTracker {
    private Level level;
    Map<String, AbstractCanvasData> canvases = Maps.newHashMap();
    Map<String, Long> timestamps = Maps.newHashMap();

    @Override
    public void setLevel(Level level) {
        if (this.level != null) {
            throw new IllegalStateException("Cannot change level for capability");
        }
        this.level = level;
        for (int[] size : CanvasCombinationAction.paintingShapes) {
            int resolution = Helper.getResolution().getNumeric();
            int width = size[0];
            int height = size[1];
            String canvasCode = CanvasData.getDefaultCanvasCode(width, height);
            CanvasData canvasData = CanvasData.BUILDER.createFresh(Helper.getResolution(), width * resolution, height * resolution);
            canvasData.setManaged(false);
            this.canvases.put(canvasCode, canvasData);
            CanvasRenderer.getInstance().addCanvas(canvasCode, canvasData);
        }
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    @Nullable
    public <T extends AbstractCanvasData> T getCanvasData(String canvasCode) {
        return (T)((Object)this.canvases.get(canvasCode));
    }

    @Override
    public void registerCanvasData(String canvasCode, AbstractCanvasData canvasData, long timestamp) {
        if (this.timestamps.containsKey(canvasCode) && this.timestamps.get(canvasCode) > timestamp) {
            Zetter.LOG.warn("Trying to sync canvas with an older texture!");
            return;
        }
        CanvasRegisterEvent.Pre preEvent = new CanvasRegisterEvent.Pre(canvasCode, canvasData, this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        if (!preEvent.isCanceled()) {
            this.canvases.put(canvasCode, canvasData);
            this.timestamps.put(canvasCode, timestamp);
            CanvasRenderer.getInstance().addCanvas(canvasCode, canvasData);
        }
        CanvasRegisterEvent.Post postEvent = new CanvasRegisterEvent.Post(canvasCode, canvasData, this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    @Override
    public void unregisterCanvasData(String removedCanvasCode) {
        Object canvasData = this.getCanvasData(removedCanvasCode);
        if (canvasData == null) {
            Zetter.LOG.error("Cannot unregister not-registered canvas " + removedCanvasCode);
            return;
        }
        long timestamp = System.currentTimeMillis();
        CanvasUnregisterEvent.Pre preEvent = new CanvasUnregisterEvent.Pre(removedCanvasCode, (AbstractCanvasData)((Object)canvasData), this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        this.canvases.remove(removedCanvasCode);
        CanvasRenderer.getInstance().removeCanvas(removedCanvasCode);
        if (((AbstractCanvasData)((Object)canvasData)).isManaged()) {
            CCanvasUnloadRequestPacket unloadPacket = new CCanvasUnloadRequestPacket(removedCanvasCode);
            ZetterNetwork.simpleChannel.sendToServer((Object)unloadPacket);
        }
        CanvasUnregisterEvent.Post postEvent = new CanvasUnregisterEvent.Post(removedCanvasCode, (AbstractCanvasData)((Object)canvasData), this.level, timestamp);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
    }

    @Override
    public BitSet getCanvasIds() {
        throw new IllegalStateException("Client does not store authoritative canvas tracking information");
    }

    @Override
    public void setCanvasIds(BitSet canvasIds) {
        throw new IllegalStateException("Client does not store authoritative canvas tracking information");
    }

    @Override
    public int getLastCanvasId() {
        throw new IllegalStateException("Client does not store authoritative canvas tracking information");
    }

    @Override
    public void setLastPaintingId(int id) {
        throw new IllegalStateException("Client does not store authoritative canvas tracking information");
    }

    @Override
    public int getLastPaintingId() {
        throw new IllegalStateException("Client does not store authoritative canvas tracking information");
    }
}

