/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.canvastracker;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.dantaeusb.zetter.capability.canvastracker.CanvasClientTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTrackerStorage;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class CanvasTrackerProvider
implements ICapabilitySerializable<CompoundTag> {
    private final CanvasTracker canvasTracker;
    private final String TAG_NAME_CANVAS_TRACKER = "canvasTracker";

    public CanvasTrackerProvider(Level world) {
        this.canvasTracker = world.m_5776_() ? new CanvasClientTracker() : new CanvasServerTracker();
        this.canvasTracker.setLevel(world);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (ZetterCapabilities.CANVAS_TRACKER == capability) {
            return LazyOptional.of(() -> this.canvasTracker);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundTag = new CompoundTag();
        if (this.canvasTracker.getLevel() == null || this.canvasTracker.getLevel().m_5776_()) {
            return compoundTag;
        }
        Tag canvasTrackerTag = CanvasTrackerStorage.save(this.canvasTracker);
        compoundTag.m_128365_("canvasTracker", canvasTrackerTag);
        return compoundTag;
    }

    public void deserializeNBT(CompoundTag compoundTag) {
        if (this.canvasTracker.getLevel() == null || this.canvasTracker.getLevel().m_5776_()) {
            return;
        }
        Tag canvasTrackerTag = compoundTag.m_128423_("canvasTracker");
        if (canvasTrackerTag == null) {
            return;
        }
        CanvasTrackerStorage.load(this.canvasTracker, canvasTrackerTag);
    }
}

