/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.capability.canvastracker;

import java.util.BitSet;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class CanvasTrackerStorage {
    private static final String NBT_TAG_CANVAS_LAST_ID = "LastCanvasId";
    private static final String NBT_TAG_CANVAS_IDS = "CanvasIds";
    private static final String NBT_TAG_PAINTING_LAST_ID = "LastPaintingId";

    public static Tag save(CanvasTracker canvasTracker) {
        CompoundTag compound = new CompoundTag();
        compound.m_128382_(NBT_TAG_CANVAS_IDS, canvasTracker.getCanvasIds().toByteArray());
        compound.m_128405_(NBT_TAG_CANVAS_LAST_ID, canvasTracker.getLastCanvasId());
        compound.m_128405_(NBT_TAG_PAINTING_LAST_ID, canvasTracker.getLastPaintingId());
        return compound;
    }

    public static void load(CanvasTracker canvasTracker, Tag tag) {
        if (tag.m_6458_() == CompoundTag.f_128326_) {
            CompoundTag compoundTag = (CompoundTag)tag;
            if (compoundTag.m_128441_(NBT_TAG_CANVAS_IDS)) {
                byte[] canvasIds = compoundTag.m_128463_(NBT_TAG_CANVAS_IDS);
                canvasTracker.setCanvasIds(BitSet.valueOf(canvasIds));
            } else if (compoundTag.m_128441_(NBT_TAG_CANVAS_LAST_ID)) {
                int lastCanvasId = compoundTag.m_128451_(NBT_TAG_CANVAS_LAST_ID);
                BitSet canvasIds = new BitSet(lastCanvasId + 1);
                canvasIds.flip(0, lastCanvasId + 1);
                canvasTracker.setCanvasIds(canvasIds);
            } else {
                canvasTracker.setCanvasIds(new BitSet());
            }
            canvasTracker.setLastPaintingId(compoundTag.m_128451_(NBT_TAG_PAINTING_LAST_ID));
        }
    }
}

