/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import me.dantaeusb.zetter.client.gui.overlay.CanvasOverlay;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.CanvasDataType;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.StringUtil;
import net.minecraftforge.client.gui.overlay.ForgeGui;

public class PaintingInfoOverlay
implements CanvasOverlay<PaintingData> {
    private static final Component BANNED_TEXT = Component.m_237115_((String)"painting.zetter.banned");
    protected PaintingData paintingData = null;
    protected int overlayMessageTime = 0;

    @Override
    public String getId() {
        return "painting_info";
    }

    @Override
    public CanvasDataType<PaintingData> getType() {
        return (CanvasDataType)ZetterCanvasTypes.PAINTING.get();
    }

    @Override
    public void setCanvasData(PaintingData canvasData) {
        this.paintingData = canvasData;
        this.overlayMessageTime = 300;
    }

    @Override
    public void hide() {
        this.paintingData = null;
    }

    @Override
    public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Component title;
        if (this.paintingData == null) {
            return;
        }
        if (this.overlayMessageTime <= 0) {
            this.paintingData = null;
            return;
        }
        if (!this.paintingData.isBanned()) {
            String paintingName = this.paintingData.getPaintingName();
            String authorName = this.paintingData.getAuthorName();
            if (StringUtil.m_14408_((String)paintingName)) {
                paintingName = Component.m_237115_((String)"item.zetter.painting.unnamed").getString();
            }
            if (StringUtil.m_14408_((String)authorName)) {
                authorName = Component.m_237115_((String)"item.zetter.painting.unknown").getString();
            }
            title = Component.m_237110_((String)"item.zetter.customPaintingByAuthor", (Object[])new Object[]{paintingName, authorName});
        } else {
            title = BANNED_TEXT;
        }
        float ticksLeft = (float)this.overlayMessageTime - partialTick;
        int msLeft = (int)(ticksLeft * 255.0f / 20.0f);
        if (msLeft > 255) {
            msLeft = 255;
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        if (msLeft > 8) {
            poseStack.m_85836_();
            poseStack.m_85837_((double)(screenWidth / 2), (double)(screenHeight - 68), 0.0);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            int textColor = 0xFFFFFF;
            int transparencyMask = msLeft << 24 & 0xFF000000;
            int titleLength = gui.m_93082_().m_92852_((FormattedText)title);
            this.drawBackdrop(guiGraphics, -4, titleLength, 0xFFFFFF | transparencyMask);
            guiGraphics.m_280614_(gui.m_93082_(), title, -titleLength / 2, -4, textColor | transparencyMask, true);
            RenderSystem.disableBlend();
            poseStack.m_85849_();
        }
    }

    protected void drawBackdrop(GuiGraphics guiGraphics, int heightOffset, int messageWidth, int color) {
        int backgroundColor = Minecraft.m_91087_().f_91066_.m_92170_(0.0f);
        if (backgroundColor != 0) {
            int horizontalOffset = -messageWidth / 2;
            guiGraphics.m_280509_(horizontalOffset - 2, heightOffset - 2, horizontalOffset + messageWidth + 2, heightOffset + 9 + 2, FastColor.ARGB32.m_13657_((int)backgroundColor, (int)color));
        }
    }

    @Override
    public void tick() {
        if (this.overlayMessageTime > 0) {
            --this.overlayMessageTime;
        }
    }
}

