/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import me.dantaeusb.zetter.ZetterConfig;
import me.dantaeusb.zetter.capability.canvastracker.CanvasServerTracker;
import me.dantaeusb.zetter.capability.canvastracker.CanvasTracker;
import me.dantaeusb.zetter.capability.paintingregistry.PaintingRegistry;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.core.ZetterCapabilities;
import me.dantaeusb.zetter.entity.item.PaintingEntity;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.PaintingData;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class Helper {
    public static final int DUMMY_BLACK_COLOR = -16777216;
    public static final int DUMMY_PINK_COLOR = -65281;
    public static final int CANVAS_COLOR = -2041138;
    public static final String COMBINED_CANVAS_CODE = "zetter_combined_canvas";
    public static final String FALLBACK_CANVAS_CODE = "zetter_fallback_canvas";
    public static final int CANVAS_CODE_MAX_LENGTH = 64;
    public static final int PAINTING_TITLE_MAX_LENGTH = 32;

    public static AbstractCanvasData.Resolution getBasicResolution() {
        return AbstractCanvasData.Resolution.x16;
    }

    public static AbstractCanvasData.Resolution getResolution() {
        int resolution = 16;
        switch ((String)ZetterConfig.SERVER.resolution.get()) {
            case "x64": {
                resolution = 64;
                break;
            }
            case "x32": {
                resolution = 32;
                break;
            }
        }
        return AbstractCanvasData.Resolution.get(resolution);
    }

    public static CanvasTracker getLevelCanvasTracker(Level level) {
        CanvasTracker canvasTracker = !level.m_5776_() ? (CanvasTracker)level.m_7654_().m_129783_().getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null) : (CanvasTracker)level.getCapability(ZetterCapabilities.CANVAS_TRACKER).orElse(null);
        return canvasTracker;
    }

    public static PaintingRegistry getLevelPaintingRegistry(Level world) {
        if (world.m_5776_()) {
            throw new IllegalArgumentException("Painting Registry is not supposed to exist on client");
        }
        PaintingRegistry paintingRegistry = (PaintingRegistry)world.m_7654_().m_129783_().getCapability(ZetterCapabilities.PAINTING_REGISTRY).orElse(null);
        return paintingRegistry;
    }

    public static String getFrameKey(PaintingEntity.Materials material, boolean plated) {
        Object key = material.toString();
        if (plated) {
            key = (String)key + "/plated";
        }
        return key;
    }

    @Nullable
    public static UUID tryToRestoreAuthorUuid(ServerLevel level, String authorNickname) {
        List playersWithAuthorNickname = level.m_8795_(serverPlayer -> serverPlayer.m_7755_().getString().equals(authorNickname));
        if (playersWithAuthorNickname.size() == 1) {
            return ((ServerPlayer)playersWithAuthorNickname.get(0)).m_20148_();
        }
        return null;
    }

    public static void exportPainting(File rootDirectory, String canvasCode, PaintingData paintingData) throws IOException {
        File exportDirectory = new File(rootDirectory, "zetter");
        if (!exportDirectory.exists()) {
            if (!exportDirectory.mkdir()) {
                throw new IOException(Component.m_237115_((String)"console.zetter.error.file_write_folder_unable").getString());
            }
        } else if (!exportDirectory.isDirectory()) {
            throw new IOException(Component.m_237115_((String)"console.zetter.error.file_write_folder_exists").getString());
        }
        Object name = paintingData.getPaintingName().replaceAll(" ", "-");
        if (((String)(name = ((String)name).replaceAll("[^a-zA-Z0-9.-]", ""))).isEmpty()) {
            name = canvasCode;
        }
        int maxLength = Math.min(((String)name).length(), 32);
        name = ((String)name).substring(0, maxLength) + "_" + Util.m_241986_();
        File exportFile = new File(exportDirectory, (String)name + ".png");
        int width = paintingData.getWidth();
        int height = paintingData.getHeight();
        BufferedImage bufferedImage = new BufferedImage(width, height, 2);
        IntBuffer colorByteBuffer = ByteBuffer.wrap(paintingData.getColorData()).asIntBuffer();
        int[] colorIntArray = new int[colorByteBuffer.remaining()];
        colorByteBuffer.get(colorIntArray);
        bufferedImage.setRGB(0, 0, width, height, colorIntArray, 0, width);
        try {
            ImageIO.write((RenderedImage)bufferedImage, "PNG", exportFile);
        }
        catch (IOException e) {
            throw new IOException(Component.m_237115_((String)"console.zetter.error.file_write_file").getString());
        }
    }

    @Nullable
    public static String lookupPaintingCodeByName(String paintingName, Level level) {
        CanvasServerTracker canvasTracker = (CanvasServerTracker)Helper.getLevelCanvasTracker(level);
        for (int id = 0; id < canvasTracker.getLastPaintingId() + 1; ++id) {
            String code = PaintingData.getCanvasCode(id);
            PaintingData paintingData = (PaintingData)((Object)canvasTracker.getCanvasData(code));
            if (paintingData == null || !paintingData.getType().equals(ZetterCanvasTypes.PAINTING.get()) || !paintingData.getPaintingName().equals(paintingName)) continue;
            return code;
        }
        return null;
    }
}

