/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.network.packet;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Supplier;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.entity.item.state.representation.CanvasAction;
import me.dantaeusb.zetter.network.ServerHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class CCanvasActionPacket {
    public final int easelEntityId;
    public final Queue<CanvasAction> paintingActions;

    public CCanvasActionPacket(int entityId) {
        this.easelEntityId = entityId;
        this.paintingActions = new ArrayDeque<CanvasAction>();
    }

    public CCanvasActionPacket(int entityId, Queue<CanvasAction> paintingActionBuffers) {
        this.easelEntityId = entityId;
        this.paintingActions = paintingActionBuffers;
    }

    public static CCanvasActionPacket readPacketData(FriendlyByteBuf networkBuffer) {
        int entityId = networkBuffer.readInt();
        int actionBuffersCount = networkBuffer.readInt();
        CCanvasActionPacket packet = new CCanvasActionPacket(entityId);
        for (int i = 0; i < actionBuffersCount; ++i) {
            CanvasAction action = CanvasAction.readPacketData(networkBuffer);
            if (action != null) {
                packet.paintingActions.add(action);
                continue;
            }
            Zetter.LOG.error("Cannot retrieve actions from buffer");
        }
        return packet;
    }

    public void writePacketData(FriendlyByteBuf networkBuffer) {
        networkBuffer.writeInt(this.easelEntityId);
        networkBuffer.writeInt(this.paintingActions.size());
        for (CanvasAction actionBuffer : this.paintingActions) {
            CanvasAction.writePacketData(actionBuffer, networkBuffer);
        }
    }

    public static void handle(CCanvasActionPacket packetIn, Supplier<NetworkEvent.Context> ctxSupplier) {
        NetworkEvent.Context ctx = ctxSupplier.get();
        ctx.setPacketHandled(true);
        ServerPlayer sendingPlayer = ctx.getSender();
        if (sendingPlayer == null) {
            Zetter.LOG.warn("EntityPlayerMP was null when CPaintingUpdatePacket was received");
        }
        ctx.enqueueWork(() -> ServerHandler.processAction(packetIn, sendingPlayer));
    }
}

