/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.server.command;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import me.dantaeusb.zetter.server.command.PaintingInput;
import net.minecraft.network.chat.Component;

public class PaintingLookupArgument
implements ArgumentType<PaintingInput> {
    private static final Collection<String> EXAMPLES = Arrays.asList("12", "zetter_painting_12", "Painting", "\"My Painting\"");
    private static final Pattern ID = Pattern.compile("\\p{javaDigit}+");
    private static final Pattern CODE = Pattern.compile("zetter_painting_\\p{javaDigit}+");
    private static final DynamicCommandExceptionType ERROR_INVALID_PAINTING_CODE = new DynamicCommandExceptionType(code -> Component.m_237110_((String)"console.zetter.error.invalid_painting_code", (Object[])new Object[]{code}));

    public static PaintingLookupArgument painting() {
        return new PaintingLookupArgument();
    }

    public PaintingInput parse(StringReader reader) throws CommandSyntaxException {
        String input = StringReader.isQuotedStringStart((char)reader.peek()) ? reader.readQuotedString() : reader.readUnquotedString();
        try {
            if (ID.matcher(input).matches()) {
                return PaintingInput.fromId(Integer.parseInt(input));
            }
            if (CODE.matcher(input).matches()) {
                return PaintingInput.fromCode(input);
            }
            return PaintingInput.fromTitle(input);
        }
        catch (NumberFormatException e) {
            throw ERROR_INVALID_PAINTING_CODE.create((Object)input);
        }
    }

    public static <S> PaintingInput getPaintingInput(CommandContext<S> context, String argumentName) {
        return (PaintingInput)context.getArgument(argumentName, PaintingInput.class);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }
}

