/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataBuilder;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class CanvasData
extends AbstractCanvasData {
    public static final String TYPE = "canvas";
    public static final String CODE_PREFIX = "zetter_canvas_";
    public static final CanvasDataBuilder<CanvasData> BUILDER = new CanvasCanvasDataBuilder();

    public static String getCanvasCode(int canvasId) {
        return CODE_PREFIX + canvasId;
    }

    public static String getDefaultCanvasCode(int widthBlocks, int heightBlocks) {
        return "zetter_canvas_default_" + widthBlocks + "x" + heightBlocks;
    }

    protected CanvasData() {
    }

    @Override
    public boolean isRenderable() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return this.managed;
    }

    public CanvasDataType<? extends CanvasData> getType() {
        return (CanvasDataType)ZetterCanvasTypes.CANVAS.get();
    }

    @Override
    public CompoundTag m_7176_(CompoundTag compoundTag) {
        return super.m_7176_(compoundTag);
    }

    private static class CanvasCanvasDataBuilder
    implements CanvasDataBuilder<CanvasData> {
        private CanvasCanvasDataBuilder() {
        }

        @Override
        public CanvasData createFresh(AbstractCanvasData.Resolution resolution, int width, int height) {
            byte[] color = new byte[width * height * 4];
            ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
            for (int x = 0; x < width * height; ++x) {
                defaultColorBuffer.putInt(x * 4, -2041138);
            }
            CanvasData newCanvas = new CanvasData();
            newCanvas.wrapData(resolution, width, height, color);
            return newCanvas;
        }

        @Override
        public CanvasData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
            CanvasData newCanvas = new CanvasData();
            newCanvas.wrapData(resolution, width, height, color);
            return newCanvas;
        }

        @Override
        public CanvasData load(CompoundTag compoundTag) {
            CanvasData newCanvas = new CanvasData();
            newCanvas.width = compoundTag.m_128451_("width");
            newCanvas.height = compoundTag.m_128451_("height");
            if (compoundTag.m_128441_("resolution")) {
                int resolutionOrdinal = compoundTag.m_128451_("resolution");
                newCanvas.resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            } else {
                newCanvas.resolution = Helper.getResolution();
            }
            newCanvas.updateColorData(compoundTag.m_128463_("color"));
            return newCanvas;
        }

        @Override
        public CanvasData readPacketData(FriendlyByteBuf networkBuffer) {
            CanvasData newCanvas = new CanvasData();
            byte resolutionOrdinal = networkBuffer.readByte();
            AbstractCanvasData.Resolution resolution = AbstractCanvasData.Resolution.values()[resolutionOrdinal];
            int width = networkBuffer.readInt();
            int height = networkBuffer.readInt();
            int colorDataSize = networkBuffer.readInt();
            ByteBuffer colorData = networkBuffer.readBytes(colorDataSize).nioBuffer();
            byte[] unwrappedColorData = new byte[width * height * 4];
            colorData.get(unwrappedColorData);
            newCanvas.wrapData(resolution, width, height, unwrappedColorData);
            return newCanvas;
        }

        @Override
        public void writePacketData(CanvasData canvasData, FriendlyByteBuf networkBuffer) {
            networkBuffer.writeByte(canvasData.resolution.ordinal());
            networkBuffer.writeInt(canvasData.width);
            networkBuffer.writeInt(canvasData.height);
            networkBuffer.writeInt(canvasData.getColorDataBuffer().remaining());
            networkBuffer.writeBytes(canvasData.getColorDataBuffer());
        }
    }
}

