/*
 * Decompiled with CFR 0.152.
 */
package me.dantaeusb.zetter.storage;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import me.dantaeusb.zetter.Zetter;
import me.dantaeusb.zetter.core.Helper;
import me.dantaeusb.zetter.core.ZetterCanvasTypes;
import me.dantaeusb.zetter.storage.AbstractCanvasData;
import me.dantaeusb.zetter.storage.CanvasDataBuilder;
import me.dantaeusb.zetter.storage.CanvasDataType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;

public class DummyCanvasData
extends AbstractCanvasData {
    public static final String TYPE = "dummy";
    public static final String CODE_PREFIX = "zetter_dummy_";
    public static final CanvasDataBuilder<DummyCanvasData> BUILDER = new DummyCanvasDataBuilder();

    protected DummyCanvasData() {
    }

    public static DummyCanvasData createDummy() {
        int width = Helper.getResolution().getNumeric();
        int height = Helper.getResolution().getNumeric();
        AbstractCanvasData.Resolution resolution = Helper.getResolution();
        return DummyCanvasData.createDummy(resolution, width, height);
    }

    public static DummyCanvasData createDummy(AbstractCanvasData.Resolution resolution, int width, int height) {
        byte[] color = new byte[width * height * 4];
        ByteBuffer defaultColorBuffer = ByteBuffer.wrap(color);
        int halfResolution = resolution.getNumeric() / 2;
        for (int x = 0; x < width * height; ++x) {
            defaultColorBuffer.putInt(x * 4, x / width % resolution.getNumeric() >= halfResolution ? (x % resolution.getNumeric() < halfResolution ? -65281 : -16777216) : (x % resolution.getNumeric() < halfResolution ? -16777216 : -65281));
        }
        DummyCanvasData newDummyCanvas = new DummyCanvasData();
        newDummyCanvas.wrapData(resolution, width, height, color);
        return newDummyCanvas;
    }

    @Override
    public void updateColorData(byte[] color) {
        this.color = color;
        this.canvasBuffer = ByteBuffer.wrap(this.color);
        this.canvasBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public boolean isManaged() {
        return false;
    }

    @Override
    public boolean isRenderable() {
        return true;
    }

    @Override
    public boolean isEditable() {
        return false;
    }

    public CanvasDataType<DummyCanvasData> getType() {
        return (CanvasDataType)ZetterCanvasTypes.DUMMY.get();
    }

    private static class DummyCanvasDataBuilder
    implements CanvasDataBuilder<DummyCanvasData> {
        private DummyCanvasDataBuilder() {
        }

        @Override
        public DummyCanvasData createFresh(AbstractCanvasData.Resolution resolution, int width, int height) {
            return DummyCanvasData.createDummy(resolution, width, height);
        }

        @Override
        public DummyCanvasData createWrap(AbstractCanvasData.Resolution resolution, int width, int height, byte[] color) {
            DummyCanvasData newCanvas = new DummyCanvasData();
            newCanvas.wrapData(resolution, width, height, color);
            return newCanvas;
        }

        @Override
        public DummyCanvasData load(CompoundTag compoundTag) {
            Zetter.LOG.error("Trying to read into dummy canvas!");
            return DummyCanvasData.createDummy();
        }

        public CompoundTag save(CompoundTag compoundTag) {
            Zetter.LOG.error("Trying to save dummy canvas!");
            return compoundTag;
        }

        @Override
        public DummyCanvasData readPacketData(FriendlyByteBuf networkBuffer) {
            throw new IllegalStateException("Trying to read Dummy Canvas from network!");
        }

        @Override
        public void writePacketData(DummyCanvasData canvasData, FriendlyByteBuf networkBuffer) {
            throw new IllegalStateException("Trying to write Dummy Canvas to network!");
        }
    }
}

