/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.archaic;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import dev.nolij.zume.archaic.ZumeKeyBind;
import dev.nolij.zume.archaic.mixin.EntityRendererAccessor;
import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.MouseFilter;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;

@Mod(modid="zume", name="Zume", version="0.18.0", acceptedMinecraftVersions="[1.7.10]", guiFactory="dev.nolij.zume.archaic.ArchaicConfigProvider", dependencies="required-after:unimixins@[0.1.15,)")
public class ArchaicZume
implements IZumeImplementation {
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent fMLPreInitializationEvent) {
        if (!FMLLaunchHandler.side().isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading Archaic Zume...");
        Zume.init(this, Launch.minecraftHome.toPath().resolve("config"));
        if (Zume.disabled) {
            return;
        }
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)zumeKeyBind.value);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isZoomPressed() {
        return Minecraft.func_71410_x().field_71462_r == null && ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        return CameraPerspective.values()[Minecraft.func_71410_x().field_71474_y.field_74320_O];
    }

    @Override
    public void onZoomActivate() {
        if (Zume.config.enableCinematicZoom && !Minecraft.func_71410_x().field_71474_y.field_74326_T) {
            EntityRendererAccessor entityRendererAccessor = (EntityRendererAccessor)Minecraft.func_71410_x().field_71460_t;
            entityRendererAccessor.setMouseFilterXAxis(new MouseFilter());
            entityRendererAccessor.setMouseFilterYAxis(new MouseFilter());
            entityRendererAccessor.setSmoothCamYaw(0.0f);
            entityRendererAccessor.setSmoothCamPitch(0.0f);
            entityRendererAccessor.setSmoothCamFilterX(0.0f);
            entityRendererAccessor.setSmoothCamFilterY(0.0f);
            entityRendererAccessor.setSmoothCamPartialTicks(0.0f);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void mouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.dwheel;
        if (Zume.interceptScroll(n)) {
            mouseEvent.setCanceled(true);
        }
    }
}

