/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.common;

import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.HostPlatform;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.ZumeVariant;
import dev.nolij.zume.common.config.ZumeConfig;
import dev.nolij.zume.common.easing.EasedDouble;
import dev.nolij.zume.common.easing.EasingHelper;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Zume {
    private static final ClassLoader CLASS_LOADER = Zume.class.getClassLoader();
    public static final String MOD_ID = "zume";
    public static final Logger LOGGER = LogManager.getLogger((String)"zume");
    public static final String CONFIG_FILE_NAME = "zume.json5";
    public static final ZumeVariant ZUME_VARIANT;
    public static final HostPlatform HOST_PLATFORM;
    public static IZumeImplementation implementation;
    public static ZumeConfig config;
    public static boolean disabled;
    private static final EasedDouble zoom;
    private static int scrollDelta;
    private static boolean wasHeld;
    private static boolean zooming;
    private static boolean wasZooming;
    private static long prevRenderTimestamp;

    private static int sign(int n) {
        return n >> 31 | 1;
    }

    private static double clamp(double d) {
        return Math.max(Math.min(d, 1.0), 0.0);
    }

    static void calculateZumeVariant() {
    }

    public static void init(IZumeImplementation iZumeImplementation, Path path) {
        if (implementation != null) {
            throw new AssertionError((Object)"Zume already initialized!");
        }
        implementation = iZumeImplementation;
        ZumeConfig.init(path, CONFIG_FILE_NAME, zumeConfig -> {
            config = zumeConfig;
            zoom.update(zumeConfig.zoomSmoothnessMs, zumeConfig.animationEasingExponent);
        });
        disabled = Zume.config.disable;
    }

    private static double getZoom() {
        return zoom.getEased();
    }

    private static void setZoom(double d) {
        zoom.set(Zume.clamp(d));
    }

    private static void setZoom(double d, double d2) {
        zoom.set(Zume.clamp(d), Zume.clamp(d2));
    }

    private static double getThirdPersonStartZoom() {
        return EasingHelper.inverseOut(Zume.config.minThirdPersonZoomDistance, Zume.config.maxThirdPersonZoomDistance, 4.0, Zume.config.zoomEasingExponent);
    }

    private static void onZoomActivate() {
        implementation.onZoomActivate();
        if (Zume.shouldUseFirstPersonZoom()) {
            Zume.setZoom(1.0, 1.0 - Zume.config.defaultZoom);
        } else {
            double d = Zume.getThirdPersonStartZoom();
            double d2 = implementation.getCameraPerspective() == CameraPerspective.THIRD_PERSON ? EasingHelper.linear(1.0, d, Zume.config.defaultZoom) : EasingHelper.linear(d, 0.0, Zume.config.defaultZoom);
            Zume.setZoom(d, d2);
        }
    }

    private static void onZoomDeactivate() {
        if (Zume.shouldUseFirstPersonZoom()) {
            Zume.setZoom(1.0);
        } else {
            Zume.setZoom(Zume.getThirdPersonStartZoom());
        }
    }

    public static void openConfigFile() {
        File file = ZumeConfig.getConfigFile();
        try {
            try {
                Desktop.getDesktop().open(file);
            }
            catch (HeadlessException headlessException) {
                String string = file.getCanonicalPath();
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).inheritIO();
                switch (HOST_PLATFORM) {
                    case LINUX: 
                    case UNKNOWN: {
                        processBuilder.command("xdg-open", string);
                        break;
                    }
                    case WINDOWS: {
                        processBuilder.command("rundll32", "url.dll,FileProtocolHandler", string);
                        break;
                    }
                    case MAC_OS: {
                        processBuilder.command("open", "-t", string);
                    }
                }
                processBuilder.start();
            }
        }
        catch (IOException iOException) {
            LOGGER.error("Error opening config file: ", (Throwable)iOException);
        }
    }

    public static double transformFOV(double d) {
        return EasingHelper.out(Zume.config.minFOV, d, Zume.getZoom(), Zume.config.zoomEasingExponent);
    }

    public static double transformThirdPersonDistance(double d) {
        if (Zume.shouldUseFirstPersonZoom() || !Zume.shouldHook()) {
            return d;
        }
        return d * 0.25 * EasingHelper.out(Zume.config.minThirdPersonZoomDistance, Zume.config.maxThirdPersonZoomDistance, Zume.getZoom(), Zume.config.zoomEasingExponent);
    }

    public static boolean transformCinematicCamera(boolean bl) {
        if (Zume.config.enableCinematicZoom && Zume.isEnabled()) {
            return true;
        }
        return bl;
    }

    public static double transformMouseSensitivity(double d) {
        if (!Zume.isEnabled() || !Zume.shouldUseFirstPersonZoom()) {
            return d;
        }
        return d * EasingHelper.out(Zume.config.mouseSensitivityFloor, 1.0, Zume.getZoom(), 1.0);
    }

    public static boolean shouldCancelScroll() {
        return Zume.config.enableZoomScrolling && Zume.isEnabled();
    }

    public static boolean interceptScroll(int n) {
        if (!Zume.shouldCancelScroll() || n == 0) {
            return false;
        }
        scrollDelta += Zume.sign(n);
        return true;
    }

    private static boolean getToggleMode() {
        return Zume.shouldUseFirstPersonZoom() ? Zume.config.toggleMode : Zume.config.thirdPersonToggleMode;
    }

    public static boolean isEnabled() {
        if (disabled || implementation == null) {
            return false;
        }
        return zooming;
    }

    public static boolean shouldHook() {
        if (disabled || implementation == null) {
            return false;
        }
        return Zume.isEnabled() || zoom.isEasing();
    }

    public static boolean shouldUseFirstPersonZoom() {
        return Zume.config.maxThirdPersonZoomDistance == 0.0 || implementation.getCameraPerspective() == CameraPerspective.FIRST_PERSON;
    }

    public static boolean shouldHookFOV() {
        return Zume.shouldHook() && Zume.shouldUseFirstPersonZoom();
    }

    public static void render() {
        if (disabled || implementation == null) {
            return;
        }
        long l = System.currentTimeMillis();
        boolean bl = implementation.isZoomPressed();
        boolean bl2 = Zume.getToggleMode();
        if (bl2 && bl && !wasHeld) {
            zooming = !zooming;
        } else if (!bl2) {
            zooming = bl;
        }
        if (zooming) {
            if (!wasZooming) {
                Zume.onZoomActivate();
            }
            long l2 = l - prevRenderTimestamp;
            if (Zume.config.enableZoomScrolling && scrollDelta != 0) {
                Zume.setZoom(zoom.getTarget() - (double)(scrollDelta * Zume.config.zoomSpeed) * 0.004);
            } else if (implementation.isZoomInPressed() ^ implementation.isZoomOutPressed()) {
                double d = (double)Zume.config.zoomSpeed * 1.0E-4 * (double)l2;
                if (implementation.isZoomInPressed()) {
                    Zume.setZoom(zoom.getTarget() - d);
                } else if (implementation.isZoomOutPressed()) {
                    Zume.setZoom(zoom.getTarget() + d);
                }
            }
        } else if (wasZooming) {
            Zume.onZoomDeactivate();
        }
        scrollDelta = 0;
        prevRenderTimestamp = l;
        wasHeld = bl;
        wasZooming = zooming;
    }

    static {
        boolean bl = false;
        try {
            Class.forName("dev.su5ed.sinytra.connector.service.ConnectorLoaderService");
            bl = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (!bl && CLASS_LOADER.getResource("net/fabricmc/fabric/api/client/keybinding/v1/KeyBindingHelper.class") != null) {
            ZUME_VARIANT = ZumeVariant.MODERN;
        } else if (CLASS_LOADER.getResource("net/legacyfabric/fabric/api/client/keybinding/v1/KeyBindingHelper.class") != null) {
            ZUME_VARIANT = ZumeVariant.LEGACY;
        } else if (CLASS_LOADER.getResource("net/modificationstation/stationapi/api/client/event/option/KeyBindingRegisterEvent.class") != null) {
            ZUME_VARIANT = ZumeVariant.PRIMITIVE;
        } else if (CLASS_LOADER.getResource("cpw/mods/fml/client/registry/ClientRegistry.class") != null) {
            ZUME_VARIANT = ZumeVariant.ARCHAIC_FORGE;
        } else if (CLASS_LOADER.getResource("net/minecraftforge/oredict/OreDictionary.class") != null) {
            ZUME_VARIANT = ZumeVariant.VINTAGE_FORGE;
        } else if (CLASS_LOADER.getResource("net/neoforged/neoforge/common/NeoForge.class") != null) {
            ZUME_VARIANT = ZumeVariant.NEOFORGE;
        } else {
            int n;
            String string = null;
            try {
                Class<?> clazz = Class.forName("net.minecraftforge.versions.forge.ForgeVersion");
                Method method = clazz.getMethod("getVersion", new Class[0]);
                string = (String)method.invoke(null, new Object[0]);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            ZUME_VARIANT = string != null ? ((n = Integer.parseInt(string.substring(0, string.indexOf(46)))) > 40 ? ZumeVariant.LEXFORGE : (n > 36 ? ZumeVariant.LEXFORGE18 : ZumeVariant.LEXFORGE16)) : null;
        }
        String string = System.getProperty("os.name").toLowerCase();
        HOST_PLATFORM = string.contains("linux") ? HostPlatform.LINUX : (string.contains("win") ? HostPlatform.WINDOWS : (string.contains("mac") ? HostPlatform.MAC_OS : HostPlatform.UNKNOWN));
        disabled = false;
        zoom = new EasedDouble(1.0);
        scrollDelta = 0;
        wasHeld = false;
        zooming = false;
        wasZooming = false;
    }
}

