/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.common.config;

import dev.nolij.zume.common.Zume;
import dev.nolij.zume.common.util.FileWatcher;
import dev.nolij.zume.common.util.IFileWatcher;
import dev.nolij.zume.shadow.blue.endless.jankson.Comment;
import dev.nolij.zume.shadow.blue.endless.jankson.Jankson;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonGrammar;
import dev.nolij.zume.shadow.blue.endless.jankson.api.SyntaxError;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class ZumeConfig
implements Cloneable {
    @Comment(value="\nEnable Cinematic Camera while zooming.\nIf you disable this, you should also try setting `zoomSmoothnessMs` to `0`.\nDEFAULT: `true`")
    public boolean enableCinematicZoom = true;
    @Comment(value="\nMouse Sensitivity will not be reduced below this amount while zoomed in.\nSet to `1.0` to prevent it from being changed at all (not recommended without `enableCinematicZoom`).\nDEFAULT: `0.4`")
    public double mouseSensitivityFloor = 0.4;
    @Comment(value="\nSpeed for Zoom In/Out key binds & zoom scrolling (if enabled).\nDEFAULT: `20`")
    public short zoomSpeed = (short)20;
    @Comment(value="\nAllows you to zoom in and out by scrolling up and down on your mouse while zoom is active.\nThis will prevent you from scrolling through your hotbar while zooming if enabled.\nDEFAULT: `true`")
    public boolean enableZoomScrolling = true;
    @Comment(value="\nFOV changes will be spread out over this many milliseconds.\nSet to `0` to disable animations.\nDEFAULT: `150`")
    public short zoomSmoothnessMs = (short)150;
    @Comment(value="\nThe exponent used for easing animations.\nYou should probably leave this at the default if you don't understand what it does.\nDEFAULT: `4.0`")
    public double animationEasingExponent = 4.0;
    @Comment(value="\nThe exponent used for making differences in FOV more uniform.\nYou should probably leave this at the default if you don't understand what it does.\nDEFAULT: `2.0`")
    public double zoomEasingExponent = 2.0;
    @Comment(value="\nDefault starting zoom percentage.\nDEFAULT: `0.5`")
    public double defaultZoom = 0.5;
    @Comment(value="\nIf `true`, the Zoom keybind will act as a toggle in first-person.\nIf `false`, Zoom will only be active in first-person while the keybind is held.\nDEFAULT: `false`")
    public boolean toggleMode = false;
    @Comment(value="\nIf `true`, the Zoom keybind will act as a toggle in third-person.\nIf `false`, Zoom will only be active in third-person while the keybind is held.\nDEFAULT: `true`")
    public boolean thirdPersonToggleMode = true;
    @Comment(value="\nMinimum zoom FOV.\nDEFAULT: `1.0`")
    public double minFOV = 1.0;
    @Comment(value="\nMaximum third-person zoom distance (in blocks).\nSet to `0.0` to disable third-person zoom.\nDEFAULT: `15.0`")
    public double maxThirdPersonZoomDistance = 15.0;
    @Comment(value="\nMinimum third-person zoom distance (in blocks).\nSet to `4.0` to mimic vanilla.\nDEFAULT: `0.5`")
    public double minThirdPersonZoomDistance = 0.5;
    @Comment(value="\nIf `true`, the mod will be disabled (on some platforms, key binds will still show in game options; they won't do anything if this is set to `true`).\nRequires re-launch to take effect.\nDEFAULT: `false`")
    public boolean disable = false;
    private static final int EXPECTED_VERSION = 1;
    @Comment(value="Used internally. Don't modify this.")
    public int configVersion = 1;
    private static final int MAX_RETRIES = 5;
    private static final JsonGrammar JSON_GRAMMAR;
    private static final Jankson JANKSON;
    private static ConfigConsumer consumer;
    private static IFileWatcher instanceWatcher;
    private static IFileWatcher globalWatcher;
    private static File instanceFile;
    private static File globalFile;
    private static final String CONFIG_PATH_OVERRIDE;
    private static final Path GLOBAL_CONFIG_PATH;

    private static ZumeConfig readFromFile(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        int n = 0;
        while (true) {
            try {
                return JANKSON.fromJson(JANKSON.load(file), ZumeConfig.class);
            }
            catch (SyntaxError syntaxError) {
                if (++n < 5) {
                    try {
                        Thread.sleep((long)n * 200L);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                    continue;
                }
                Zume.LOGGER.error("Error parsing config after " + n + " retries: ", (Throwable)syntaxError);
                return null;
            }
            catch (IOException iOException) {
                Zume.LOGGER.error("Error reading config: ", (Throwable)iOException);
                return null;
            }
            break;
        }
    }

    private static ZumeConfig readConfigFile() {
        ZumeConfig zumeConfig = ZumeConfig.readFromFile(ZumeConfig.getConfigFile());
        if (zumeConfig == null) {
            zumeConfig = new ZumeConfig();
        }
        return zumeConfig;
    }

    private void writeToFile(File file) {
        this.configVersion = 1;
        try (FileWriter fileWriter = new FileWriter(file);){
            JANKSON.toJson(this).toJson(fileWriter, JSON_GRAMMAR, 0);
            fileWriter.flush();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public ZumeConfig clone() {
        try {
            return (ZumeConfig)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public static void replace(ZumeConfig zumeConfig) throws InterruptedException {
        try {
            instanceWatcher.lock();
            try {
                globalWatcher.lock();
                zumeConfig.writeToFile(ZumeConfig.getConfigFile());
                consumer.invoke(zumeConfig);
            }
            finally {
                globalWatcher.unlock();
            }
        }
        finally {
            instanceWatcher.unlock();
        }
    }

    public void modify(ConfigConsumer configConsumer) throws InterruptedException {
        ZumeConfig zumeConfig = this.clone();
        configConsumer.invoke(zumeConfig);
        ZumeConfig.replace(zumeConfig);
    }

    public static File getConfigFile() {
        if (CONFIG_PATH_OVERRIDE != null) {
            return new File(CONFIG_PATH_OVERRIDE);
        }
        if (instanceFile != null && instanceFile.exists()) {
            return instanceFile;
        }
        return globalFile;
    }

    public static void reloadConfig() {
        Zume.LOGGER.info("Reloading config...");
        ZumeConfig zumeConfig = ZumeConfig.readConfigFile();
        consumer.invoke(zumeConfig);
    }

    public static void init(Path path, String string, ConfigConsumer configConsumer) {
        if (consumer != null) {
            throw new AssertionError((Object)"Config already initialized!");
        }
        consumer = configConsumer;
        if (CONFIG_PATH_OVERRIDE == null) {
            instanceFile = path.resolve(string).toFile();
            globalFile = GLOBAL_CONFIG_PATH.resolve(string).toFile();
        }
        ZumeConfig zumeConfig = ZumeConfig.readConfigFile();
        zumeConfig.writeToFile(ZumeConfig.getConfigFile());
        consumer.invoke(zumeConfig);
        try {
            IFileWatcher iFileWatcher = new IFileWatcher(){

                @Override
                public void lock() throws InterruptedException {
                }

                @Override
                public boolean tryLock() {
                    return true;
                }

                @Override
                public void unlock() {
                }
            };
            if (zumeConfig.disable) {
                instanceWatcher = iFileWatcher;
                globalWatcher = iFileWatcher;
            } else if (CONFIG_PATH_OVERRIDE == null) {
                instanceWatcher = FileWatcher.onFileChange(instanceFile.toPath(), ZumeConfig::reloadConfig);
                globalWatcher = FileWatcher.onFileChange(globalFile.toPath(), ZumeConfig::reloadConfig);
            } else {
                instanceWatcher = iFileWatcher;
                globalWatcher = FileWatcher.onFileChange(ZumeConfig.getConfigFile().toPath(), ZumeConfig::reloadConfig);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    static {
        Path path;
        JSON_GRAMMAR = JsonGrammar.JANKSON;
        JANKSON = Jankson.builder().allowBareRootObject().build();
        instanceFile = null;
        globalFile = null;
        CONFIG_PATH_OVERRIDE = System.getProperty("zume.configPathOverride");
        switch (Zume.HOST_PLATFORM) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LINUX: 
            case UNKNOWN: {
                path = FileSystems.getDefault().getPath(System.getProperty("user.home"), ".minecraft");
                break;
            }
            case WINDOWS: {
                path = FileSystems.getDefault().getPath(System.getenv("APPDATA"), ".minecraft");
                break;
            }
            case MAC_OS: {
                path = FileSystems.getDefault().getPath(System.getProperty("user.home"), "Library", "Application Support", "minecraft");
            }
        }
        Path path2 = path;
        GLOBAL_CONFIG_PATH = path2.resolve("global");
        if (Files.notExists(GLOBAL_CONFIG_PATH, new LinkOption[0])) {
            try {
                Files.createDirectories(GLOBAL_CONFIG_PATH, new FileAttribute[0]);
            }
            catch (IOException iOException) {
                Zume.LOGGER.error("Failed to create global config path: ", (Throwable)iOException);
            }
        }
    }

    @FunctionalInterface
    public static interface ConfigConsumer {
        public void invoke(ZumeConfig var1);
    }
}

