/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.common.easing;

import dev.nolij.zume.common.easing.EasingHelper;

public class EasedDouble {
    public static final double PLACEHOLDER = Double.NaN;
    private short duration;
    private double inverseDuration;
    private double exponent;
    private double fromValue = Double.NaN;
    private double targetValue;
    private long startTimestamp = 0L;
    private long endTimestamp = 0L;

    public EasedDouble() {
        this(Double.NaN);
    }

    public EasedDouble(double d) {
        this.targetValue = d;
    }

    public void update(short s, double d) {
        this.duration = s;
        this.inverseDuration = 1.0 / (double)s;
        this.exponent = d;
    }

    public double getEased() {
        if (this.isEasing()) {
            long l = System.currentTimeMillis() - this.startTimestamp;
            return EasingHelper.in(this.fromValue, this.targetValue, (double)l * this.inverseDuration, this.exponent);
        }
        return this.targetValue;
    }

    public void fillPlaceholder(double d) {
        if (Double.isNaN(this.fromValue)) {
            this.fromValue = d;
        }
        if (Double.isNaN(this.targetValue)) {
            this.targetValue = d;
        }
    }

    public double getTarget() {
        return this.targetValue;
    }

    public void setInstant(double d) {
        this.startTimestamp = 0L;
        this.endTimestamp = 0L;
        this.fromValue = Double.NaN;
        this.targetValue = d;
    }

    public void set(double d, double d2) {
        if (this.duration == 0) {
            this.setInstant(d2);
            return;
        }
        this.startTimestamp = System.currentTimeMillis();
        this.endTimestamp = this.startTimestamp + (long)this.duration;
        this.fromValue = d;
        this.targetValue = d2;
    }

    public void set(double d) {
        this.set(this.getEased(), d);
    }

    public boolean isEasing() {
        return System.currentTimeMillis() < this.endTimestamp;
    }
}

