/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.common.easing;

public final class EasingHelper {
    public static double linear(double d, double d2, double d3) {
        return d + (d2 - d) * d3;
    }

    public static double inverseLinear(double d, double d2, double d3) {
        return (d3 - d) / (d2 - d);
    }

    public static double out(double d, double d2) {
        return Math.pow(d, d2);
    }

    public static double inverseOut(double d, double d2) {
        return Math.pow(d, 1.0 / d2);
    }

    public static double out(double d, double d2, double d3, double d4) {
        return EasingHelper.linear(d, d2, EasingHelper.out(d3, d4));
    }

    public static double inverseOut(double d, double d2, double d3, double d4) {
        return EasingHelper.inverseOut(EasingHelper.inverseLinear(d, d2, d3), d4);
    }

    public static double in(double d, double d2) {
        return 1.0 - Math.pow(1.0 - d, d2);
    }

    public static double inverseIn(double d, double d2) {
        return 1.0 - Math.pow(1.0 - d, 1.0 / d2);
    }

    public static double in(double d, double d2, double d3, double d4) {
        return EasingHelper.linear(d, d2, EasingHelper.in(d3, d4));
    }

    public static double inverseIn(double d, double d2, double d3, double d4) {
        return EasingHelper.inverseIn(EasingHelper.inverseLinear(d, d2, d3), d4);
    }

    public static double inOut(double d, double d2) {
        return (d < 0.5 ? EasingHelper.out(d, d2) : EasingHelper.in(d, d2)) * Math.pow(2.0, d2 - 1.0);
    }

    public static double inverseInOut(double d, double d2) {
        return d < 0.5 ? Math.pow(d / Math.pow(2.0, d2 - 1.0), 1.0 / d2) : -Math.pow((1.0 - d) / Math.pow(2.0, d2 - 1.0), 1.0 / d2) + 1.0;
    }

    public static double inOut(double d, double d2, double d3, double d4) {
        return EasingHelper.linear(d, d2, EasingHelper.inOut(d3, d4));
    }

    public static double inverseInOut(double d, double d2, double d3, double d4) {
        return EasingHelper.inverseInOut(EasingHelper.inverseLinear(d, d2, d3), d4);
    }
}

