/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.common.util;

import dev.nolij.zume.common.Zume;
import dev.nolij.zume.common.util.IFileWatcher;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.concurrent.Semaphore;

public class FileWatcher
implements IFileWatcher {
    private static final long DEBOUNCE_DURATION_MS = 500L;
    private WatchService watchService;
    private Thread thread;
    private long debounce = 0L;
    private final Semaphore semaphore = new Semaphore(1);

    public static FileWatcher onFileChange(Path path, Callback callback) throws IOException {
        FileWatcher fileWatcher = new FileWatcher();
        fileWatcher.start(path, callback);
        return fileWatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lock() throws InterruptedException {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            this.semaphore.acquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLock() {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            return this.semaphore.tryAcquire();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock() {
        Semaphore semaphore = this.semaphore;
        synchronized (semaphore) {
            if (this.semaphore.availablePermits() > 0) {
                return;
            }
            this.semaphore.release();
        }
    }

    public void start(Path path, Callback callback) throws IOException {
        this.watchService = FileSystems.getDefault().newWatchService();
        Path path2 = path.getParent();
        path2.register(this.watchService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        this.thread = new Thread(() -> {
            block12: while (true) {
                WatchKey watchKey = null;
                try {
                    watchKey = this.watchService.take();
                    Iterator<WatchEvent<?>> iterator = watchKey.pollEvents().iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block12;
                        WatchEvent<?> watchEvent = iterator.next();
                        Path path3 = path2.resolve((Path)watchEvent.context());
                        boolean bl = false;
                        try {
                            bl = this.tryLock();
                            if (!bl || System.currentTimeMillis() <= this.debounce || !Files.exists(path3, new LinkOption[0]) || !Files.isSameFile(path3, path)) continue;
                            callback.invoke();
                            this.debounce = System.currentTimeMillis() + 500L;
                            continue block12;
                        }
                        catch (NoSuchFileException noSuchFileException) {
                            continue;
                        }
                        catch (IOException iOException) {
                            Zume.LOGGER.error("Error in config watcher: ", (Throwable)iOException);
                            continue;
                        }
                        finally {
                            if (!bl) continue;
                            this.unlock();
                            continue;
                        }
                        break;
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    return;
                }
                finally {
                    if (watchKey == null) continue;
                    watchKey.reset();
                    continue;
                }
                break;
            }
        });
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void stop() {
        this.thread.interrupt();
        try {
            this.watchService.close();
        }
        catch (IOException iOException) {
            Zume.LOGGER.error("Error in config watcher: ", (Throwable)iOException);
            throw new RuntimeException(iOException);
        }
    }

    @FunctionalInterface
    public static interface Callback {
        public void invoke() throws InterruptedException;
    }
}

