/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.lexforge;

import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import dev.nolij.zume.lexforge.LexZumeConfigScreen;
import dev.nolij.zume.lexforge.ZumeKeyBind;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;

public class LexZume
implements IZumeImplementation {
    private static final MethodHandle getScrollDelta;

    public LexZume() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading LexZume...");
        LexZumeConfigScreen.register();
        Zume.init(this, FMLPaths.CONFIGDIR.get());
        if (Zume.disabled) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerKeyBindings);
        MinecraftForge.EVENT_BUS.addListener(this::render);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::calculateFOV);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onMouseScroll);
    }

    @Override
    public boolean isZoomPressed() {
        return Minecraft.m_91087_().f_91080_ == null && ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        return CameraPerspective.values()[Minecraft.m_91087_().f_91066_.m_92176_().ordinal()];
    }

    private void registerKeyBindings(RegisterKeyMappingsEvent registerKeyMappingsEvent) {
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            registerKeyMappingsEvent.register(zumeKeyBind.value);
        }
    }

    private void render(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.START) {
            Zume.render();
        }
    }

    private void calculateFOV(ViewportEvent.ComputeFov computeFov) {
        if (Zume.shouldHookFOV()) {
            computeFov.setFOV(Zume.transformFOV(computeFov.getFOV()));
        }
    }

    private void onMouseScroll(InputEvent.MouseScrollingEvent mouseScrollingEvent) {
        int n;
        try {
            n = (int)getScrollDelta.invokeExact(mouseScrollingEvent);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        if (Zume.interceptScroll(n)) {
            mouseScrollingEvent.setCanceled(true);
        }
    }

    static {
        Method method;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            method = InputEvent.MouseScrollingEvent.class.getMethod("getScrollDelta", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                method = InputEvent.MouseScrollingEvent.class.getMethod("getDeltaY", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new AssertionError((Object)noSuchMethodException2);
            }
        }
        try {
            getScrollDelta = lookup.unreflect(method);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
    }
}

