/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.lexforge16;

import cpw.mods.modlauncher.api.INameMappingService;
import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import dev.nolij.zume.lexforge16.LexZume16ConfigScreen;
import dev.nolij.zume.lexforge16.ZumeKeyBind;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;

public class LexZume16
implements IZumeImplementation {
    private static final MethodHandle GET_CAMERA_TYPE;
    private static final MethodHandle ORDINAL;
    private static final MethodHandle THIRD_PERSON_VIEW;

    public LexZume16() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading LexZume16...");
        LexZume16ConfigScreen.register();
        Zume.init(this, FMLPaths.CONFIGDIR.get());
        if (Zume.disabled) {
            return;
        }
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)zumeKeyBind.value);
        }
        MinecraftForge.EVENT_BUS.addListener(this::render);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::calculateFOV);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onMouseScroll);
    }

    @Override
    public boolean isZoomPressed() {
        return Minecraft.func_71410_x().field_71462_r == null && ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        int n;
        try {
            n = GET_CAMERA_TYPE != null ? ORDINAL.invokeExact(GET_CAMERA_TYPE.invokeExact(Minecraft.func_71410_x().field_71474_y)) : THIRD_PERSON_VIEW.invokeExact(Minecraft.func_71410_x().field_71474_y);
        }
        catch (Throwable throwable) {
            throw new AssertionError((Object)throwable);
        }
        return CameraPerspective.values()[n];
    }

    private void render(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.START) {
            Zume.render();
        }
    }

    private void calculateFOV(EntityViewRenderEvent.FOVModifier fOVModifier) {
        if (Zume.shouldHookFOV()) {
            fOVModifier.setFOV(Zume.transformFOV(fOVModifier.getFOV()));
        }
    }

    private void onMouseScroll(InputEvent.MouseScrollEvent mouseScrollEvent) {
        int n = (int)mouseScrollEvent.getScrollDelta();
        if (Zume.interceptScroll(n)) {
            mouseScrollEvent.setCanceled(true);
        }
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        MethodHandle methodHandle = null;
        MethodHandle methodHandle2 = null;
        MethodHandle methodHandle3 = null;
        try {
            String string = ObfuscationReflectionHelper.remapName((INameMappingService.Domain)INameMappingService.Domain.METHOD, (String)"func_243230_g");
            methodHandle = lookup.unreflect(GameSettings.class.getMethod(string, new Class[0])).asType(MethodType.methodType(Enum.class, GameSettings.class));
            methodHandle2 = lookup.unreflect(Enum.class.getMethod("ordinal", new Class[0])).asType(MethodType.methodType(Integer.TYPE, Enum.class));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                methodHandle3 = lookup.findGetter(GameSettings.class, "field_74320_O", Integer.TYPE);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new AssertionError((Object)illegalAccessException);
        }
        GET_CAMERA_TYPE = methodHandle;
        ORDINAL = methodHandle2;
        THIRD_PERSON_VIEW = methodHandle3;
    }
}

