/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.lexforge18;

import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import dev.nolij.zume.lexforge18.LexZume18ConfigScreen;
import dev.nolij.zume.lexforge18.ZumeKeyBind;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.fml.loading.FMLPaths;

public class LexZume18
implements IZumeImplementation {
    public LexZume18() {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading LexZume18...");
        LexZume18ConfigScreen.register();
        Zume.init(this, FMLPaths.CONFIGDIR.get());
        if (Zume.disabled) {
            return;
        }
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            ClientRegistry.registerKeyBinding((KeyMapping)zumeKeyBind.value);
        }
        MinecraftForge.EVENT_BUS.addListener(this::render);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onMouseScroll);
    }

    @Override
    public boolean isZoomPressed() {
        return Minecraft.m_91087_().f_91080_ == null && ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        return CameraPerspective.values()[Minecraft.m_91087_().f_91066_.m_92176_().ordinal()];
    }

    private void render(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.START) {
            Zume.render();
        }
    }

    private void onMouseScroll(InputEvent.MouseScrollEvent mouseScrollEvent) {
        int n = (int)mouseScrollEvent.getScrollDelta();
        if (Zume.interceptScroll(n)) {
            mouseScrollEvent.setCanceled(true);
        }
    }
}

