/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.neoforge;

import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import dev.nolij.zume.neoforge.NeoZumeConfigScreen;
import dev.nolij.zume.neoforge.ZumeKeyBind;
import net.minecraft.client.Minecraft;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.client.event.CalculateDetachedCameraDistanceEvent;
import net.neoforged.neoforge.client.event.CalculatePlayerTurnEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.TickEvent;

@Mod(value="zume")
public class NeoZume
implements IZumeImplementation {
    public NeoZume(IEventBus iEventBus) {
        if (!FMLEnvironment.dist.isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading NeoZume...");
        NeoZumeConfigScreen.register();
        Zume.init(this, FMLPaths.CONFIGDIR.get());
        if (Zume.disabled) {
            return;
        }
        iEventBus.addListener(this::registerKeyBindings);
        NeoForge.EVENT_BUS.addListener(this::render);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::calculateFOV);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::calculateTurnPlayerValues);
        NeoForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onMouseScroll);
        NeoForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::calculateDetachedCameraDistance);
    }

    @Override
    public boolean isZoomPressed() {
        return ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        return CameraPerspective.values()[Minecraft.getInstance().options.getCameraType().ordinal()];
    }

    private void registerKeyBindings(RegisterKeyMappingsEvent registerKeyMappingsEvent) {
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            registerKeyMappingsEvent.register(zumeKeyBind.value);
        }
    }

    private void render(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.START) {
            Zume.render();
        }
    }

    private void calculateFOV(ViewportEvent.ComputeFov computeFov) {
        if (Zume.shouldHookFOV()) {
            computeFov.setFOV(Zume.transformFOV(computeFov.getFOV()));
        }
    }

    private void calculateTurnPlayerValues(CalculatePlayerTurnEvent calculatePlayerTurnEvent) {
        calculatePlayerTurnEvent.setMouseSensitivity(Zume.transformMouseSensitivity(calculatePlayerTurnEvent.getMouseSensitivity()));
        calculatePlayerTurnEvent.setCinematicCameraEnabled(Zume.transformCinematicCamera(calculatePlayerTurnEvent.getCinematicCameraEnabled()));
    }

    private void onMouseScroll(InputEvent.MouseScrollingEvent mouseScrollingEvent) {
        int n = (int)mouseScrollingEvent.getScrollDeltaY();
        if (Zume.interceptScroll(n)) {
            mouseScrollingEvent.setCanceled(true);
        }
    }

    private void calculateDetachedCameraDistance(CalculateDetachedCameraDistanceEvent calculateDetachedCameraDistanceEvent) {
        calculateDetachedCameraDistanceEvent.setDistance(Zume.transformThirdPersonDistance(calculateDetachedCameraDistanceEvent.getDistance()));
    }
}

