/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson;

import dev.nolij.zume.shadow.blue.endless.jankson.JsonElement;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonNull;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonObject;
import dev.nolij.zume.shadow.blue.endless.jankson.api.DeserializationException;
import dev.nolij.zume.shadow.blue.endless.jankson.api.DeserializerFunction;
import dev.nolij.zume.shadow.blue.endless.jankson.api.Marshaller;
import dev.nolij.zume.shadow.blue.endless.jankson.api.SyntaxError;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.AnnotatedElement;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ElementParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.MarshallerImpl;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ObjectParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ParserContext;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class Jankson {
    private Deque<ParserFrame<?>> contextStack = new ArrayDeque();
    private JsonObject root;
    private int line = 0;
    private int column = 0;
    private int withheldCodePoint = -1;
    private Marshaller marshaller = MarshallerImpl.getFallback();
    private boolean allowBareRootObject = false;
    private int retries = 0;
    private SyntaxError delayedError = null;
    private AnnotatedElement rootElement;

    private Jankson(Builder builder) {
    }

    @Nonnull
    public JsonObject load(String string) throws SyntaxError {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
        try {
            return this.load(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Nonnull
    public JsonObject load(File file) throws IOException, SyntaxError {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            JsonObject jsonObject = this.load(fileInputStream);
            return jsonObject;
        }
    }

    @Nonnull
    public JsonObject load(InputStream inputStream) throws IOException, SyntaxError {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.withheldCodePoint = -1;
        this.root = null;
        this.push(new ObjectParserContext(this.allowBareRootObject), jsonObject -> {
            this.root = jsonObject;
        });
        while (this.root == null) {
            if (this.delayedError != null) {
                throw this.delayedError;
            }
            if (this.withheldCodePoint != -1) {
                ++this.retries;
                if (this.retries > 25) {
                    throw new IOException("Parser got stuck near line " + this.line + " column " + this.column);
                }
                this.processCodePoint(this.withheldCodePoint);
                continue;
            }
            int n = inputStreamReader.read();
            if (n == -1) {
                while (!this.contextStack.isEmpty()) {
                    ParserFrame<?> parserFrame = this.contextStack.pop();
                    try {
                        ((ParserFrame)parserFrame).context.eof();
                        if (!((ParserFrame)parserFrame).context.isComplete()) continue;
                        parserFrame.supply();
                    }
                    catch (SyntaxError syntaxError) {
                        syntaxError.setStartParsing(((ParserFrame)parserFrame).startLine, ((ParserFrame)parserFrame).startCol);
                        syntaxError.setEndParsing(this.line, this.column);
                        throw syntaxError;
                    }
                }
                if (this.root == null) {
                    this.root = new JsonObject();
                    this.root.marshaller = this.marshaller;
                }
                return this.root;
            }
            this.processCodePoint(n);
        }
        return this.root;
    }

    @Nonnull
    public JsonElement loadElement(String string) throws SyntaxError {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes(Charset.forName("UTF-8")));
        try {
            return this.loadElement(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Nonnull
    public JsonElement loadElement(File file) throws IOException, SyntaxError {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            JsonElement jsonElement = this.loadElement(fileInputStream);
            return jsonElement;
        }
    }

    @Nonnull
    public JsonElement loadElement(InputStream inputStream) throws IOException, SyntaxError {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        this.withheldCodePoint = -1;
        this.rootElement = null;
        this.push(new ElementParserContext(), annotatedElement -> {
            this.rootElement = annotatedElement;
        });
        while (this.rootElement == null) {
            if (this.delayedError != null) {
                throw this.delayedError;
            }
            if (this.withheldCodePoint != -1) {
                ++this.retries;
                if (this.retries > 25) {
                    throw new IOException("Parser got stuck near line " + this.line + " column " + this.column);
                }
                this.processCodePoint(this.withheldCodePoint);
                continue;
            }
            int n = inputStreamReader.read();
            if (n == -1) {
                while (!this.contextStack.isEmpty()) {
                    ParserFrame<?> parserFrame = this.contextStack.pop();
                    try {
                        ((ParserFrame)parserFrame).context.eof();
                        if (!((ParserFrame)parserFrame).context.isComplete()) continue;
                        parserFrame.supply();
                    }
                    catch (SyntaxError syntaxError) {
                        syntaxError.setStartParsing(((ParserFrame)parserFrame).startLine, ((ParserFrame)parserFrame).startCol);
                        syntaxError.setEndParsing(this.line, this.column);
                        throw syntaxError;
                    }
                }
                if (this.rootElement == null) {
                    return JsonNull.INSTANCE;
                }
                return this.rootElement.getElement();
            }
            this.processCodePoint(n);
        }
        return this.rootElement.getElement();
    }

    public <T> T fromJson(JsonObject jsonObject, Class<T> clazz) {
        return this.marshaller.marshall(clazz, (JsonElement)jsonObject);
    }

    public <T> T fromJson(String string, Class<T> clazz) throws SyntaxError {
        JsonObject jsonObject = this.load(string);
        return this.fromJson(jsonObject, clazz);
    }

    public <T> T fromJsonCarefully(String string, Class<T> clazz) throws SyntaxError, DeserializationException {
        JsonObject jsonObject = this.load(string);
        return this.fromJsonCarefully(jsonObject, clazz);
    }

    public <T> T fromJsonCarefully(JsonObject jsonObject, Class<T> clazz) throws DeserializationException {
        return this.marshaller.marshallCarefully(clazz, jsonObject);
    }

    public <T> JsonElement toJson(T t) {
        return this.marshaller.serialize(t);
    }

    public <T> JsonElement toJson(T t, Marshaller marshaller) {
        return marshaller.serialize(t);
    }

    private void processCodePoint(int n) throws SyntaxError {
        ParserFrame<?> parserFrame = this.contextStack.peek();
        if (parserFrame == null) {
            throw new IllegalStateException("Parser problem! The ParserContext stack underflowed! (line " + this.line + ", col " + this.column + ")");
        }
        try {
            if (parserFrame.context().isComplete()) {
                this.contextStack.pop();
                parserFrame.supply();
                parserFrame = this.contextStack.peek();
            }
        }
        catch (SyntaxError syntaxError) {
            syntaxError.setStartParsing(((ParserFrame)parserFrame).startLine, ((ParserFrame)parserFrame).startCol);
            syntaxError.setEndParsing(this.line, this.column);
            throw syntaxError;
        }
        try {
            if (parserFrame == null) {
                return;
            }
            boolean bl = parserFrame.context().consume(n, this);
            if (((ParserFrame)parserFrame).context.isComplete()) {
                this.contextStack.pop();
                parserFrame.supply();
            }
            if (bl) {
                this.withheldCodePoint = -1;
                this.retries = 0;
            } else {
                this.withheldCodePoint = n;
            }
        }
        catch (SyntaxError syntaxError) {
            syntaxError.setStartParsing(((ParserFrame)parserFrame).startLine, ((ParserFrame)parserFrame).startCol);
            syntaxError.setEndParsing(this.line, this.column);
            throw syntaxError;
        }
        ++this.column;
        if (n == 10) {
            ++this.line;
            this.column = 0;
        }
    }

    public <T> void push(ParserContext<T> parserContext, Consumer<T> consumer) {
        ParserFrame<T> parserFrame = new ParserFrame<T>(parserContext, consumer);
        ((ParserFrame)parserFrame).startLine = this.line;
        ((ParserFrame)parserFrame).startCol = this.column;
        this.contextStack.push(parserFrame);
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void throwDelayed(SyntaxError syntaxError) {
        syntaxError.setEndParsing(this.line, this.column);
        this.delayedError = syntaxError;
    }

    public static class Builder {
        MarshallerImpl marshaller = new MarshallerImpl();
        boolean allowBareRootObject = false;

        @Deprecated
        public <T> Builder registerTypeAdapter(Class<T> clazz, Function<JsonObject, T> function) {
            this.marshaller.registerTypeAdapter(clazz, function);
            return this;
        }

        @Deprecated
        public <T> Builder registerPrimitiveTypeAdapter(Class<T> clazz, Function<Object, T> function) {
            this.marshaller.register(clazz, function);
            return this;
        }

        public <T> Builder registerSerializer(Class<T> clazz, BiFunction<T, Marshaller, JsonElement> biFunction) {
            this.marshaller.registerSerializer(clazz, biFunction);
            return this;
        }

        public <A, B> Builder registerDeserializer(Class<A> clazz, Class<B> clazz2, DeserializerFunction<A, B> deserializerFunction) {
            this.marshaller.registerDeserializer(clazz, clazz2, deserializerFunction);
            return this;
        }

        public <T> Builder registerTypeFactory(Class<T> clazz, Supplier<T> supplier) {
            this.marshaller.registerTypeFactory(clazz, supplier);
            return this;
        }

        public Builder allowBareRootObject() {
            this.allowBareRootObject = true;
            return this;
        }

        public Jankson build() {
            Jankson jankson = new Jankson(this);
            jankson.marshaller = this.marshaller;
            jankson.allowBareRootObject = this.allowBareRootObject;
            return jankson;
        }
    }

    private static class ParserFrame<T> {
        private ParserContext<T> context;
        private Consumer<T> consumer;
        private int startLine = 0;
        private int startCol = 0;

        public ParserFrame(ParserContext<T> parserContext, Consumer<T> consumer) {
            this.context = parserContext;
            this.consumer = consumer;
        }

        public ParserContext<T> context() {
            return this.context;
        }

        public void supply() throws SyntaxError {
            this.consumer.accept(this.context.getResult());
        }
    }
}

