/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson;

import dev.nolij.zume.shadow.blue.endless.jankson.JsonElement;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonGrammar;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonPrimitive;
import dev.nolij.zume.shadow.blue.endless.jankson.api.Marshaller;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.MarshallerImpl;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.serializer.CommentSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonArray
extends JsonElement
implements List<JsonElement>,
Iterable<JsonElement> {
    private List<Entry> entries = new ArrayList<Entry>();
    protected Marshaller marshaller = MarshallerImpl.getFallback();

    public JsonArray() {
    }

    public <T> JsonArray(T[] TArray, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (T t : TArray) {
            this.add(marshaller.serialize(t));
        }
    }

    public JsonArray(Collection<?> collection, Marshaller marshaller) {
        this.marshaller = marshaller;
        for (Object obj : collection) {
            this.add(marshaller.serialize(obj));
        }
    }

    @Override
    public JsonElement get(int n) {
        return this.entries.get((int)n).value;
    }

    public String getString(int n, String string) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asString();
        }
        return string;
    }

    public boolean getBoolean(int n, boolean bl) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asBoolean(bl);
        }
        return bl;
    }

    public byte getByte(int n, byte by) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asByte(by);
        }
        return by;
    }

    public char getChar(int n, char c) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asChar(c);
        }
        return c;
    }

    public short getShort(int n, short s) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asShort(s);
        }
        return s;
    }

    public int getInt(int n, int n2) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asInt(n2);
        }
        return n2;
    }

    public long getLong(int n, long l) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asLong(l);
        }
        return l;
    }

    public float getFloat(int n, float f) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asFloat(f);
        }
        return f;
    }

    public double getDouble(int n, double d) {
        JsonElement jsonElement = this.get(n);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asDouble(d);
        }
        return d;
    }

    public String getComment(int n) {
        return this.entries.get(n).getComment();
    }

    public void setComment(int n, String string) {
        this.entries.get(n).setComment(string);
    }

    @Override
    public String toJson(boolean bl, boolean bl2, int n) {
        JsonGrammar jsonGrammar = JsonGrammar.builder().withComments(bl).printWhitespace(bl2).build();
        return this.toJson(jsonGrammar, n);
    }

    @Override
    public void toJson(Writer writer, JsonGrammar jsonGrammar, int n) throws IOException {
        int n2;
        int n3 = jsonGrammar.bareRootObject ? n - 1 : n;
        writer.append("[");
        if (this.entries.size() > 0) {
            if (jsonGrammar.printWhitespace) {
                writer.append('\n');
            } else {
                writer.append(' ');
            }
        }
        for (n2 = 0; n2 < this.entries.size(); ++n2) {
            Entry entry = this.entries.get(n2);
            if (jsonGrammar.printWhitespace) {
                for (int i = 0; i < n3 + 1; ++i) {
                    writer.append("\t");
                }
            }
            CommentSerializer.print(writer, entry.getComment(), n3, jsonGrammar);
            writer.append(entry.value.toJson(jsonGrammar, n + 1));
            if (jsonGrammar.printCommas) {
                if (n2 < this.entries.size() - 1 || jsonGrammar.printTrailingCommas) {
                    writer.append(",");
                    if (n2 < this.entries.size() - 1 && !jsonGrammar.printWhitespace) {
                        writer.append(' ');
                    }
                }
            } else {
                writer.append(" ");
            }
            if (!jsonGrammar.printWhitespace) continue;
            writer.append('\n');
        }
        if (this.entries.size() > 0 && jsonGrammar.printWhitespace && n > 0) {
            for (n2 = 0; n2 < n3; ++n2) {
                writer.append("\t");
            }
        }
        if (this.entries.size() > 0 && !jsonGrammar.printWhitespace) {
            writer.append(' ');
        }
        writer.append(']');
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    public boolean add(@Nonnull JsonElement jsonElement, String string) {
        Entry entry = new Entry();
        entry.value = jsonElement;
        entry.setComment(string);
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof JsonArray)) {
            return false;
        }
        List<Entry> list = this.entries;
        List<Entry> list2 = ((JsonArray)object).entries;
        if (list.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            Entry entry = list.get(i);
            Entry entry2 = list2.get(i);
            if (!entry.value.equals(entry2.value)) {
                return false;
            }
            if (Objects.equals(entry.getComment(), entry2.getComment())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, int n) {
        JsonElement jsonElement = this.get(n);
        return this.marshaller.marshall(clazz, jsonElement);
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Override
    public JsonArray clone() {
        JsonArray jsonArray = new JsonArray();
        jsonArray.marshaller = this.marshaller;
        for (Entry entry : this.entries) {
            jsonArray.add(entry.value.clone(), entry.getComment());
        }
        return jsonArray;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean add(@Nonnull JsonElement jsonElement) {
        Entry entry = new Entry();
        entry.value = jsonElement;
        this.entries.add(entry);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends JsonElement> collection) {
        boolean bl = false;
        for (JsonElement jsonElement : collection) {
            bl |= this.add(jsonElement);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(Object object) {
        if (object == null || !(object instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean remove(Object object) {
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.value.equals(object)) continue;
            this.entries.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException("removeAll not supported");
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException("retainAll not supported");
    }

    public JsonElement[] toArray() {
        JsonElement[] jsonElementArray = new JsonElement[this.entries.size()];
        for (int i = 0; i < this.entries.size(); ++i) {
            jsonElementArray[i] = this.entries.get((int)i).value;
        }
        return jsonElementArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.entries.size()) {
            objectArray = new Object[this.entries.size()];
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            objectArray[i] = this.entries.get((int)i).value;
        }
        if (objectArray.length > this.entries.size()) {
            objectArray[this.entries.size()] = null;
        }
        return objectArray;
    }

    @Override
    public Iterator<JsonElement> iterator() {
        return new EntryIterator(this.entries);
    }

    @Override
    public void add(int n, JsonElement jsonElement) {
        this.entries.add(n, new Entry(jsonElement));
    }

    @Override
    public boolean addAll(int n, Collection<? extends JsonElement> collection) {
        if (collection.isEmpty()) {
            return false;
        }
        int n2 = n;
        for (JsonElement jsonElement : collection) {
            this.entries.add(n2, new Entry(jsonElement));
            ++n2;
        }
        return true;
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            JsonElement jsonElement = this.entries.get((int)i).value;
            if (jsonElement == null || !jsonElement.equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        if (object == null) {
            return -1;
        }
        for (int i = this.entries.size() - 1; i >= 0; --i) {
            JsonElement jsonElement = this.entries.get((int)i).value;
            if (jsonElement == null || !jsonElement.equals(object)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<JsonElement> listIterator() {
        return new EntryIterator(this.entries);
    }

    @Override
    public ListIterator<JsonElement> listIterator(int n) {
        return new EntryIterator(this.entries, n);
    }

    @Override
    public JsonElement remove(int n) {
        return this.entries.remove((int)n).value;
    }

    @Override
    public JsonElement set(int n, JsonElement jsonElement) {
        Entry entry = new Entry(jsonElement);
        Entry entry2 = this.entries.get(n);
        if (entry2 != null) {
            entry.setComment(entry2.getComment());
        }
        this.entries.set(n, entry);
        return entry2 == null ? null : entry2.value;
    }

    @Override
    public List<JsonElement> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    private static class Entry {
        String comment;
        JsonElement value;

        public Entry() {
        }

        public Entry(JsonElement jsonElement) {
            this.value = jsonElement;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            return Objects.equals(this.comment, entry.comment) && Objects.equals(this.value, entry.value);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string != null && !string.trim().isEmpty() ? string : null;
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.value);
        }
    }

    private static class EntryIterator
    implements ListIterator<JsonElement> {
        private final ListIterator<Entry> delegate;

        public EntryIterator(List<Entry> list) {
            this.delegate = list.listIterator();
        }

        public EntryIterator(List<Entry> list, int n) {
            this.delegate = list.listIterator(n);
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public JsonElement next() {
            return this.delegate.next().value;
        }

        @Override
        public void remove() {
            this.delegate.remove();
        }

        @Override
        public void add(JsonElement jsonElement) {
            this.delegate.add(new Entry(jsonElement));
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public JsonElement previous() {
            return this.delegate.previous().value;
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void set(JsonElement jsonElement) {
            this.delegate.set(new Entry(jsonElement));
        }
    }
}

