/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson;

public class JsonGrammar {
    public static final JsonGrammar JANKSON = JsonGrammar.builder().bareSpecialNumerics(true).build();
    public static final JsonGrammar JSON5 = JsonGrammar.builder().withComments(true).printTrailingCommas(true).bareSpecialNumerics(true).build();
    public static final JsonGrammar STRICT = JsonGrammar.builder().withComments(false).build();
    public static final JsonGrammar COMPACT = JsonGrammar.builder().withComments(false).printWhitespace(false).bareSpecialNumerics(true).build();
    protected boolean comments = true;
    protected boolean printWhitespace = true;
    protected boolean printCommas = true;
    protected boolean printTrailingCommas = false;
    protected boolean bareSpecialNumerics = false;
    protected boolean bareRootObject = false;
    protected boolean printUnquotedKeys = false;

    public boolean hasComments() {
        return this.comments;
    }

    public boolean shouldOutputWhitespace() {
        return this.printWhitespace;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private JsonGrammar grammar = new JsonGrammar();

        public Builder withComments(boolean bl) {
            this.grammar.comments = bl;
            return this;
        }

        public Builder printWhitespace(boolean bl) {
            this.grammar.printWhitespace = bl;
            return this;
        }

        public Builder printCommas(boolean bl) {
            this.grammar.printCommas = bl;
            return this;
        }

        public Builder printTrailingCommas(boolean bl) {
            this.grammar.printTrailingCommas = bl;
            return this;
        }

        public Builder bareSpecialNumerics(boolean bl) {
            this.grammar.bareSpecialNumerics = bl;
            return this;
        }

        public Builder bareRootObject(boolean bl) {
            this.grammar.bareRootObject = bl;
            return this;
        }

        public Builder printUnquotedKeys(boolean bl) {
            this.grammar.printUnquotedKeys = bl;
            return this;
        }

        public JsonGrammar build() {
            return this.grammar;
        }
    }
}

