/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson;

import dev.nolij.zume.shadow.blue.endless.jankson.JsonArray;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonElement;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonGrammar;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonNull;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonPrimitive;
import dev.nolij.zume.shadow.blue.endless.jankson.api.Marshaller;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.MarshallerImpl;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.serializer.CommentSerializer;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class JsonObject
extends JsonElement
implements Map<String, JsonElement> {
    private static final Predicate<String> CAN_BE_UNQUOTED = Pattern.compile("^[a-zA-Z0-9]+$").asPredicate();
    protected Marshaller marshaller = MarshallerImpl.getFallback();
    private List<Entry> entries = new ArrayList<Entry>();

    @Nullable
    public JsonObject getObject(@Nonnull String string) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            if (entry.value instanceof JsonObject) {
                return (JsonObject)entry.value;
            }
            return null;
        }
        return null;
    }

    public JsonElement put(@Nonnull String string, @Nonnull JsonElement jsonElement, @Nullable String string2) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            JsonElement jsonElement2 = entry.value;
            entry.value = jsonElement;
            entry.setComment(string2);
            return jsonElement2;
        }
        Entry entry = new Entry();
        if (jsonElement instanceof JsonObject) {
            ((JsonObject)jsonElement).marshaller = this.marshaller;
        }
        if (jsonElement instanceof JsonArray) {
            ((JsonArray)jsonElement).marshaller = this.marshaller;
        }
        entry.key = string;
        entry.value = jsonElement;
        entry.setComment(string2);
        this.entries.add(entry);
        return null;
    }

    @Nonnull
    public JsonElement putDefault(@Nonnull String string, @Nonnull JsonElement jsonElement, @Nullable String string2) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            return entry.value;
        }
        Entry entry = new Entry();
        entry.key = string;
        entry.value = jsonElement;
        entry.setComment(string2);
        this.entries.add(entry);
        return jsonElement;
    }

    @Nullable
    public <T> T putDefault(@Nonnull String string, @Nonnull T t, @Nullable String string2) {
        return this.putDefault(string, t, t.getClass(), string2);
    }

    @Nullable
    public <T> T putDefault(@Nonnull String string, @Nonnull T t, Class<? extends T> clazz, @Nullable String string2) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            return this.marshaller.marshall(clazz, entry.value);
        }
        Entry entry = new Entry();
        entry.key = string;
        entry.value = this.marshaller.serialize(t);
        if (entry.value == null) {
            entry.value = JsonNull.INSTANCE;
        }
        entry.setComment(string2);
        this.entries.add(entry);
        return t;
    }

    @Nonnull
    public JsonObject getDelta(@Nonnull JsonObject jsonObject) {
        JsonObject jsonObject2 = new JsonObject();
        for (Entry entry : this.entries) {
            String string = entry.key;
            JsonElement jsonElement = jsonObject.get(string);
            if (jsonElement == null) {
                jsonObject2.put(entry.key, entry.value, entry.getComment());
                continue;
            }
            if (entry.value instanceof JsonObject && jsonElement instanceof JsonObject) {
                JsonObject jsonObject3 = ((JsonObject)entry.value).getDelta((JsonObject)jsonElement);
                if (jsonObject3.isEmpty()) continue;
                jsonObject2.put(entry.key, jsonObject3, entry.getComment());
                continue;
            }
            if (entry.value.equals(jsonElement)) continue;
            jsonObject2.put(entry.key, entry.value, entry.getComment());
        }
        return jsonObject2;
    }

    @Nullable
    public String getComment(@Nonnull String string) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            return entry.getComment();
        }
        return null;
    }

    public void setComment(@Nonnull String string, @Nullable String string2) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            entry.setComment(string2);
            return;
        }
    }

    @Override
    public String toJson(boolean bl, boolean bl2, int n) {
        JsonGrammar jsonGrammar = JsonGrammar.builder().withComments(bl).printWhitespace(bl2).build();
        return this.toJson(jsonGrammar, n);
    }

    @Override
    public void toJson(Writer writer, JsonGrammar jsonGrammar, int n) throws IOException {
        int n2;
        int n3;
        boolean bl = n == 0 && jsonGrammar.bareRootObject;
        int n4 = jsonGrammar.bareRootObject ? n - 1 : n;
        int n5 = n3 = jsonGrammar.bareRootObject ? n : n + 1;
        if (!bl) {
            writer.append("{");
            if (jsonGrammar.printWhitespace && this.entries.size() > 0) {
                writer.append('\n');
            } else {
                writer.append(' ');
            }
        }
        for (n2 = 0; n2 < this.entries.size(); ++n2) {
            int n6;
            Entry entry = this.entries.get(n2);
            if (jsonGrammar.printWhitespace) {
                for (n6 = 0; n6 < n3; ++n6) {
                    writer.append("\t");
                }
            }
            CommentSerializer.print(writer, entry.getComment(), n4, jsonGrammar);
            int n7 = n6 = !jsonGrammar.printUnquotedKeys ? 1 : 0;
            if (!CAN_BE_UNQUOTED.test(entry.key)) {
                n6 = 1;
            }
            if (n6 != 0) {
                writer.append("\"");
            }
            writer.append(entry.key);
            if (n6 != 0) {
                writer.append("\"");
            }
            writer.append(": ");
            writer.append(entry.value.toJson(jsonGrammar, n + 1));
            if (jsonGrammar.printCommas) {
                if (n2 < this.entries.size() - 1 || jsonGrammar.printTrailingCommas) {
                    writer.append(",");
                    if (n2 < this.entries.size() - 1 && !jsonGrammar.printWhitespace) {
                        writer.append(' ');
                    }
                }
            } else if (!jsonGrammar.printWhitespace) {
                writer.append(" ");
            }
            if (!jsonGrammar.printWhitespace) continue;
            writer.append('\n');
        }
        if (!bl) {
            if (this.entries.size() > 0) {
                if (jsonGrammar.printWhitespace) {
                    for (n2 = 0; n2 < n4; ++n2) {
                        writer.append("\t");
                    }
                } else {
                    writer.append(' ');
                }
            }
            writer.append("}");
        }
    }

    public String toString() {
        return this.toJson(true, false, 0);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof JsonObject)) {
            return false;
        }
        JsonObject jsonObject = (JsonObject)object;
        if (this.entries.size() != jsonObject.entries.size()) {
            return false;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry;
            Entry entry2 = this.entries.get(i);
            if (entry2.equals(entry = jsonObject.entries.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.entries.hashCode();
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public Marshaller getMarshaller() {
        return this.marshaller;
    }

    @Nullable
    public <E> E get(@Nonnull Class<E> clazz, @Nonnull String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        JsonElement jsonElement = this.get(string);
        return this.marshaller.marshall(clazz, jsonElement);
    }

    public boolean getBoolean(@Nonnull String string, boolean bl) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asBoolean(bl);
        }
        return bl;
    }

    public byte getByte(@Nonnull String string, byte by) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asByte(by);
        }
        return by;
    }

    public char getChar(@Nonnull String string, char c) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asChar(c);
        }
        return c;
    }

    public short getShort(@Nonnull String string, short s) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asShort(s);
        }
        return s;
    }

    public int getInt(@Nonnull String string, int n) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asInt(n);
        }
        return n;
    }

    public long getLong(@Nonnull String string, long l) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asLong(l);
        }
        return l;
    }

    public float getFloat(@Nonnull String string, float f) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asFloat(f);
        }
        return f;
    }

    public double getDouble(@Nonnull String string, double d) {
        JsonElement jsonElement = this.get(string);
        if (jsonElement != null && jsonElement instanceof JsonPrimitive) {
            return ((JsonPrimitive)jsonElement).asDouble(d);
        }
        return d;
    }

    @Nullable
    public <E> E recursiveGet(@Nonnull Class<E> clazz, @Nonnull String string) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] stringArray = string.split("\\.");
        JsonObject jsonObject = this;
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + string + "'");
            }
            JsonElement jsonElement = jsonObject.get(string2);
            if (i < stringArray.length - 1) {
                if (!(jsonElement instanceof JsonObject)) {
                    return null;
                }
            } else {
                return this.marshaller.marshall(clazz, jsonElement);
            }
            jsonObject = (JsonObject)jsonElement;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + string + "'");
    }

    public <E extends JsonElement> E recursiveGetOrCreate(@Nonnull Class<E> clazz, @Nonnull String string, @Nonnull E e, @Nullable String string2) {
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Cannot get from empty key");
        }
        String[] stringArray = string.split("\\.");
        JsonElement jsonElement = this;
        for (int i = 0; i < stringArray.length; ++i) {
            JsonElement jsonElement2;
            String string3 = stringArray[i];
            if (string3.isEmpty()) {
                throw new IllegalArgumentException("Cannot get from broken key '" + string + "'");
            }
            JsonElement jsonElement3 = jsonElement.get(string3);
            if (i < stringArray.length - 1) {
                if (jsonElement3 instanceof JsonObject) {
                    jsonElement = (JsonObject)jsonElement3;
                    continue;
                }
                jsonElement2 = new JsonObject();
                jsonElement.put(string3, jsonElement2);
                jsonElement = jsonElement2;
                continue;
            }
            if (jsonElement3 != null && clazz.isAssignableFrom(jsonElement3.getClass())) {
                return (E)jsonElement3;
            }
            jsonElement2 = e.clone();
            jsonElement.put(string3, jsonElement2, string2);
            return (E)jsonElement2;
        }
        throw new IllegalArgumentException("Cannot get from broken key '" + string + "'");
    }

    @Override
    public JsonObject clone() {
        JsonObject jsonObject = new JsonObject();
        for (Entry entry : this.entries) {
            jsonObject.put(entry.key, entry.value.clone(), entry.comment);
        }
        jsonObject.marshaller = this.marshaller;
        return jsonObject;
    }

    @Override
    @Nullable
    public JsonElement put(@Nonnull String string, @Nonnull JsonElement jsonElement) {
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase(string)) continue;
            JsonElement jsonElement2 = entry.value;
            entry.value = jsonElement;
            return jsonElement2;
        }
        Entry entry = new Entry();
        entry.key = string;
        entry.value = jsonElement;
        this.entries.add(entry);
        return null;
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean containsKey(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof String)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(@Nullable Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof JsonElement)) {
            return false;
        }
        for (Entry entry : this.entries) {
            if (!entry.value.equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, JsonElement>> entrySet() {
        LinkedHashSet<Map.Entry<String, JsonElement>> linkedHashSet = new LinkedHashSet<Map.Entry<String, JsonElement>>();
        for (final Entry entry : this.entries) {
            linkedHashSet.add(new Map.Entry<String, JsonElement>(){

                @Override
                public String getKey() {
                    return entry.key;
                }

                @Override
                public JsonElement getValue() {
                    return entry.value;
                }

                @Override
                public JsonElement setValue(JsonElement jsonElement) {
                    JsonElement jsonElement2 = entry.value;
                    entry.value = jsonElement;
                    return jsonElement2;
                }
            });
        }
        return linkedHashSet;
    }

    @Override
    @Nullable
    public JsonElement get(@Nullable Object object) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!entry.key.equalsIgnoreCase((String)object)) continue;
            return entry.value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Entry entry : this.entries) {
            hashSet.add(entry.key);
        }
        return hashSet;
    }

    @Override
    public void putAll(Map<? extends String, ? extends JsonElement> map) {
        for (Map.Entry<? extends String, ? extends JsonElement> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Nullable
    public JsonElement remove(@Nullable Object object) {
        if (object == null || !(object instanceof String)) {
            return null;
        }
        for (int i = 0; i < this.entries.size(); ++i) {
            Entry entry = this.entries.get(i);
            if (!entry.key.equalsIgnoreCase((String)object)) continue;
            return this.entries.remove((int)i).value;
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<JsonElement> values() {
        ArrayList<JsonElement> arrayList = new ArrayList<JsonElement>();
        for (Entry entry : this.entries) {
            arrayList.add(entry.value);
        }
        return arrayList;
    }

    private static final class Entry {
        private String comment;
        protected String key;
        protected JsonElement value;

        private Entry() {
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)object;
            if (!Objects.equals(this.comment, entry.comment)) {
                return false;
            }
            if (!this.key.equals(entry.key)) {
                return false;
            }
            return this.value.equals(entry.value);
        }

        public int hashCode() {
            return Objects.hash(this.comment, this.key, this.value);
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String string) {
            this.comment = string != null && !string.trim().isEmpty() ? string : null;
        }
    }
}

