/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson.impl;

import dev.nolij.zume.shadow.blue.endless.jankson.Jankson;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonElement;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonNull;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonPrimitive;
import dev.nolij.zume.shadow.blue.endless.jankson.api.SyntaxError;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.AnnotatedElement;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ArrayParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.CommentParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.NumberParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ObjectParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.ParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.StringParserContext;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.TokenParserContext;
import java.util.Locale;

public class ElementParserContext
implements ParserContext<AnnotatedElement> {
    String comment = null;
    AnnotatedElement result = null;
    boolean childActive = false;

    @Override
    public boolean consume(int n, Jankson jankson) throws SyntaxError {
        if (Character.isWhitespace(n)) {
            return true;
        }
        switch (n) {
            case 35: 
            case 47: {
                jankson.push(new CommentParserContext(n), string -> {
                    this.comment = string;
                });
                return true;
            }
            case 34: 
            case 39: {
                jankson.push(new StringParserContext(n), this::setResult);
                this.childActive = true;
                return true;
            }
            case 123: {
                jankson.push(new ObjectParserContext(false), this::setResult);
                this.childActive = true;
                return false;
            }
            case 91: {
                jankson.push(new ArrayParserContext(), this::setResult);
                this.childActive = true;
                return true;
            }
            case 125: {
                jankson.throwDelayed(new SyntaxError("Found '" + (char)n + "' while parsing an element - this shouldn't happen!"));
                return false;
            }
            case 93: {
                this.result = new AnnotatedElement(null, this.comment);
                return false;
            }
        }
        if (Character.isDigit(n) || n == 45 || n == 43 || n == 46) {
            jankson.push(new NumberParserContext(n), this::setResult);
            this.childActive = true;
            return true;
        }
        jankson.push(new TokenParserContext(n), jsonPrimitive -> {
            String string;
            switch (string = jsonPrimitive.asString().toLowerCase(Locale.ROOT)) {
                case "null": {
                    this.setResult(JsonNull.INSTANCE);
                    break;
                }
                case "true": {
                    this.setResult(JsonPrimitive.TRUE);
                    break;
                }
                case "false": {
                    this.setResult(JsonPrimitive.FALSE);
                    break;
                }
                case "infinity": 
                case "+infinity": {
                    this.setResult(new JsonPrimitive(Double.POSITIVE_INFINITY));
                    break;
                }
                case "-infinity": {
                    this.setResult(new JsonPrimitive(Double.NEGATIVE_INFINITY));
                    break;
                }
                case "nan": {
                    this.setResult(new JsonPrimitive(Double.NaN));
                    break;
                }
                default: {
                    this.setResult((JsonElement)jsonPrimitive);
                }
            }
        });
        this.childActive = true;
        return true;
    }

    public void setResult(JsonElement jsonElement) {
        this.result = new AnnotatedElement(jsonElement, this.comment);
    }

    @Override
    public void eof() throws SyntaxError {
        if (!this.childActive) {
            throw new SyntaxError("Unexpected end-of-file while looking for a json element!");
        }
    }

    @Override
    public boolean isComplete() {
        return this.result != null;
    }

    @Override
    public AnnotatedElement getResult() throws SyntaxError {
        return this.result;
    }
}

