/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.shadow.blue.endless.jankson.impl.serializer;

import dev.nolij.zume.shadow.blue.endless.jankson.JsonArray;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonElement;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonGrammar;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonObject;
import dev.nolij.zume.shadow.blue.endless.jankson.JsonPrimitive;
import dev.nolij.zume.shadow.blue.endless.jankson.api.DeserializationException;
import dev.nolij.zume.shadow.blue.endless.jankson.api.Marshaller;
import dev.nolij.zume.shadow.blue.endless.jankson.impl.serializer.InternalDeserializerFunction;
import java.util.HashMap;

public class DeserializerFunctionPool<B> {
    private Class<B> targetClass;
    private HashMap<Class<?>, InternalDeserializerFunction<B>> values = new HashMap();

    public DeserializerFunctionPool(Class<B> clazz) {
        this.targetClass = clazz;
    }

    public void registerUnsafe(Class<?> clazz, InternalDeserializerFunction<B> internalDeserializerFunction) {
        this.values.put(clazz, internalDeserializerFunction);
    }

    public InternalDeserializerFunction<B> getFunction(Class<?> clazz) {
        return this.values.get(clazz);
    }

    public B apply(JsonElement jsonElement, Marshaller marshaller) throws DeserializationException, FunctionMatchFailedException {
        InternalDeserializerFunction<B> internalDeserializerFunction = null;
        if (jsonElement instanceof JsonPrimitive) {
            Object object = ((JsonPrimitive)jsonElement).getValue();
            internalDeserializerFunction = this.values.get(object.getClass());
            if (internalDeserializerFunction != null) {
                return internalDeserializerFunction.deserialize(object, marshaller);
            }
            internalDeserializerFunction = this.values.get(JsonPrimitive.class);
            if (internalDeserializerFunction != null) {
                return internalDeserializerFunction.deserialize((JsonPrimitive)jsonElement, marshaller);
            }
        } else if (jsonElement instanceof JsonObject) {
            internalDeserializerFunction = this.values.get(JsonObject.class);
            if (internalDeserializerFunction != null) {
                return internalDeserializerFunction.deserialize((JsonObject)jsonElement, marshaller);
            }
        } else if (jsonElement instanceof JsonArray && (internalDeserializerFunction = this.values.get(JsonArray.class)) != null) {
            return internalDeserializerFunction.deserialize((JsonArray)jsonElement, marshaller);
        }
        if ((internalDeserializerFunction = this.values.get(JsonElement.class)) != null) {
            return internalDeserializerFunction.deserialize(jsonElement, marshaller);
        }
        throw new FunctionMatchFailedException("Couldn't find a deserializer in class '" + this.targetClass.getCanonicalName() + "' to unpack element '" + jsonElement.toJson(JsonGrammar.JSON5) + "'.");
    }

    public static class FunctionMatchFailedException
    extends Exception {
        private static final long serialVersionUID = -7909332778483440658L;

        public FunctionMatchFailedException(String string) {
            super(string);
        }
    }
}

