/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.zume.vintage;

import dev.nolij.zume.common.CameraPerspective;
import dev.nolij.zume.common.IZumeImplementation;
import dev.nolij.zume.common.Zume;
import dev.nolij.zume.vintage.ZumeKeyBind;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;

public class VintageZume
implements IZumeImplementation {
    public VintageZume() {
        if (!FMLLaunchHandler.side().isClient()) {
            return;
        }
        Zume.LOGGER.info("Loading Vintage Zume...");
        Zume.init(this, new File(Launch.minecraftHome, "config").toPath());
        if (Zume.disabled) {
            return;
        }
        for (ZumeKeyBind zumeKeyBind : ZumeKeyBind.values()) {
            ClientRegistry.registerKeyBinding((KeyBinding)zumeKeyBind.value);
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isZoomPressed() {
        return Minecraft.func_71410_x().field_71462_r == null && ZumeKeyBind.ZOOM.isPressed();
    }

    @Override
    public boolean isZoomInPressed() {
        return ZumeKeyBind.ZOOM_IN.isPressed();
    }

    @Override
    public boolean isZoomOutPressed() {
        return ZumeKeyBind.ZOOM_OUT.isPressed();
    }

    @Override
    public CameraPerspective getCameraPerspective() {
        return CameraPerspective.values()[Minecraft.func_71410_x().field_71474_y.field_74320_O];
    }

    @SubscribeEvent
    public void render(TickEvent.RenderTickEvent renderTickEvent) {
        if (renderTickEvent.phase == TickEvent.Phase.START) {
            Zume.render();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void calculateFOV(EntityViewRenderEvent.FOVModifier fOVModifier) {
        if (Zume.shouldHookFOV()) {
            fOVModifier.setFOV((float)Zume.transformFOV(fOVModifier.getFOV()));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void mouseEvent(MouseEvent mouseEvent) {
        int n = mouseEvent.getDwheel();
        if (Zume.interceptScroll(n)) {
            mouseEvent.setCanceled(true);
        }
    }
}

