/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components.toasts;

import java.util.List;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class AdvancementToast
implements Toast {
    private static final ResourceLocation BACKGROUND_SPRITE = ResourceLocation.withDefaultNamespace("toast/advancement");
    public static final int DISPLAY_TIME = 5000;
    private final AdvancementHolder advancement;
    private boolean playedSound;

    public AdvancementToast(AdvancementHolder p_301007_) {
        this.advancement = p_301007_;
    }

    @Override
    public Toast.Visibility render(GuiGraphics p_281813_, ToastComponent p_282243_, long p_282604_) {
        DisplayInfo $$3 = this.advancement.value().display().orElse(null);
        p_281813_.blitSprite(BACKGROUND_SPRITE, 0, 0, this.width(), this.height());
        if ($$3 != null) {
            int $$5;
            List<FormattedCharSequence> $$4 = p_282243_.getMinecraft().font.split($$3.getTitle(), 125);
            int n = $$5 = $$3.getType() == AdvancementType.CHALLENGE ? 0xFF88FF : 0xFFFF00;
            if ($$4.size() == 1) {
                p_281813_.drawString(p_282243_.getMinecraft().font, $$3.getType().getDisplayName(), 30, 7, $$5 | 0xFF000000, false);
                p_281813_.drawString(p_282243_.getMinecraft().font, $$4.get(0), 30, 18, -1, false);
            } else {
                int $$6 = 1500;
                float $$7 = 300.0f;
                if (p_282604_ < 1500L) {
                    int $$8 = Mth.floor(Mth.clamp((float)(1500L - p_282604_) / 300.0f, 0.0f, 1.0f) * 255.0f) << 24 | 0x4000000;
                    p_281813_.drawString(p_282243_.getMinecraft().font, $$3.getType().getDisplayName(), 30, 11, $$5 | $$8, false);
                } else {
                    int $$9 = Mth.floor(Mth.clamp((float)(p_282604_ - 1500L) / 300.0f, 0.0f, 1.0f) * 252.0f) << 24 | 0x4000000;
                    int $$10 = this.height() / 2 - $$4.size() * p_282243_.getMinecraft().font.lineHeight / 2;
                    for (FormattedCharSequence $$11 : $$4) {
                        p_281813_.drawString(p_282243_.getMinecraft().font, $$11, 30, $$10, 0xFFFFFF | $$9, false);
                        $$10 += p_282243_.getMinecraft().font.lineHeight;
                    }
                }
            }
            if (!this.playedSound && p_282604_ > 0L) {
                this.playedSound = true;
                if ($$3.getType() == AdvancementType.CHALLENGE) {
                    p_282243_.getMinecraft().getSoundManager().play(SimpleSoundInstance.forUI(SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, 1.0f, 1.0f));
                }
            }
            p_281813_.renderFakeItem($$3.getIcon(), 8, 8);
            return (double)p_282604_ >= 5000.0 * p_282243_.getNotificationDisplayTimeMultiplier() ? Toast.Visibility.HIDE : Toast.Visibility.SHOW;
        }
        return Toast.Visibility.HIDE;
    }
}

