/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.screens.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.model.BookModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public class EnchantmentScreen
extends AbstractContainerScreen<EnchantmentMenu> {
    private static final ResourceLocation[] ENABLED_LEVEL_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/enchanting_table/level_1"), ResourceLocation.withDefaultNamespace("container/enchanting_table/level_2"), ResourceLocation.withDefaultNamespace("container/enchanting_table/level_3")};
    private static final ResourceLocation[] DISABLED_LEVEL_SPRITES = new ResourceLocation[]{ResourceLocation.withDefaultNamespace("container/enchanting_table/level_1_disabled"), ResourceLocation.withDefaultNamespace("container/enchanting_table/level_2_disabled"), ResourceLocation.withDefaultNamespace("container/enchanting_table/level_3_disabled")};
    private static final ResourceLocation ENCHANTMENT_SLOT_DISABLED_SPRITE = ResourceLocation.withDefaultNamespace("container/enchanting_table/enchantment_slot_disabled");
    private static final ResourceLocation ENCHANTMENT_SLOT_HIGHLIGHTED_SPRITE = ResourceLocation.withDefaultNamespace("container/enchanting_table/enchantment_slot_highlighted");
    private static final ResourceLocation ENCHANTMENT_SLOT_SPRITE = ResourceLocation.withDefaultNamespace("container/enchanting_table/enchantment_slot");
    private static final ResourceLocation ENCHANTING_TABLE_LOCATION = ResourceLocation.withDefaultNamespace("textures/gui/container/enchanting_table.png");
    private static final ResourceLocation ENCHANTING_BOOK_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/enchanting_table_book.png");
    private final RandomSource random = RandomSource.create();
    private BookModel bookModel;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    private ItemStack last = ItemStack.EMPTY;

    public EnchantmentScreen(EnchantmentMenu p_98754_, Inventory p_98755_, Component p_98756_) {
        super(p_98754_, p_98755_, p_98756_);
    }

    @Override
    protected void init() {
        super.init();
        this.bookModel = new BookModel(this.minecraft.getEntityModels().bakeLayer(ModelLayers.BOOK));
    }

    @Override
    public void containerTick() {
        super.containerTick();
        this.tickBook();
    }

    @Override
    public boolean mouseClicked(double p_98758_, double p_98759_, int p_98760_) {
        int $$3 = (this.width - this.imageWidth) / 2;
        int $$4 = (this.height - this.imageHeight) / 2;
        for (int $$5 = 0; $$5 < 3; ++$$5) {
            double $$6 = p_98758_ - (double)($$3 + 60);
            double $$7 = p_98759_ - (double)($$4 + 14 + 19 * $$5);
            if (!($$6 >= 0.0) || !($$7 >= 0.0) || !($$6 < 108.0) || !($$7 < 19.0) || !((EnchantmentMenu)this.menu).clickMenuButton(this.minecraft.player, $$5)) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, $$5);
            return true;
        }
        return super.mouseClicked(p_98758_, p_98759_, p_98760_);
    }

    @Override
    protected void renderBg(GuiGraphics p_282430_, float p_282530_, int p_281621_, int p_283333_) {
        int $$4 = (this.width - this.imageWidth) / 2;
        int $$5 = (this.height - this.imageHeight) / 2;
        p_282430_.blit(ENCHANTING_TABLE_LOCATION, $$4, $$5, 0, 0, this.imageWidth, this.imageHeight);
        this.renderBook(p_282430_, $$4, $$5, p_282530_);
        EnchantmentNames.getInstance().initSeed(((EnchantmentMenu)this.menu).getEnchantmentSeed());
        int $$6 = ((EnchantmentMenu)this.menu).getGoldCount();
        for (int $$7 = 0; $$7 < 3; ++$$7) {
            int $$8 = $$4 + 60;
            int $$9 = $$8 + 20;
            int $$10 = ((EnchantmentMenu)this.menu).costs[$$7];
            if ($$10 == 0) {
                RenderSystem.enableBlend();
                p_282430_.blitSprite(ENCHANTMENT_SLOT_DISABLED_SPRITE, $$8, $$5 + 14 + 19 * $$7, 108, 19);
                RenderSystem.disableBlend();
                continue;
            }
            String $$11 = "" + $$10;
            int $$12 = 86 - this.font.width($$11);
            FormattedText $$13 = EnchantmentNames.getInstance().getRandomName(this.font, $$12);
            int $$14 = 6839882;
            if (!($$6 >= $$7 + 1 && this.minecraft.player.experienceLevel >= $$10 || this.minecraft.player.getAbilities().instabuild)) {
                RenderSystem.enableBlend();
                p_282430_.blitSprite(ENCHANTMENT_SLOT_DISABLED_SPRITE, $$8, $$5 + 14 + 19 * $$7, 108, 19);
                p_282430_.blitSprite(DISABLED_LEVEL_SPRITES[$$7], $$8 + 1, $$5 + 15 + 19 * $$7, 16, 16);
                RenderSystem.disableBlend();
                p_282430_.drawWordWrap(this.font, $$13, $$9, $$5 + 16 + 19 * $$7, $$12, ($$14 & 0xFEFEFE) >> 1);
                $$14 = 4226832;
            } else {
                int $$15 = p_281621_ - ($$4 + 60);
                int $$16 = p_283333_ - ($$5 + 14 + 19 * $$7);
                RenderSystem.enableBlend();
                if ($$15 >= 0 && $$16 >= 0 && $$15 < 108 && $$16 < 19) {
                    p_282430_.blitSprite(ENCHANTMENT_SLOT_HIGHLIGHTED_SPRITE, $$8, $$5 + 14 + 19 * $$7, 108, 19);
                    $$14 = 0xFFFF80;
                } else {
                    p_282430_.blitSprite(ENCHANTMENT_SLOT_SPRITE, $$8, $$5 + 14 + 19 * $$7, 108, 19);
                }
                p_282430_.blitSprite(ENABLED_LEVEL_SPRITES[$$7], $$8 + 1, $$5 + 15 + 19 * $$7, 16, 16);
                RenderSystem.disableBlend();
                p_282430_.drawWordWrap(this.font, $$13, $$9, $$5 + 16 + 19 * $$7, $$12, $$14);
                $$14 = 8453920;
            }
            p_282430_.drawString(this.font, $$11, $$9 + 86 - this.font.width($$11), $$5 + 16 + 19 * $$7 + 7, $$14);
        }
    }

    private void renderBook(GuiGraphics p_289697_, int p_289667_, int p_289669_, float p_289670_) {
        float $$4 = Mth.lerp(p_289670_, this.oOpen, this.open);
        float $$5 = Mth.lerp(p_289670_, this.oFlip, this.flip);
        Lighting.setupForEntityInInventory();
        p_289697_.pose().pushPose();
        p_289697_.pose().translate((float)p_289667_ + 33.0f, (float)p_289669_ + 31.0f, 100.0f);
        float $$6 = 40.0f;
        p_289697_.pose().scale(-40.0f, 40.0f, 40.0f);
        p_289697_.pose().mulPose(Axis.XP.rotationDegrees(25.0f));
        p_289697_.pose().translate((1.0f - $$4) * 0.2f, (1.0f - $$4) * 0.1f, (1.0f - $$4) * 0.25f);
        float $$7 = -(1.0f - $$4) * 90.0f - 90.0f;
        p_289697_.pose().mulPose(Axis.YP.rotationDegrees($$7));
        p_289697_.pose().mulPose(Axis.XP.rotationDegrees(180.0f));
        float $$8 = Mth.clamp(Mth.frac($$5 + 0.25f) * 1.6f - 0.3f, 0.0f, 1.0f);
        float $$9 = Mth.clamp(Mth.frac($$5 + 0.75f) * 1.6f - 0.3f, 0.0f, 1.0f);
        this.bookModel.setupAnim(0.0f, $$8, $$9, $$4);
        VertexConsumer $$10 = p_289697_.bufferSource().getBuffer(this.bookModel.renderType(ENCHANTING_BOOK_LOCATION));
        this.bookModel.renderToBuffer(p_289697_.pose(), $$10, 0xF000F0, OverlayTexture.NO_OVERLAY);
        p_289697_.flush();
        p_289697_.pose().popPose();
        Lighting.setupFor3DItems();
    }

    @Override
    public void render(GuiGraphics p_283462_, int p_282491_, int p_281953_, float p_282182_) {
        super.render(p_283462_, p_282491_, p_281953_, p_282182_);
        this.renderTooltip(p_283462_, p_282491_, p_281953_);
        boolean $$4 = this.minecraft.player.getAbilities().instabuild;
        int $$5 = ((EnchantmentMenu)this.menu).getGoldCount();
        for (int $$6 = 0; $$6 < 3; ++$$6) {
            int $$7 = ((EnchantmentMenu)this.menu).costs[$$6];
            Optional<Holder.Reference<Enchantment>> $$8 = this.minecraft.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(((EnchantmentMenu)this.menu).enchantClue[$$6]);
            if ($$8.isEmpty()) continue;
            int $$9 = ((EnchantmentMenu)this.menu).levelClue[$$6];
            int $$10 = $$6 + 1;
            if (!this.isHovering(60, 14 + 19 * $$6, 108, 17, p_282491_, p_281953_) || $$7 <= 0 || $$9 < 0 || $$8 == null) continue;
            ArrayList $$11 = Lists.newArrayList();
            $$11.add(Component.translatable("container.enchant.clue", Enchantment.getFullname((Holder<Enchantment>)$$8.get(), $$9)).withStyle(ChatFormatting.WHITE));
            if (!$$4) {
                $$11.add(CommonComponents.EMPTY);
                if (this.minecraft.player.experienceLevel < $$7) {
                    $$11.add(Component.translatable("container.enchant.level.requirement", ((EnchantmentMenu)this.menu).costs[$$6]).withStyle(ChatFormatting.RED));
                } else {
                    MutableComponent $$15;
                    MutableComponent $$13;
                    if ($$10 == 1) {
                        MutableComponent $$12 = Component.translatable("container.enchant.lapis.one");
                    } else {
                        $$13 = Component.translatable("container.enchant.lapis.many", $$10);
                    }
                    $$11.add($$13.withStyle($$5 >= $$10 ? ChatFormatting.GRAY : ChatFormatting.RED));
                    if ($$10 == 1) {
                        MutableComponent $$14 = Component.translatable("container.enchant.level.one");
                    } else {
                        $$15 = Component.translatable("container.enchant.level.many", $$10);
                    }
                    $$11.add($$15.withStyle(ChatFormatting.GRAY));
                }
            }
            p_283462_.renderComponentTooltip(this.font, $$11, p_282491_, p_281953_);
            break;
        }
    }

    public void tickBook() {
        ItemStack $$0 = ((EnchantmentMenu)this.menu).getSlot(0).getItem();
        if (!ItemStack.matches($$0, this.last)) {
            this.last = $$0;
            do {
                this.flipT += (float)(this.random.nextInt(4) - this.random.nextInt(4));
            } while (this.flip <= this.flipT + 1.0f && this.flip >= this.flipT - 1.0f);
        }
        ++this.time;
        this.oFlip = this.flip;
        this.oOpen = this.open;
        boolean $$1 = false;
        for (int $$2 = 0; $$2 < 3; ++$$2) {
            if (((EnchantmentMenu)this.menu).costs[$$2] == 0) continue;
            $$1 = true;
        }
        this.open = $$1 ? (this.open += 0.2f) : (this.open -= 0.2f);
        this.open = Mth.clamp(this.open, 0.0f, 1.0f);
        float $$3 = (this.flipT - this.flip) * 0.4f;
        float $$4 = 0.2f;
        $$3 = Mth.clamp($$3, -0.2f, 0.2f);
        this.flipA += ($$3 - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }
}

