/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.ColorableAgeableListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;

public class WolfModel<T extends Wolf>
extends ColorableAgeableListModel<T> {
    private static final String REAL_HEAD = "real_head";
    private static final String UPPER_BODY = "upper_body";
    private static final String REAL_TAIL = "real_tail";
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;
    private static final int LEG_SIZE = 8;

    public WolfModel(ModelPart p_171087_) {
        this.head = p_171087_.getChild("head");
        this.realHead = this.head.getChild(REAL_HEAD);
        this.body = p_171087_.getChild("body");
        this.upperBody = p_171087_.getChild(UPPER_BODY);
        this.rightHindLeg = p_171087_.getChild("right_hind_leg");
        this.leftHindLeg = p_171087_.getChild("left_hind_leg");
        this.rightFrontLeg = p_171087_.getChild("right_front_leg");
        this.leftFrontLeg = p_171087_.getChild("left_front_leg");
        this.tail = p_171087_.getChild("tail");
        this.realTail = this.tail.getChild(REAL_TAIL);
    }

    public static MeshDefinition createMeshDefinition(CubeDeformation p_316269_) {
        MeshDefinition $$1 = new MeshDefinition();
        PartDefinition $$2 = $$1.getRoot();
        float $$3 = 13.5f;
        PartDefinition $$4 = $$2.addOrReplaceChild("head", CubeListBuilder.create(), PartPose.offset(-1.0f, 13.5f, -7.0f));
        $$4.addOrReplaceChild(REAL_HEAD, CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -2.0f, 6.0f, 6.0f, 4.0f, p_316269_).texOffs(16, 14).addBox(-2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, p_316269_).texOffs(16, 14).addBox(2.0f, -5.0f, 0.0f, 2.0f, 2.0f, 1.0f, p_316269_).texOffs(0, 10).addBox(-0.5f, -0.001f, -5.0f, 3.0f, 3.0f, 4.0f, p_316269_), PartPose.ZERO);
        $$2.addOrReplaceChild("body", CubeListBuilder.create().texOffs(18, 14).addBox(-3.0f, -2.0f, -3.0f, 6.0f, 9.0f, 6.0f, p_316269_), PartPose.offsetAndRotation(0.0f, 14.0f, 2.0f, 1.5707964f, 0.0f, 0.0f));
        $$2.addOrReplaceChild(UPPER_BODY, CubeListBuilder.create().texOffs(21, 0).addBox(-3.0f, -3.0f, -3.0f, 8.0f, 6.0f, 7.0f, p_316269_), PartPose.offsetAndRotation(-1.0f, 14.0f, -3.0f, 1.5707964f, 0.0f, 0.0f));
        CubeListBuilder $$5 = CubeListBuilder.create().texOffs(0, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, p_316269_);
        $$2.addOrReplaceChild("right_hind_leg", $$5, PartPose.offset(-2.5f, 16.0f, 7.0f));
        $$2.addOrReplaceChild("left_hind_leg", $$5, PartPose.offset(0.5f, 16.0f, 7.0f));
        $$2.addOrReplaceChild("right_front_leg", $$5, PartPose.offset(-2.5f, 16.0f, -4.0f));
        $$2.addOrReplaceChild("left_front_leg", $$5, PartPose.offset(0.5f, 16.0f, -4.0f));
        PartDefinition $$6 = $$2.addOrReplaceChild("tail", CubeListBuilder.create(), PartPose.offsetAndRotation(-1.0f, 12.0f, 8.0f, 0.62831855f, 0.0f, 0.0f));
        $$6.addOrReplaceChild(REAL_TAIL, CubeListBuilder.create().texOffs(9, 18).addBox(0.0f, 0.0f, -1.0f, 2.0f, 8.0f, 2.0f, p_316269_), PartPose.ZERO);
        return $$1;
    }

    @Override
    protected Iterable<ModelPart> headParts() {
        return ImmutableList.of((Object)this.head);
    }

    @Override
    protected Iterable<ModelPart> bodyParts() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    @Override
    public void prepareMobModel(T p_104132_, float p_104133_, float p_104134_, float p_104135_) {
        this.tail.yRot = p_104132_.isAngry() ? 0.0f : Mth.cos(p_104133_ * 0.6662f) * 1.4f * p_104134_;
        if (((TamableAnimal)p_104132_).isInSittingPose()) {
            this.upperBody.setPos(-1.0f, 16.0f, -3.0f);
            this.upperBody.xRot = 1.2566371f;
            this.upperBody.yRot = 0.0f;
            this.body.setPos(0.0f, 18.0f, 0.0f);
            this.body.xRot = 0.7853982f;
            this.tail.setPos(-1.0f, 21.0f, 6.0f);
            this.rightHindLeg.setPos(-2.5f, 22.7f, 2.0f);
            this.rightHindLeg.xRot = 4.712389f;
            this.leftHindLeg.setPos(0.5f, 22.7f, 2.0f);
            this.leftHindLeg.xRot = 4.712389f;
            this.rightFrontLeg.xRot = 5.811947f;
            this.rightFrontLeg.setPos(-2.49f, 17.0f, -4.0f);
            this.leftFrontLeg.xRot = 5.811947f;
            this.leftFrontLeg.setPos(0.51f, 17.0f, -4.0f);
        } else {
            this.body.setPos(0.0f, 14.0f, 2.0f);
            this.body.xRot = 1.5707964f;
            this.upperBody.setPos(-1.0f, 14.0f, -3.0f);
            this.upperBody.xRot = this.body.xRot;
            this.tail.setPos(-1.0f, 12.0f, 8.0f);
            this.rightHindLeg.setPos(-2.5f, 16.0f, 7.0f);
            this.leftHindLeg.setPos(0.5f, 16.0f, 7.0f);
            this.rightFrontLeg.setPos(-2.5f, 16.0f, -4.0f);
            this.leftFrontLeg.setPos(0.5f, 16.0f, -4.0f);
            this.rightHindLeg.xRot = Mth.cos(p_104133_ * 0.6662f) * 1.4f * p_104134_;
            this.leftHindLeg.xRot = Mth.cos(p_104133_ * 0.6662f + (float)Math.PI) * 1.4f * p_104134_;
            this.rightFrontLeg.xRot = Mth.cos(p_104133_ * 0.6662f + (float)Math.PI) * 1.4f * p_104134_;
            this.leftFrontLeg.xRot = Mth.cos(p_104133_ * 0.6662f) * 1.4f * p_104134_;
        }
        this.realHead.zRot = ((Wolf)p_104132_).getHeadRollAngle(p_104135_) + ((Wolf)p_104132_).getBodyRollAngle(p_104135_, 0.0f);
        this.upperBody.zRot = ((Wolf)p_104132_).getBodyRollAngle(p_104135_, -0.08f);
        this.body.zRot = ((Wolf)p_104132_).getBodyRollAngle(p_104135_, -0.16f);
        this.realTail.zRot = ((Wolf)p_104132_).getBodyRollAngle(p_104135_, -0.2f);
    }

    @Override
    public void setupAnim(T p_104137_, float p_104138_, float p_104139_, float p_104140_, float p_104141_, float p_104142_) {
        this.head.xRot = p_104142_ * ((float)Math.PI / 180);
        this.head.yRot = p_104141_ * ((float)Math.PI / 180);
        this.tail.xRot = p_104140_;
    }
}

