/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer.resolver;

import com.google.common.net.HostAndPort;
import com.mojang.logging.LogUtils;
import java.net.IDN;
import org.slf4j.Logger;

public final class ServerAddress {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final HostAndPort hostAndPort;
    private static final ServerAddress INVALID = new ServerAddress(HostAndPort.fromParts((String)"server.invalid", (int)25565));

    public ServerAddress(String p_171861_, int p_171862_) {
        this(HostAndPort.fromParts((String)p_171861_, (int)p_171862_));
    }

    private ServerAddress(HostAndPort p_171859_) {
        this.hostAndPort = p_171859_;
    }

    public String getHost() {
        try {
            return IDN.toASCII(this.hostAndPort.getHost());
        }
        catch (IllegalArgumentException $$0) {
            return "";
        }
    }

    public int getPort() {
        return this.hostAndPort.getPort();
    }

    public static ServerAddress parseString(String p_171865_) {
        if (p_171865_ == null) {
            return INVALID;
        }
        try {
            HostAndPort $$1 = HostAndPort.fromString((String)p_171865_).withDefaultPort(25565);
            if ($$1.getHost().isEmpty()) {
                return INVALID;
            }
            return new ServerAddress($$1);
        }
        catch (IllegalArgumentException $$2) {
            LOGGER.info("Failed to parse URL {}", (Object)p_171865_, (Object)$$2);
            return INVALID;
        }
    }

    public static boolean isValidAddress(String p_171868_) {
        try {
            HostAndPort $$1 = HostAndPort.fromString((String)p_171868_);
            String $$2 = $$1.getHost();
            if (!$$2.isEmpty()) {
                IDN.toASCII($$2);
                return true;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    static int parsePort(String p_171870_) {
        try {
            return Integer.parseInt(p_171870_.trim());
        }
        catch (Exception exception) {
            return 25565;
        }
    }

    public String toString() {
        return this.hostAndPort.toString();
    }

    public boolean equals(Object p_171872_) {
        if (this == p_171872_) {
            return true;
        }
        if (p_171872_ instanceof ServerAddress) {
            return this.hostAndPort.equals((Object)((ServerAddress)p_171872_).hostAndPort);
        }
        return false;
    }

    public int hashCode() {
        return this.hostAndPort.hashCode();
    }
}

