/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.shaders.Uniform;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.SheetedDecalTextureGenerator;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexMultiConsumer;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.client.Camera;
import net.minecraft.client.CloudStatus;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.PrioritizeChunkUpdates;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.OutlineBufferSource;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RunningTrimmedMean;
import net.minecraft.client.renderer.SectionOcclusionGraph;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.ViewArea;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.chunk.RenderRegionCache;
import net.minecraft.client.renderer.chunk.SectionRenderDispatcher;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SculkChargeParticleOptions;
import net.minecraft.core.particles.ShriekParticleOption;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.BlockDestructionProgress;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.TickRateManager;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawner;
import net.minecraft.world.level.block.entity.vault.VaultBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.FogType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.slf4j.Logger;

public class LevelRenderer
implements ResourceManagerReloadListener,
AutoCloseable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int SECTION_SIZE = 16;
    public static final int HALF_SECTION_SIZE = 8;
    private static final float SKY_DISC_RADIUS = 512.0f;
    private static final int MIN_FOG_DISTANCE = 32;
    private static final int RAIN_RADIUS = 10;
    private static final int RAIN_DIAMETER = 21;
    private static final int TRANSPARENT_SORT_COUNT = 15;
    private static final ResourceLocation MOON_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/moon_phases.png");
    private static final ResourceLocation SUN_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/sun.png");
    protected static final ResourceLocation CLOUDS_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/clouds.png");
    private static final ResourceLocation END_SKY_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/end_sky.png");
    private static final ResourceLocation FORCEFIELD_LOCATION = ResourceLocation.withDefaultNamespace("textures/misc/forcefield.png");
    private static final ResourceLocation RAIN_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/rain.png");
    private static final ResourceLocation SNOW_LOCATION = ResourceLocation.withDefaultNamespace("textures/environment/snow.png");
    public static final Direction[] DIRECTIONS = Direction.values();
    private final Minecraft minecraft;
    private final EntityRenderDispatcher entityRenderDispatcher;
    private final BlockEntityRenderDispatcher blockEntityRenderDispatcher;
    private final RenderBuffers renderBuffers;
    @Nullable
    private ClientLevel level;
    private final SectionOcclusionGraph sectionOcclusionGraph = new SectionOcclusionGraph();
    private final ObjectArrayList<SectionRenderDispatcher.RenderSection> visibleSections = new ObjectArrayList(10000);
    private final Set<BlockEntity> globalBlockEntities = Sets.newHashSet();
    @Nullable
    private ViewArea viewArea;
    @Nullable
    private VertexBuffer starBuffer;
    @Nullable
    private VertexBuffer skyBuffer;
    @Nullable
    private VertexBuffer darkBuffer;
    private boolean generateClouds = true;
    @Nullable
    private VertexBuffer cloudBuffer;
    private final RunningTrimmedMean frameTimes = new RunningTrimmedMean(100);
    private int ticks;
    private final Int2ObjectMap<BlockDestructionProgress> destroyingBlocks = new Int2ObjectOpenHashMap();
    private final Long2ObjectMap<SortedSet<BlockDestructionProgress>> destructionProgress = new Long2ObjectOpenHashMap();
    private final Map<BlockPos, SoundInstance> playingJukeboxSongs = Maps.newHashMap();
    @Nullable
    private RenderTarget entityTarget;
    @Nullable
    private PostChain entityEffect;
    @Nullable
    private RenderTarget translucentTarget;
    @Nullable
    private RenderTarget itemEntityTarget;
    @Nullable
    private RenderTarget particlesTarget;
    @Nullable
    private RenderTarget weatherTarget;
    @Nullable
    private RenderTarget cloudsTarget;
    @Nullable
    private PostChain transparencyChain;
    private int lastCameraSectionX = Integer.MIN_VALUE;
    private int lastCameraSectionY = Integer.MIN_VALUE;
    private int lastCameraSectionZ = Integer.MIN_VALUE;
    private double prevCamX = Double.MIN_VALUE;
    private double prevCamY = Double.MIN_VALUE;
    private double prevCamZ = Double.MIN_VALUE;
    private double prevCamRotX = Double.MIN_VALUE;
    private double prevCamRotY = Double.MIN_VALUE;
    private int prevCloudX = Integer.MIN_VALUE;
    private int prevCloudY = Integer.MIN_VALUE;
    private int prevCloudZ = Integer.MIN_VALUE;
    private Vec3 prevCloudColor = Vec3.ZERO;
    @Nullable
    private CloudStatus prevCloudsType;
    @Nullable
    private SectionRenderDispatcher sectionRenderDispatcher;
    private int lastViewDistance = -1;
    private int renderedEntities;
    private int culledEntities;
    private Frustum cullingFrustum;
    private boolean captureFrustum;
    @Nullable
    private Frustum capturedFrustum;
    private final Vector4f[] frustumPoints = new Vector4f[8];
    private final Vector3d frustumPos = new Vector3d(0.0, 0.0, 0.0);
    private double xTransparentOld;
    private double yTransparentOld;
    private double zTransparentOld;
    private int rainSoundTime;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    public LevelRenderer(Minecraft p_234245_, EntityRenderDispatcher p_234246_, BlockEntityRenderDispatcher p_234247_, RenderBuffers p_234248_) {
        this.minecraft = p_234245_;
        this.entityRenderDispatcher = p_234246_;
        this.blockEntityRenderDispatcher = p_234247_;
        this.renderBuffers = p_234248_;
        for (int $$4 = 0; $$4 < 32; ++$$4) {
            for (int $$5 = 0; $$5 < 32; ++$$5) {
                float $$6 = $$5 - 16;
                float $$7 = $$4 - 16;
                float $$8 = Mth.sqrt($$6 * $$6 + $$7 * $$7);
                this.rainSizeX[$$4 << 5 | $$5] = -$$7 / $$8;
                this.rainSizeZ[$$4 << 5 | $$5] = $$6 / $$8;
            }
        }
        this.createStars();
        this.createLightSky();
        this.createDarkSky();
    }

    private void renderSnowAndRain(LightTexture p_109704_, float p_109705_, double p_109706_, double p_109707_, double p_109708_) {
        float $$5 = this.minecraft.level.getRainLevel(p_109705_);
        if ($$5 <= 0.0f) {
            return;
        }
        p_109704_.turnOnLightLayer();
        ClientLevel $$6 = this.minecraft.level;
        int $$7 = Mth.floor(p_109706_);
        int $$8 = Mth.floor(p_109707_);
        int $$9 = Mth.floor(p_109708_);
        Tesselator $$10 = Tesselator.getInstance();
        BufferBuilder $$11 = null;
        RenderSystem.disableCull();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        int $$12 = 5;
        if (Minecraft.useFancyGraphics()) {
            $$12 = 10;
        }
        RenderSystem.depthMask(Minecraft.useShaderTransparency());
        int $$13 = -1;
        float $$14 = (float)this.ticks + p_109705_;
        RenderSystem.setShader(GameRenderer::getParticleShader);
        BlockPos.MutableBlockPos $$15 = new BlockPos.MutableBlockPos();
        for (int $$16 = $$9 - $$12; $$16 <= $$9 + $$12; ++$$16) {
            for (int $$17 = $$7 - $$12; $$17 <= $$7 + $$12; ++$$17) {
                int $$25;
                int $$18 = ($$16 - $$9 + 16) * 32 + $$17 - $$7 + 16;
                double $$19 = (double)this.rainSizeX[$$18] * 0.5;
                double $$20 = (double)this.rainSizeZ[$$18] * 0.5;
                $$15.set((double)$$17, p_109707_, (double)$$16);
                Biome $$21 = $$6.getBiome($$15).value();
                if (!$$21.hasPrecipitation()) continue;
                int $$22 = $$6.getHeight(Heightmap.Types.MOTION_BLOCKING, $$17, $$16);
                int $$23 = $$8 - $$12;
                int $$24 = $$8 + $$12;
                if ($$23 < $$22) {
                    $$23 = $$22;
                }
                if ($$24 < $$22) {
                    $$24 = $$22;
                }
                if (($$25 = $$22) < $$8) {
                    $$25 = $$8;
                }
                if ($$23 == $$24) continue;
                RandomSource $$26 = RandomSource.create($$17 * $$17 * 3121 + $$17 * 45238971 ^ $$16 * $$16 * 418711 + $$16 * 13761);
                $$15.set($$17, $$23, $$16);
                Biome.Precipitation $$27 = $$21.getPrecipitationAt($$15);
                if ($$27 == Biome.Precipitation.RAIN) {
                    if ($$13 != 0) {
                        if ($$13 >= 0) {
                            BufferUploader.drawWithShader($$11.buildOrThrow());
                        }
                        $$13 = 0;
                        RenderSystem.setShaderTexture(0, RAIN_LOCATION);
                        $$11 = $$10.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                    }
                    int $$28 = this.ticks & 0x1FFFF;
                    int $$29 = $$17 * $$17 * 3121 + $$17 * 45238971 + $$16 * $$16 * 418711 + $$16 * 13761 & 0xFF;
                    float $$30 = 3.0f + $$26.nextFloat();
                    float $$31 = -((float)($$28 + $$29) + p_109705_) / 32.0f * $$30;
                    float $$32 = $$31 % 32.0f;
                    double $$33 = (double)$$17 + 0.5 - p_109706_;
                    double $$34 = (double)$$16 + 0.5 - p_109708_;
                    float $$35 = (float)Math.sqrt($$33 * $$33 + $$34 * $$34) / (float)$$12;
                    float $$36 = ((1.0f - $$35 * $$35) * 0.5f + 0.5f) * $$5;
                    $$15.set($$17, $$25, $$16);
                    int $$37 = LevelRenderer.getLightColor($$6, $$15);
                    $$11.addVertex((float)((double)$$17 - p_109706_ - $$19 + 0.5), (float)((double)$$24 - p_109707_), (float)((double)$$16 - p_109708_ - $$20 + 0.5)).setUv(0.0f, (float)$$23 * 0.25f + $$32).setColor(1.0f, 1.0f, 1.0f, $$36).setLight($$37);
                    $$11.addVertex((float)((double)$$17 - p_109706_ + $$19 + 0.5), (float)((double)$$24 - p_109707_), (float)((double)$$16 - p_109708_ + $$20 + 0.5)).setUv(1.0f, (float)$$23 * 0.25f + $$32).setColor(1.0f, 1.0f, 1.0f, $$36).setLight($$37);
                    $$11.addVertex((float)((double)$$17 - p_109706_ + $$19 + 0.5), (float)((double)$$23 - p_109707_), (float)((double)$$16 - p_109708_ + $$20 + 0.5)).setUv(1.0f, (float)$$24 * 0.25f + $$32).setColor(1.0f, 1.0f, 1.0f, $$36).setLight($$37);
                    $$11.addVertex((float)((double)$$17 - p_109706_ - $$19 + 0.5), (float)((double)$$23 - p_109707_), (float)((double)$$16 - p_109708_ - $$20 + 0.5)).setUv(0.0f, (float)$$24 * 0.25f + $$32).setColor(1.0f, 1.0f, 1.0f, $$36).setLight($$37);
                    continue;
                }
                if ($$27 != Biome.Precipitation.SNOW) continue;
                if ($$13 != 1) {
                    if ($$13 >= 0) {
                        BufferUploader.drawWithShader($$11.buildOrThrow());
                    }
                    $$13 = 1;
                    RenderSystem.setShaderTexture(0, SNOW_LOCATION);
                    $$11 = $$10.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.PARTICLE);
                }
                float $$38 = -((float)(this.ticks & 0x1FF) + p_109705_) / 512.0f;
                float $$39 = (float)($$26.nextDouble() + (double)$$14 * 0.01 * (double)((float)$$26.nextGaussian()));
                float $$40 = (float)($$26.nextDouble() + (double)($$14 * (float)$$26.nextGaussian()) * 0.001);
                double $$41 = (double)$$17 + 0.5 - p_109706_;
                double $$42 = (double)$$16 + 0.5 - p_109708_;
                float $$43 = (float)Math.sqrt($$41 * $$41 + $$42 * $$42) / (float)$$12;
                float $$44 = ((1.0f - $$43 * $$43) * 0.3f + 0.5f) * $$5;
                $$15.set($$17, $$25, $$16);
                int $$45 = LevelRenderer.getLightColor($$6, $$15);
                int $$46 = $$45 >> 16 & 0xFFFF;
                int $$47 = $$45 & 0xFFFF;
                int $$48 = ($$46 * 3 + 240) / 4;
                int $$49 = ($$47 * 3 + 240) / 4;
                $$11.addVertex((float)((double)$$17 - p_109706_ - $$19 + 0.5), (float)((double)$$24 - p_109707_), (float)((double)$$16 - p_109708_ - $$20 + 0.5)).setUv(0.0f + $$39, (float)$$23 * 0.25f + $$38 + $$40).setColor(1.0f, 1.0f, 1.0f, $$44).setUv2($$49, $$48);
                $$11.addVertex((float)((double)$$17 - p_109706_ + $$19 + 0.5), (float)((double)$$24 - p_109707_), (float)((double)$$16 - p_109708_ + $$20 + 0.5)).setUv(1.0f + $$39, (float)$$23 * 0.25f + $$38 + $$40).setColor(1.0f, 1.0f, 1.0f, $$44).setUv2($$49, $$48);
                $$11.addVertex((float)((double)$$17 - p_109706_ + $$19 + 0.5), (float)((double)$$23 - p_109707_), (float)((double)$$16 - p_109708_ + $$20 + 0.5)).setUv(1.0f + $$39, (float)$$24 * 0.25f + $$38 + $$40).setColor(1.0f, 1.0f, 1.0f, $$44).setUv2($$49, $$48);
                $$11.addVertex((float)((double)$$17 - p_109706_ - $$19 + 0.5), (float)((double)$$23 - p_109707_), (float)((double)$$16 - p_109708_ - $$20 + 0.5)).setUv(0.0f + $$39, (float)$$24 * 0.25f + $$38 + $$40).setColor(1.0f, 1.0f, 1.0f, $$44).setUv2($$49, $$48);
            }
        }
        if ($$13 >= 0) {
            BufferUploader.drawWithShader($$11.buildOrThrow());
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        p_109704_.turnOffLightLayer();
    }

    public void tickRain(Camera p_109694_) {
        float $$1 = this.minecraft.level.getRainLevel(1.0f) / (Minecraft.useFancyGraphics() ? 1.0f : 2.0f);
        if ($$1 <= 0.0f) {
            return;
        }
        RandomSource $$2 = RandomSource.create((long)this.ticks * 312987231L);
        ClientLevel $$3 = this.minecraft.level;
        BlockPos $$4 = BlockPos.containing(p_109694_.getPosition());
        Vec3i $$5 = null;
        int $$6 = (int)(100.0f * $$1 * $$1) / (this.minecraft.options.particles().get() == ParticleStatus.DECREASED ? 2 : 1);
        for (int $$7 = 0; $$7 < $$6; ++$$7) {
            Biome $$11;
            int $$9;
            int $$8 = $$2.nextInt(21) - 10;
            BlockPos $$10 = $$3.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, $$4.offset($$8, 0, $$9 = $$2.nextInt(21) - 10));
            if ($$10.getY() <= $$3.getMinBuildHeight() || $$10.getY() > $$4.getY() + 10 || $$10.getY() < $$4.getY() - 10 || ($$11 = $$3.getBiome($$10).value()).getPrecipitationAt($$10) != Biome.Precipitation.RAIN) continue;
            $$5 = $$10.below();
            if (this.minecraft.options.particles().get() == ParticleStatus.MINIMAL) break;
            double $$12 = $$2.nextDouble();
            double $$13 = $$2.nextDouble();
            BlockState $$14 = $$3.getBlockState((BlockPos)$$5);
            FluidState $$15 = $$3.getFluidState((BlockPos)$$5);
            VoxelShape $$16 = $$14.getCollisionShape($$3, (BlockPos)$$5);
            double $$17 = $$16.max(Direction.Axis.Y, $$12, $$13);
            double $$18 = $$15.getHeight($$3, (BlockPos)$$5);
            double $$19 = Math.max($$17, $$18);
            SimpleParticleType $$20 = $$15.is(FluidTags.LAVA) || $$14.is(Blocks.MAGMA_BLOCK) || CampfireBlock.isLitCampfire($$14) ? ParticleTypes.SMOKE : ParticleTypes.RAIN;
            this.minecraft.level.addParticle($$20, (double)$$5.getX() + $$12, (double)$$5.getY() + $$19, (double)$$5.getZ() + $$13, 0.0, 0.0, 0.0);
        }
        if ($$5 != null && $$2.nextInt(3) < this.rainSoundTime++) {
            this.rainSoundTime = 0;
            if ($$5.getY() > $$4.getY() + 1 && $$3.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, $$4).getY() > Mth.floor($$4.getY())) {
                this.minecraft.level.playLocalSound((BlockPos)$$5, SoundEvents.WEATHER_RAIN_ABOVE, SoundSource.WEATHER, 0.1f, 0.5f, false);
            } else {
                this.minecraft.level.playLocalSound((BlockPos)$$5, SoundEvents.WEATHER_RAIN, SoundSource.WEATHER, 0.2f, 1.0f, false);
            }
        }
    }

    @Override
    public void close() {
        if (this.entityEffect != null) {
            this.entityEffect.close();
        }
        if (this.transparencyChain != null) {
            this.transparencyChain.close();
        }
    }

    @Override
    public void onResourceManagerReload(ResourceManager p_109513_) {
        this.initOutline();
        if (Minecraft.useShaderTransparency()) {
            this.initTransparency();
        }
    }

    public void initOutline() {
        if (this.entityEffect != null) {
            this.entityEffect.close();
        }
        ResourceLocation $$0 = ResourceLocation.withDefaultNamespace("shaders/post/entity_outline.json");
        try {
            this.entityEffect = new PostChain(this.minecraft.getTextureManager(), this.minecraft.getResourceManager(), this.minecraft.getMainRenderTarget(), $$0);
            this.entityEffect.resize(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
            this.entityTarget = this.entityEffect.getTempTarget("final");
        }
        catch (IOException $$1) {
            LOGGER.warn("Failed to load shader: {}", (Object)$$0, (Object)$$1);
            this.entityEffect = null;
            this.entityTarget = null;
        }
        catch (JsonSyntaxException $$2) {
            LOGGER.warn("Failed to parse shader: {}", (Object)$$0, (Object)$$2);
            this.entityEffect = null;
            this.entityTarget = null;
        }
    }

    private void initTransparency() {
        this.deinitTransparency();
        ResourceLocation $$0 = ResourceLocation.withDefaultNamespace("shaders/post/transparency.json");
        try {
            PostChain $$1 = new PostChain(this.minecraft.getTextureManager(), this.minecraft.getResourceManager(), this.minecraft.getMainRenderTarget(), $$0);
            $$1.resize(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight());
            RenderTarget $$2 = $$1.getTempTarget("translucent");
            RenderTarget $$3 = $$1.getTempTarget("itemEntity");
            RenderTarget $$4 = $$1.getTempTarget("particles");
            RenderTarget $$5 = $$1.getTempTarget("weather");
            RenderTarget $$6 = $$1.getTempTarget("clouds");
            this.transparencyChain = $$1;
            this.translucentTarget = $$2;
            this.itemEntityTarget = $$3;
            this.particlesTarget = $$4;
            this.weatherTarget = $$5;
            this.cloudsTarget = $$6;
        }
        catch (Exception $$7) {
            String $$8 = $$7 instanceof JsonSyntaxException ? "parse" : "load";
            String $$9 = "Failed to " + $$8 + " shader: " + String.valueOf($$0);
            TransparencyShaderException $$10 = new TransparencyShaderException($$9, $$7);
            if (this.minecraft.getResourcePackRepository().getSelectedIds().size() > 1) {
                Component $$11 = this.minecraft.getResourceManager().listPacks().findFirst().map(p_234256_ -> Component.literal(p_234256_.packId())).orElse(null);
                this.minecraft.options.graphicsMode().set(GraphicsStatus.FANCY);
                this.minecraft.clearResourcePacksOnError($$10, $$11, null);
            }
            this.minecraft.options.graphicsMode().set(GraphicsStatus.FANCY);
            this.minecraft.options.save();
            LOGGER.error(LogUtils.FATAL_MARKER, $$9, (Throwable)$$10);
            this.minecraft.emergencySaveAndCrash(new CrashReport($$9, $$10));
        }
    }

    private void deinitTransparency() {
        if (this.transparencyChain != null) {
            this.transparencyChain.close();
            this.translucentTarget.destroyBuffers();
            this.itemEntityTarget.destroyBuffers();
            this.particlesTarget.destroyBuffers();
            this.weatherTarget.destroyBuffers();
            this.cloudsTarget.destroyBuffers();
            this.transparencyChain = null;
            this.translucentTarget = null;
            this.itemEntityTarget = null;
            this.particlesTarget = null;
            this.weatherTarget = null;
            this.cloudsTarget = null;
        }
    }

    public void doEntityOutline() {
        if (this.shouldShowEntityOutlines()) {
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ZERO, GlStateManager.DestFactor.ONE);
            this.entityTarget.blitToScreen(this.minecraft.getWindow().getWidth(), this.minecraft.getWindow().getHeight(), false);
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        }
    }

    protected boolean shouldShowEntityOutlines() {
        return !this.minecraft.gameRenderer.isPanoramicMode() && this.entityTarget != null && this.entityEffect != null && this.minecraft.player != null;
    }

    private void createDarkSky() {
        if (this.darkBuffer != null) {
            this.darkBuffer.close();
        }
        this.darkBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.darkBuffer.bind();
        this.darkBuffer.upload(LevelRenderer.buildSkyDisc(Tesselator.getInstance(), -16.0f));
        VertexBuffer.unbind();
    }

    private void createLightSky() {
        if (this.skyBuffer != null) {
            this.skyBuffer.close();
        }
        this.skyBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.skyBuffer.bind();
        this.skyBuffer.upload(LevelRenderer.buildSkyDisc(Tesselator.getInstance(), 16.0f));
        VertexBuffer.unbind();
    }

    private static MeshData buildSkyDisc(Tesselator p_350585_, float p_234269_) {
        float $$2 = Math.signum(p_234269_) * 512.0f;
        float $$3 = 512.0f;
        BufferBuilder $$4 = p_350585_.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION);
        $$4.addVertex(0.0f, p_234269_, 0.0f);
        for (int $$5 = -180; $$5 <= 180; $$5 += 45) {
            $$4.addVertex($$2 * Mth.cos((float)$$5 * ((float)Math.PI / 180)), p_234269_, 512.0f * Mth.sin((float)$$5 * ((float)Math.PI / 180)));
        }
        return $$4.buildOrThrow();
    }

    private void createStars() {
        if (this.starBuffer != null) {
            this.starBuffer.close();
        }
        this.starBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
        this.starBuffer.bind();
        this.starBuffer.upload(this.drawStars(Tesselator.getInstance()));
        VertexBuffer.unbind();
    }

    private MeshData drawStars(Tesselator p_350542_) {
        RandomSource $$1 = RandomSource.create(10842L);
        int $$2 = 1500;
        float $$3 = 100.0f;
        BufferBuilder $$4 = p_350542_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        for (int $$5 = 0; $$5 < 1500; ++$$5) {
            float $$6 = $$1.nextFloat() * 2.0f - 1.0f;
            float $$7 = $$1.nextFloat() * 2.0f - 1.0f;
            float $$8 = $$1.nextFloat() * 2.0f - 1.0f;
            float $$9 = 0.15f + $$1.nextFloat() * 0.1f;
            float $$10 = Mth.lengthSquared($$6, $$7, $$8);
            if ($$10 <= 0.010000001f || $$10 >= 1.0f) continue;
            Vector3f $$11 = new Vector3f($$6, $$7, $$8).normalize(100.0f);
            float $$12 = (float)($$1.nextDouble() * 3.1415927410125732 * 2.0);
            Quaternionf $$13 = new Quaternionf().rotateTo((Vector3fc)new Vector3f(0.0f, 0.0f, -1.0f), (Vector3fc)$$11).rotateZ($$12);
            $$4.addVertex($$11.add((Vector3fc)new Vector3f($$9, -$$9, 0.0f).rotate((Quaternionfc)$$13)));
            $$4.addVertex($$11.add((Vector3fc)new Vector3f($$9, $$9, 0.0f).rotate((Quaternionfc)$$13)));
            $$4.addVertex($$11.add((Vector3fc)new Vector3f(-$$9, $$9, 0.0f).rotate((Quaternionfc)$$13)));
            $$4.addVertex($$11.add((Vector3fc)new Vector3f(-$$9, -$$9, 0.0f).rotate((Quaternionfc)$$13)));
        }
        return $$4.buildOrThrow();
    }

    public void setLevel(@Nullable ClientLevel p_109702_) {
        this.lastCameraSectionX = Integer.MIN_VALUE;
        this.lastCameraSectionY = Integer.MIN_VALUE;
        this.lastCameraSectionZ = Integer.MIN_VALUE;
        this.entityRenderDispatcher.setLevel(p_109702_);
        this.level = p_109702_;
        if (p_109702_ != null) {
            this.allChanged();
        } else {
            if (this.viewArea != null) {
                this.viewArea.releaseAllBuffers();
                this.viewArea = null;
            }
            if (this.sectionRenderDispatcher != null) {
                this.sectionRenderDispatcher.dispose();
            }
            this.sectionRenderDispatcher = null;
            this.globalBlockEntities.clear();
            this.sectionOcclusionGraph.waitAndReset(null);
            this.visibleSections.clear();
        }
    }

    public void graphicsChanged() {
        if (Minecraft.useShaderTransparency()) {
            this.initTransparency();
        } else {
            this.deinitTransparency();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allChanged() {
        if (this.level == null) {
            return;
        }
        this.graphicsChanged();
        this.level.clearTintCaches();
        if (this.sectionRenderDispatcher == null) {
            this.sectionRenderDispatcher = new SectionRenderDispatcher(this.level, this, Util.backgroundExecutor(), this.renderBuffers, this.minecraft.getBlockRenderer(), this.minecraft.getBlockEntityRenderDispatcher());
        } else {
            this.sectionRenderDispatcher.setLevel(this.level);
        }
        this.generateClouds = true;
        ItemBlockRenderTypes.setFancy(Minecraft.useFancyGraphics());
        this.lastViewDistance = this.minecraft.options.getEffectiveRenderDistance();
        if (this.viewArea != null) {
            this.viewArea.releaseAllBuffers();
        }
        this.sectionRenderDispatcher.blockUntilClear();
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.clear();
        }
        this.viewArea = new ViewArea(this.sectionRenderDispatcher, this.level, this.minecraft.options.getEffectiveRenderDistance(), this);
        this.sectionOcclusionGraph.waitAndReset(this.viewArea);
        this.visibleSections.clear();
        Entity $$0 = this.minecraft.getCameraEntity();
        if ($$0 != null) {
            this.viewArea.repositionCamera($$0.getX(), $$0.getZ());
        }
    }

    public void resize(int p_109488_, int p_109489_) {
        this.needsUpdate();
        if (this.entityEffect != null) {
            this.entityEffect.resize(p_109488_, p_109489_);
        }
        if (this.transparencyChain != null) {
            this.transparencyChain.resize(p_109488_, p_109489_);
        }
    }

    public String getSectionStatistics() {
        int $$0 = this.viewArea.sections.length;
        int $$1 = this.countRenderedSections();
        return String.format(Locale.ROOT, "C: %d/%d %sD: %d, %s", $$1, $$0, this.minecraft.smartCull ? "(s) " : "", this.lastViewDistance, this.sectionRenderDispatcher == null ? "null" : this.sectionRenderDispatcher.getStats());
    }

    public SectionRenderDispatcher getSectionRenderDispatcher() {
        return this.sectionRenderDispatcher;
    }

    public double getTotalSections() {
        return this.viewArea.sections.length;
    }

    public double getLastViewDistance() {
        return this.lastViewDistance;
    }

    public int countRenderedSections() {
        int $$0 = 0;
        for (SectionRenderDispatcher.RenderSection $$1 : this.visibleSections) {
            if ($$1.getCompiled().hasNoRenderableLayers()) continue;
            ++$$0;
        }
        return $$0;
    }

    public String getEntityStatistics() {
        return "E: " + this.renderedEntities + "/" + this.level.getEntityCount() + ", B: " + this.culledEntities + ", SD: " + this.level.getServerSimulationDistance();
    }

    private void setupRender(Camera p_194339_, Frustum p_194340_, boolean p_194341_, boolean p_194342_) {
        Vec3 $$4 = p_194339_.getPosition();
        if (this.minecraft.options.getEffectiveRenderDistance() != this.lastViewDistance) {
            this.allChanged();
        }
        this.level.getProfiler().push("camera");
        double $$5 = this.minecraft.player.getX();
        double $$6 = this.minecraft.player.getY();
        double $$7 = this.minecraft.player.getZ();
        int $$8 = SectionPos.posToSectionCoord($$5);
        int $$9 = SectionPos.posToSectionCoord($$6);
        int $$10 = SectionPos.posToSectionCoord($$7);
        if (this.lastCameraSectionX != $$8 || this.lastCameraSectionY != $$9 || this.lastCameraSectionZ != $$10) {
            this.lastCameraSectionX = $$8;
            this.lastCameraSectionY = $$9;
            this.lastCameraSectionZ = $$10;
            this.viewArea.repositionCamera($$5, $$7);
        }
        this.sectionRenderDispatcher.setCamera($$4);
        this.level.getProfiler().popPush("cull");
        this.minecraft.getProfiler().popPush("culling");
        BlockPos $$11 = p_194339_.getBlockPosition();
        double $$12 = Math.floor($$4.x / 8.0);
        double $$13 = Math.floor($$4.y / 8.0);
        double $$14 = Math.floor($$4.z / 8.0);
        if ($$12 != this.prevCamX || $$13 != this.prevCamY || $$14 != this.prevCamZ) {
            this.sectionOcclusionGraph.invalidate();
        }
        this.prevCamX = $$12;
        this.prevCamY = $$13;
        this.prevCamZ = $$14;
        this.minecraft.getProfiler().popPush("update");
        if (!p_194341_) {
            boolean $$15 = this.minecraft.smartCull;
            if (p_194342_ && this.level.getBlockState($$11).isSolidRender(this.level, $$11)) {
                $$15 = false;
            }
            Entity.setViewScale(Mth.clamp((double)this.minecraft.options.getEffectiveRenderDistance() / 8.0, 1.0, 2.5) * this.minecraft.options.entityDistanceScaling().get());
            this.minecraft.getProfiler().push("section_occlusion_graph");
            this.sectionOcclusionGraph.update($$15, p_194339_, p_194340_, (List<SectionRenderDispatcher.RenderSection>)this.visibleSections);
            this.minecraft.getProfiler().pop();
            double $$16 = Math.floor(p_194339_.getXRot() / 2.0f);
            double $$17 = Math.floor(p_194339_.getYRot() / 2.0f);
            if (this.sectionOcclusionGraph.consumeFrustumUpdate() || $$16 != this.prevCamRotX || $$17 != this.prevCamRotY) {
                this.applyFrustum(LevelRenderer.offsetFrustum(p_194340_));
                this.prevCamRotX = $$16;
                this.prevCamRotY = $$17;
            }
        }
        this.minecraft.getProfiler().pop();
    }

    public static Frustum offsetFrustum(Frustum p_296151_) {
        return new Frustum(p_296151_).offsetToFullyIncludeCameraCube(8);
    }

    private void applyFrustum(Frustum p_194355_) {
        if (!Minecraft.getInstance().isSameThread()) {
            throw new IllegalStateException("applyFrustum called from wrong thread: " + Thread.currentThread().getName());
        }
        this.minecraft.getProfiler().push("apply_frustum");
        this.visibleSections.clear();
        this.sectionOcclusionGraph.addSectionsInFrustum(p_194355_, (List<SectionRenderDispatcher.RenderSection>)this.visibleSections);
        this.minecraft.getProfiler().pop();
    }

    public void addRecentlyCompiledSection(SectionRenderDispatcher.RenderSection p_295462_) {
        this.sectionOcclusionGraph.onSectionCompiled(p_295462_);
    }

    private void captureFrustum(Matrix4f p_253756_, Matrix4f p_253787_, double p_254187_, double p_253833_, double p_254547_, Frustum p_253954_) {
        this.capturedFrustum = p_253954_;
        Matrix4f $$6 = new Matrix4f((Matrix4fc)p_253787_);
        $$6.mul((Matrix4fc)p_253756_);
        $$6.invert();
        this.frustumPos.x = p_254187_;
        this.frustumPos.y = p_253833_;
        this.frustumPos.z = p_254547_;
        this.frustumPoints[0] = new Vector4f(-1.0f, -1.0f, -1.0f, 1.0f);
        this.frustumPoints[1] = new Vector4f(1.0f, -1.0f, -1.0f, 1.0f);
        this.frustumPoints[2] = new Vector4f(1.0f, 1.0f, -1.0f, 1.0f);
        this.frustumPoints[3] = new Vector4f(-1.0f, 1.0f, -1.0f, 1.0f);
        this.frustumPoints[4] = new Vector4f(-1.0f, -1.0f, 1.0f, 1.0f);
        this.frustumPoints[5] = new Vector4f(1.0f, -1.0f, 1.0f, 1.0f);
        this.frustumPoints[6] = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
        this.frustumPoints[7] = new Vector4f(-1.0f, 1.0f, 1.0f, 1.0f);
        for (int $$7 = 0; $$7 < 8; ++$$7) {
            $$6.transform(this.frustumPoints[$$7]);
            this.frustumPoints[$$7].div(this.frustumPoints[$$7].w());
        }
    }

    public void prepareCullFrustum(Vec3 p_253766_, Matrix4f p_254341_, Matrix4f p_323487_) {
        this.cullingFrustum = new Frustum(p_254341_, p_323487_);
        this.cullingFrustum.prepare(p_253766_.x(), p_253766_.y(), p_253766_.z());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderLevel(DeltaTracker p_348530_, boolean p_109603_, Camera p_109604_, GameRenderer p_109605_, LightTexture p_109606_, Matrix4f p_254120_, Matrix4f p_323920_) {
        Frustum $$16;
        boolean $$14;
        TickRateManager $$7 = this.minecraft.level.tickRateManager();
        float $$8 = p_348530_.getGameTimeDeltaPartialTick(false);
        RenderSystem.setShaderGameTime(this.level.getGameTime(), $$8);
        this.blockEntityRenderDispatcher.prepare(this.level, p_109604_, this.minecraft.hitResult);
        this.entityRenderDispatcher.prepare(this.level, p_109604_, this.minecraft.crosshairPickEntity);
        ProfilerFiller $$9 = this.level.getProfiler();
        $$9.popPush("light_update_queue");
        this.level.pollLightUpdates();
        $$9.popPush("light_updates");
        this.level.getChunkSource().getLightEngine().runLightUpdates();
        Vec3 $$10 = p_109604_.getPosition();
        double $$11 = $$10.x();
        double $$12 = $$10.y();
        double $$13 = $$10.z();
        $$9.popPush("culling");
        boolean bl = $$14 = this.capturedFrustum != null;
        if ($$14) {
            Frustum $$15 = this.capturedFrustum;
            $$15.prepare(this.frustumPos.x, this.frustumPos.y, this.frustumPos.z);
        } else {
            $$16 = this.cullingFrustum;
        }
        this.minecraft.getProfiler().popPush("captureFrustum");
        if (this.captureFrustum) {
            this.captureFrustum(p_254120_, p_323920_, $$10.x, $$10.y, $$10.z, $$14 ? new Frustum(p_254120_, p_323920_) : $$16);
            this.captureFrustum = false;
        }
        $$9.popPush("clear");
        FogRenderer.setupColor(p_109604_, $$8, this.minecraft.level, this.minecraft.options.getEffectiveRenderDistance(), p_109605_.getDarkenWorldAmount($$8));
        FogRenderer.levelFogColor();
        RenderSystem.clear(16640, Minecraft.ON_OSX);
        float $$17 = p_109605_.getRenderDistance();
        boolean $$18 = this.minecraft.level.effects().isFoggyAt(Mth.floor($$11), Mth.floor($$12)) || this.minecraft.gui.getBossOverlay().shouldCreateWorldFog();
        $$9.popPush("sky");
        RenderSystem.setShader(GameRenderer::getPositionShader);
        this.renderSky(p_254120_, p_323920_, $$8, p_109604_, $$18, () -> FogRenderer.setupFog(p_109604_, FogRenderer.FogMode.FOG_SKY, $$17, $$18, $$8));
        $$9.popPush("fog");
        FogRenderer.setupFog(p_109604_, FogRenderer.FogMode.FOG_TERRAIN, Math.max($$17, 32.0f), $$18, $$8);
        $$9.popPush("terrain_setup");
        this.setupRender(p_109604_, $$16, $$14, this.minecraft.player.isSpectator());
        $$9.popPush("compile_sections");
        this.compileSections(p_109604_);
        $$9.popPush("terrain");
        this.renderSectionLayer(RenderType.solid(), $$11, $$12, $$13, p_254120_, p_323920_);
        this.renderSectionLayer(RenderType.cutoutMipped(), $$11, $$12, $$13, p_254120_, p_323920_);
        this.renderSectionLayer(RenderType.cutout(), $$11, $$12, $$13, p_254120_, p_323920_);
        if (this.level.effects().constantAmbientLight()) {
            Lighting.setupNetherLevel();
        } else {
            Lighting.setupLevel();
        }
        $$9.popPush("entities");
        this.renderedEntities = 0;
        this.culledEntities = 0;
        if (this.itemEntityTarget != null) {
            this.itemEntityTarget.clear(Minecraft.ON_OSX);
            this.itemEntityTarget.copyDepthFrom(this.minecraft.getMainRenderTarget());
            this.minecraft.getMainRenderTarget().bindWrite(false);
        }
        if (this.weatherTarget != null) {
            this.weatherTarget.clear(Minecraft.ON_OSX);
        }
        if (this.shouldShowEntityOutlines()) {
            this.entityTarget.clear(Minecraft.ON_OSX);
            this.minecraft.getMainRenderTarget().bindWrite(false);
        }
        Matrix4fStack $$19 = RenderSystem.getModelViewStack();
        $$19.pushMatrix();
        $$19.mul((Matrix4fc)p_254120_);
        RenderSystem.applyModelViewMatrix();
        boolean $$20 = false;
        PoseStack $$21 = new PoseStack();
        MultiBufferSource.BufferSource $$22 = this.renderBuffers.bufferSource();
        for (Entity $$23 : this.level.entitiesForRendering()) {
            MultiBufferSource.BufferSource $$28;
            BlockPos $$24;
            if (!this.entityRenderDispatcher.shouldRender($$23, $$16, $$11, $$12, $$13) && !$$23.hasIndirectPassenger(this.minecraft.player) || !this.level.isOutsideBuildHeight(($$24 = $$23.blockPosition()).getY()) && !this.isSectionCompiled($$24) || $$23 == p_109604_.getEntity() && !p_109604_.isDetached() && (!(p_109604_.getEntity() instanceof LivingEntity) || !((LivingEntity)p_109604_.getEntity()).isSleeping()) || $$23 instanceof LocalPlayer && p_109604_.getEntity() != $$23) continue;
            ++this.renderedEntities;
            if ($$23.tickCount == 0) {
                $$23.xOld = $$23.getX();
                $$23.yOld = $$23.getY();
                $$23.zOld = $$23.getZ();
            }
            if (this.shouldShowEntityOutlines() && this.minecraft.shouldEntityAppearGlowing($$23)) {
                OutlineBufferSource $$25;
                $$20 = true;
                OutlineBufferSource $$26 = $$25 = this.renderBuffers.outlineBufferSource();
                int $$27 = $$23.getTeamColor();
                $$25.setColor(FastColor.ARGB32.red($$27), FastColor.ARGB32.green($$27), FastColor.ARGB32.blue($$27), 255);
            } else {
                $$28 = $$22;
            }
            float $$29 = p_348530_.getGameTimeDeltaPartialTick(!$$7.isEntityFrozen($$23));
            this.renderEntity($$23, $$11, $$12, $$13, $$29, $$21, $$28);
        }
        $$22.endLastBatch();
        this.checkPoseStack($$21);
        $$22.endBatch(RenderType.entitySolid(TextureAtlas.LOCATION_BLOCKS));
        $$22.endBatch(RenderType.entityCutout(TextureAtlas.LOCATION_BLOCKS));
        $$22.endBatch(RenderType.entityCutoutNoCull(TextureAtlas.LOCATION_BLOCKS));
        $$22.endBatch(RenderType.entitySmoothCutout(TextureAtlas.LOCATION_BLOCKS));
        $$9.popPush("blockentities");
        for (Object $$30 : this.visibleSections) {
            List<BlockEntity> $$31 = ((SectionRenderDispatcher.RenderSection)$$30).getCompiled().getRenderableBlockEntities();
            if ($$31.isEmpty()) continue;
            for (BlockEntity $$32 : $$31) {
                int $$36;
                BlockPos $$33 = $$32.getBlockPos();
                MultiBufferSource $$34 = $$22;
                $$21.pushPose();
                $$21.translate((double)$$33.getX() - $$11, (double)$$33.getY() - $$12, (double)$$33.getZ() - $$13);
                SortedSet $$35 = (SortedSet)this.destructionProgress.get($$33.asLong());
                if ($$35 != null && !$$35.isEmpty() && ($$36 = ((BlockDestructionProgress)$$35.last()).getProgress()) >= 0) {
                    PoseStack.Pose $$37 = $$21.last();
                    SheetedDecalTextureGenerator $$38 = new SheetedDecalTextureGenerator(this.renderBuffers.crumblingBufferSource().getBuffer(ModelBakery.DESTROY_TYPES.get($$36)), $$37, 1.0f);
                    $$34 = p_234298_ -> {
                        VertexConsumer $$3 = $$22.getBuffer(p_234298_);
                        if (p_234298_.affectsCrumbling()) {
                            return VertexMultiConsumer.create($$38, $$3);
                        }
                        return $$3;
                    };
                }
                this.blockEntityRenderDispatcher.render($$32, $$8, $$21, $$34);
                $$21.popPose();
            }
        }
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            for (BlockEntity $$39 : this.globalBlockEntities) {
                BlockPos $$40 = $$39.getBlockPos();
                $$21.pushPose();
                $$21.translate((double)$$40.getX() - $$11, (double)$$40.getY() - $$12, (double)$$40.getZ() - $$13);
                this.blockEntityRenderDispatcher.render($$39, $$8, $$21, $$22);
                $$21.popPose();
            }
        }
        this.checkPoseStack($$21);
        $$22.endBatch(RenderType.solid());
        $$22.endBatch(RenderType.endPortal());
        $$22.endBatch(RenderType.endGateway());
        $$22.endBatch(Sheets.solidBlockSheet());
        $$22.endBatch(Sheets.cutoutBlockSheet());
        $$22.endBatch(Sheets.bedSheet());
        $$22.endBatch(Sheets.shulkerBoxSheet());
        $$22.endBatch(Sheets.signSheet());
        $$22.endBatch(Sheets.hangingSignSheet());
        $$22.endBatch(Sheets.chestSheet());
        this.renderBuffers.outlineBufferSource().endOutlineBatch();
        if ($$20) {
            this.entityEffect.process(p_348530_.getGameTimeDeltaTicks());
            this.minecraft.getMainRenderTarget().bindWrite(false);
        }
        $$9.popPush("destroyProgress");
        for (Long2ObjectMap.Entry $$41 : this.destructionProgress.long2ObjectEntrySet()) {
            SortedSet $$46;
            double $$45;
            double $$44;
            BlockPos $$42 = BlockPos.of($$41.getLongKey());
            double $$43 = (double)$$42.getX() - $$11;
            if ($$43 * $$43 + ($$44 = (double)$$42.getY() - $$12) * $$44 + ($$45 = (double)$$42.getZ() - $$13) * $$45 > 1024.0 || ($$46 = (SortedSet)$$41.getValue()) == null || $$46.isEmpty()) continue;
            int $$47 = ((BlockDestructionProgress)$$46.last()).getProgress();
            $$21.pushPose();
            $$21.translate((double)$$42.getX() - $$11, (double)$$42.getY() - $$12, (double)$$42.getZ() - $$13);
            PoseStack.Pose $$48 = $$21.last();
            SheetedDecalTextureGenerator $$49 = new SheetedDecalTextureGenerator(this.renderBuffers.crumblingBufferSource().getBuffer(ModelBakery.DESTROY_TYPES.get($$47)), $$48, 1.0f);
            this.minecraft.getBlockRenderer().renderBreakingTexture(this.level.getBlockState($$42), $$42, this.level, $$21, $$49);
            $$21.popPose();
        }
        this.checkPoseStack($$21);
        HitResult $$50 = this.minecraft.hitResult;
        if (p_109603_ && $$50 != null && $$50.getType() == HitResult.Type.BLOCK) {
            $$9.popPush("outline");
            BlockPos $$51 = ((BlockHitResult)$$50).getBlockPos();
            BlockState $$52 = this.level.getBlockState($$51);
            if (!$$52.isAir() && this.level.getWorldBorder().isWithinBounds($$51)) {
                VertexConsumer $$53 = $$22.getBuffer(RenderType.lines());
                this.renderHitOutline($$21, $$53, p_109604_.getEntity(), $$11, $$12, $$13, $$51, $$52);
            }
        }
        this.minecraft.debugRenderer.render($$21, $$22, $$11, $$12, $$13);
        $$22.endLastBatch();
        $$22.endBatch(Sheets.translucentCullBlockSheet());
        $$22.endBatch(Sheets.bannerSheet());
        $$22.endBatch(Sheets.shieldSheet());
        $$22.endBatch(RenderType.armorEntityGlint());
        $$22.endBatch(RenderType.glint());
        $$22.endBatch(RenderType.glintTranslucent());
        $$22.endBatch(RenderType.entityGlint());
        $$22.endBatch(RenderType.entityGlintDirect());
        $$22.endBatch(RenderType.waterMask());
        this.renderBuffers.crumblingBufferSource().endBatch();
        if (this.transparencyChain != null) {
            $$22.endBatch(RenderType.lines());
            $$22.endBatch();
            this.translucentTarget.clear(Minecraft.ON_OSX);
            this.translucentTarget.copyDepthFrom(this.minecraft.getMainRenderTarget());
            $$9.popPush("translucent");
            this.renderSectionLayer(RenderType.translucent(), $$11, $$12, $$13, p_254120_, p_323920_);
            $$9.popPush("string");
            this.renderSectionLayer(RenderType.tripwire(), $$11, $$12, $$13, p_254120_, p_323920_);
            this.particlesTarget.clear(Minecraft.ON_OSX);
            this.particlesTarget.copyDepthFrom(this.minecraft.getMainRenderTarget());
            RenderStateShard.PARTICLES_TARGET.setupRenderState();
            $$9.popPush("particles");
            this.minecraft.particleEngine.render(p_109606_, p_109604_, $$8);
            RenderStateShard.PARTICLES_TARGET.clearRenderState();
        } else {
            $$9.popPush("translucent");
            if (this.translucentTarget != null) {
                this.translucentTarget.clear(Minecraft.ON_OSX);
            }
            this.renderSectionLayer(RenderType.translucent(), $$11, $$12, $$13, p_254120_, p_323920_);
            $$22.endBatch(RenderType.lines());
            $$22.endBatch();
            $$9.popPush("string");
            this.renderSectionLayer(RenderType.tripwire(), $$11, $$12, $$13, p_254120_, p_323920_);
            $$9.popPush("particles");
            this.minecraft.particleEngine.render(p_109606_, p_109604_, $$8);
        }
        if (this.minecraft.options.getCloudsType() != CloudStatus.OFF) {
            if (this.transparencyChain != null) {
                this.cloudsTarget.clear(Minecraft.ON_OSX);
            }
            $$9.popPush("clouds");
            this.renderClouds($$21, p_254120_, p_323920_, $$8, $$11, $$12, $$13);
        }
        if (this.transparencyChain != null) {
            RenderStateShard.WEATHER_TARGET.setupRenderState();
            $$9.popPush("weather");
            this.renderSnowAndRain(p_109606_, $$8, $$11, $$12, $$13);
            this.renderWorldBorder(p_109604_);
            RenderStateShard.WEATHER_TARGET.clearRenderState();
            this.transparencyChain.process(p_348530_.getGameTimeDeltaTicks());
            this.minecraft.getMainRenderTarget().bindWrite(false);
        } else {
            RenderSystem.depthMask(false);
            $$9.popPush("weather");
            this.renderSnowAndRain(p_109606_, $$8, $$11, $$12, $$13);
            this.renderWorldBorder(p_109604_);
            RenderSystem.depthMask(true);
        }
        this.renderDebug($$21, $$22, p_109604_);
        $$22.endLastBatch();
        $$19.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.depthMask(true);
        RenderSystem.disableBlend();
        FogRenderer.setupNoFog();
    }

    private void checkPoseStack(PoseStack p_109589_) {
        if (!p_109589_.clear()) {
            throw new IllegalStateException("Pose stack not empty");
        }
    }

    private void renderEntity(Entity p_109518_, double p_109519_, double p_109520_, double p_109521_, float p_109522_, PoseStack p_109523_, MultiBufferSource p_109524_) {
        double $$7 = Mth.lerp((double)p_109522_, p_109518_.xOld, p_109518_.getX());
        double $$8 = Mth.lerp((double)p_109522_, p_109518_.yOld, p_109518_.getY());
        double $$9 = Mth.lerp((double)p_109522_, p_109518_.zOld, p_109518_.getZ());
        float $$10 = Mth.lerp(p_109522_, p_109518_.yRotO, p_109518_.getYRot());
        this.entityRenderDispatcher.render(p_109518_, $$7 - p_109519_, $$8 - p_109520_, $$9 - p_109521_, $$10, p_109522_, p_109523_, p_109524_, this.entityRenderDispatcher.getPackedLightCoords(p_109518_, p_109522_));
    }

    private void renderSectionLayer(RenderType p_294513_, double p_295577_, double p_294761_, double p_294297_, Matrix4f p_294782_, Matrix4f p_324517_) {
        RenderSystem.assertOnRenderThread();
        p_294513_.setupRenderState();
        if (p_294513_ == RenderType.translucent()) {
            this.minecraft.getProfiler().push("translucent_sort");
            double $$6 = p_295577_ - this.xTransparentOld;
            double $$7 = p_294761_ - this.yTransparentOld;
            double $$8 = p_294297_ - this.zTransparentOld;
            if ($$6 * $$6 + $$7 * $$7 + $$8 * $$8 > 1.0) {
                int $$9 = SectionPos.posToSectionCoord(p_295577_);
                int $$10 = SectionPos.posToSectionCoord(p_294761_);
                int $$11 = SectionPos.posToSectionCoord(p_294297_);
                boolean $$12 = $$9 != SectionPos.posToSectionCoord(this.xTransparentOld) || $$11 != SectionPos.posToSectionCoord(this.zTransparentOld) || $$10 != SectionPos.posToSectionCoord(this.yTransparentOld);
                this.xTransparentOld = p_295577_;
                this.yTransparentOld = p_294761_;
                this.zTransparentOld = p_294297_;
                int $$13 = 0;
                for (SectionRenderDispatcher.RenderSection $$14 : this.visibleSections) {
                    if ($$13 >= 15 || !$$12 && !$$14.isAxisAlignedWith($$9, $$10, $$11) || !$$14.resortTransparency(p_294513_, this.sectionRenderDispatcher)) continue;
                    ++$$13;
                }
            }
            this.minecraft.getProfiler().pop();
        }
        this.minecraft.getProfiler().push("filterempty");
        this.minecraft.getProfiler().popPush(() -> "render_" + String.valueOf(p_294513_));
        boolean $$15 = p_294513_ != RenderType.translucent();
        ObjectListIterator $$16 = this.visibleSections.listIterator($$15 ? 0 : this.visibleSections.size());
        ShaderInstance $$17 = RenderSystem.getShader();
        $$17.setDefaultUniforms(VertexFormat.Mode.QUADS, p_294782_, p_324517_, this.minecraft.getWindow());
        $$17.apply();
        Uniform $$18 = $$17.CHUNK_OFFSET;
        while ($$15 ? $$16.hasNext() : $$16.hasPrevious()) {
            SectionRenderDispatcher.RenderSection $$19;
            SectionRenderDispatcher.RenderSection renderSection = $$19 = $$15 ? (SectionRenderDispatcher.RenderSection)$$16.next() : (SectionRenderDispatcher.RenderSection)$$16.previous();
            if ($$19.getCompiled().isEmpty(p_294513_)) continue;
            VertexBuffer $$20 = $$19.getBuffer(p_294513_);
            BlockPos $$21 = $$19.getOrigin();
            if ($$18 != null) {
                $$18.set((float)((double)$$21.getX() - p_295577_), (float)((double)$$21.getY() - p_294761_), (float)((double)$$21.getZ() - p_294297_));
                $$18.upload();
            }
            $$20.bind();
            $$20.draw();
        }
        if ($$18 != null) {
            $$18.set(0.0f, 0.0f, 0.0f);
        }
        $$17.clear();
        VertexBuffer.unbind();
        this.minecraft.getProfiler().pop();
        p_294513_.clearRenderState();
    }

    private void renderDebug(PoseStack p_271014_, MultiBufferSource p_270107_, Camera p_270483_) {
        if (this.minecraft.sectionPath || this.minecraft.sectionVisibility) {
            double $$3 = p_270483_.getPosition().x();
            double $$4 = p_270483_.getPosition().y();
            double $$5 = p_270483_.getPosition().z();
            for (SectionRenderDispatcher.RenderSection $$6 : this.visibleSections) {
                SectionOcclusionGraph.Node $$7 = this.sectionOcclusionGraph.getNode($$6);
                if ($$7 == null) continue;
                BlockPos $$8 = $$6.getOrigin();
                p_271014_.pushPose();
                p_271014_.translate((double)$$8.getX() - $$3, (double)$$8.getY() - $$4, (double)$$8.getZ() - $$5);
                Matrix4f $$9 = p_271014_.last().pose();
                if (this.minecraft.sectionPath) {
                    VertexConsumer $$10 = p_270107_.getBuffer(RenderType.lines());
                    int $$11 = $$7.step == 0 ? 0 : Mth.hsvToRgb((float)$$7.step / 50.0f, 0.9f, 0.9f);
                    int $$12 = $$11 >> 16 & 0xFF;
                    int $$13 = $$11 >> 8 & 0xFF;
                    int $$14 = $$11 & 0xFF;
                    for (int $$15 = 0; $$15 < DIRECTIONS.length; ++$$15) {
                        if (!$$7.hasSourceDirection($$15)) continue;
                        Direction $$16 = DIRECTIONS[$$15];
                        $$10.addVertex($$9, 8.0f, 8.0f, 8.0f).setColor($$12, $$13, $$14, 255).setNormal($$16.getStepX(), $$16.getStepY(), $$16.getStepZ());
                        $$10.addVertex($$9, (float)(8 - 16 * $$16.getStepX()), (float)(8 - 16 * $$16.getStepY()), (float)(8 - 16 * $$16.getStepZ())).setColor($$12, $$13, $$14, 255).setNormal($$16.getStepX(), $$16.getStepY(), $$16.getStepZ());
                    }
                }
                if (this.minecraft.sectionVisibility && !$$6.getCompiled().hasNoRenderableLayers()) {
                    VertexConsumer $$17 = p_270107_.getBuffer(RenderType.lines());
                    int $$18 = 0;
                    for (Direction $$19 : DIRECTIONS) {
                        for (Direction $$20 : DIRECTIONS) {
                            boolean $$21 = $$6.getCompiled().facesCanSeeEachother($$19, $$20);
                            if ($$21) continue;
                            ++$$18;
                            $$17.addVertex($$9, (float)(8 + 8 * $$19.getStepX()), (float)(8 + 8 * $$19.getStepY()), (float)(8 + 8 * $$19.getStepZ())).setColor(255, 0, 0, 255).setNormal($$19.getStepX(), $$19.getStepY(), $$19.getStepZ());
                            $$17.addVertex($$9, (float)(8 + 8 * $$20.getStepX()), (float)(8 + 8 * $$20.getStepY()), (float)(8 + 8 * $$20.getStepZ())).setColor(255, 0, 0, 255).setNormal($$20.getStepX(), $$20.getStepY(), $$20.getStepZ());
                        }
                    }
                    if ($$18 > 0) {
                        VertexConsumer $$22 = p_270107_.getBuffer(RenderType.debugQuads());
                        float $$23 = 0.5f;
                        float $$24 = 0.2f;
                        $$22.addVertex($$9, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 15.5f, 0.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 15.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 15.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                        $$22.addVertex($$9, 0.5f, 0.5f, 15.5f).setColor(0.9f, 0.9f, 0.0f, 0.2f);
                    }
                }
                p_271014_.popPose();
            }
        }
        if (this.capturedFrustum != null) {
            p_271014_.pushPose();
            p_271014_.translate((float)(this.frustumPos.x - p_270483_.getPosition().x), (float)(this.frustumPos.y - p_270483_.getPosition().y), (float)(this.frustumPos.z - p_270483_.getPosition().z));
            Matrix4f $$25 = p_271014_.last().pose();
            VertexConsumer $$26 = p_270107_.getBuffer(RenderType.debugQuads());
            this.addFrustumQuad($$26, $$25, 0, 1, 2, 3, 0, 1, 1);
            this.addFrustumQuad($$26, $$25, 4, 5, 6, 7, 1, 0, 0);
            this.addFrustumQuad($$26, $$25, 0, 1, 5, 4, 1, 1, 0);
            this.addFrustumQuad($$26, $$25, 2, 3, 7, 6, 0, 0, 1);
            this.addFrustumQuad($$26, $$25, 0, 4, 7, 3, 0, 1, 0);
            this.addFrustumQuad($$26, $$25, 1, 5, 6, 2, 1, 0, 1);
            VertexConsumer $$27 = p_270107_.getBuffer(RenderType.lines());
            this.addFrustumVertex($$27, $$25, 0);
            this.addFrustumVertex($$27, $$25, 1);
            this.addFrustumVertex($$27, $$25, 1);
            this.addFrustumVertex($$27, $$25, 2);
            this.addFrustumVertex($$27, $$25, 2);
            this.addFrustumVertex($$27, $$25, 3);
            this.addFrustumVertex($$27, $$25, 3);
            this.addFrustumVertex($$27, $$25, 0);
            this.addFrustumVertex($$27, $$25, 4);
            this.addFrustumVertex($$27, $$25, 5);
            this.addFrustumVertex($$27, $$25, 5);
            this.addFrustumVertex($$27, $$25, 6);
            this.addFrustumVertex($$27, $$25, 6);
            this.addFrustumVertex($$27, $$25, 7);
            this.addFrustumVertex($$27, $$25, 7);
            this.addFrustumVertex($$27, $$25, 4);
            this.addFrustumVertex($$27, $$25, 0);
            this.addFrustumVertex($$27, $$25, 4);
            this.addFrustumVertex($$27, $$25, 1);
            this.addFrustumVertex($$27, $$25, 5);
            this.addFrustumVertex($$27, $$25, 2);
            this.addFrustumVertex($$27, $$25, 6);
            this.addFrustumVertex($$27, $$25, 3);
            this.addFrustumVertex($$27, $$25, 7);
            p_271014_.popPose();
        }
    }

    private void addFrustumVertex(VertexConsumer p_270950_, Matrix4f p_270118_, int p_270865_) {
        p_270950_.addVertex(p_270118_, this.frustumPoints[p_270865_].x(), this.frustumPoints[p_270865_].y(), this.frustumPoints[p_270865_].z()).setColor(-16777216).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void addFrustumQuad(VertexConsumer p_270858_, Matrix4f p_270341_, int p_270702_, int p_270959_, int p_270732_, int p_270363_, int p_270273_, int p_270934_, int p_270916_) {
        float $$9 = 0.25f;
        p_270858_.addVertex(p_270341_, this.frustumPoints[p_270702_].x(), this.frustumPoints[p_270702_].y(), this.frustumPoints[p_270702_].z()).setColor((float)p_270273_, (float)p_270934_, (float)p_270916_, 0.25f);
        p_270858_.addVertex(p_270341_, this.frustumPoints[p_270959_].x(), this.frustumPoints[p_270959_].y(), this.frustumPoints[p_270959_].z()).setColor((float)p_270273_, (float)p_270934_, (float)p_270916_, 0.25f);
        p_270858_.addVertex(p_270341_, this.frustumPoints[p_270732_].x(), this.frustumPoints[p_270732_].y(), this.frustumPoints[p_270732_].z()).setColor((float)p_270273_, (float)p_270934_, (float)p_270916_, 0.25f);
        p_270858_.addVertex(p_270341_, this.frustumPoints[p_270363_].x(), this.frustumPoints[p_270363_].y(), this.frustumPoints[p_270363_].z()).setColor((float)p_270273_, (float)p_270934_, (float)p_270916_, 0.25f);
    }

    public void captureFrustum() {
        this.captureFrustum = true;
    }

    public void killFrustum() {
        this.capturedFrustum = null;
    }

    public void tick() {
        if (this.level.tickRateManager().runsNormally()) {
            ++this.ticks;
        }
        if (this.ticks % 20 != 0) {
            return;
        }
        ObjectIterator $$0 = this.destroyingBlocks.values().iterator();
        while ($$0.hasNext()) {
            BlockDestructionProgress $$1 = (BlockDestructionProgress)$$0.next();
            int $$2 = $$1.getUpdatedRenderTick();
            if (this.ticks - $$2 <= 400) continue;
            $$0.remove();
            this.removeProgress($$1);
        }
    }

    private void removeProgress(BlockDestructionProgress p_109766_) {
        long $$1 = p_109766_.getPos().asLong();
        Set $$2 = (Set)this.destructionProgress.get($$1);
        $$2.remove(p_109766_);
        if ($$2.isEmpty()) {
            this.destructionProgress.remove($$1);
        }
    }

    private void renderEndSky(PoseStack p_109781_) {
        RenderSystem.enableBlend();
        RenderSystem.depthMask(false);
        RenderSystem.setShader(GameRenderer::getPositionTexColorShader);
        RenderSystem.setShaderTexture(0, END_SKY_LOCATION);
        Tesselator $$1 = Tesselator.getInstance();
        for (int $$2 = 0; $$2 < 6; ++$$2) {
            p_109781_.pushPose();
            if ($$2 == 1) {
                p_109781_.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            if ($$2 == 2) {
                p_109781_.mulPose(Axis.XP.rotationDegrees(-90.0f));
            }
            if ($$2 == 3) {
                p_109781_.mulPose(Axis.XP.rotationDegrees(180.0f));
            }
            if ($$2 == 4) {
                p_109781_.mulPose(Axis.ZP.rotationDegrees(90.0f));
            }
            if ($$2 == 5) {
                p_109781_.mulPose(Axis.ZP.rotationDegrees(-90.0f));
            }
            Matrix4f $$3 = p_109781_.last().pose();
            BufferBuilder $$4 = $$1.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR);
            $$4.addVertex($$3, -100.0f, -100.0f, -100.0f).setUv(0.0f, 0.0f).setColor(-14145496);
            $$4.addVertex($$3, -100.0f, -100.0f, 100.0f).setUv(0.0f, 16.0f).setColor(-14145496);
            $$4.addVertex($$3, 100.0f, -100.0f, 100.0f).setUv(16.0f, 16.0f).setColor(-14145496);
            $$4.addVertex($$3, 100.0f, -100.0f, -100.0f).setUv(16.0f, 0.0f).setColor(-14145496);
            BufferUploader.drawWithShader($$4.buildOrThrow());
            p_109781_.popPose();
        }
        RenderSystem.depthMask(true);
        RenderSystem.disableBlend();
    }

    public void renderSky(Matrix4f p_254034_, Matrix4f p_324386_, float p_202426_, Camera p_202427_, boolean p_202428_, Runnable p_202429_) {
        p_202429_.run();
        if (p_202428_) {
            return;
        }
        FogType $$6 = p_202427_.getFluidInCamera();
        if ($$6 == FogType.POWDER_SNOW || $$6 == FogType.LAVA || this.doesMobEffectBlockSky(p_202427_)) {
            return;
        }
        PoseStack $$7 = new PoseStack();
        $$7.mulPose(p_254034_);
        if (this.minecraft.level.effects().skyType() == DimensionSpecialEffects.SkyType.END) {
            this.renderEndSky($$7);
            return;
        }
        if (this.minecraft.level.effects().skyType() != DimensionSpecialEffects.SkyType.NORMAL) {
            return;
        }
        Vec3 $$8 = this.level.getSkyColor(this.minecraft.gameRenderer.getMainCamera().getPosition(), p_202426_);
        float $$9 = (float)$$8.x;
        float $$10 = (float)$$8.y;
        float $$11 = (float)$$8.z;
        FogRenderer.levelFogColor();
        Tesselator $$12 = Tesselator.getInstance();
        RenderSystem.depthMask(false);
        RenderSystem.setShaderColor($$9, $$10, $$11, 1.0f);
        ShaderInstance $$13 = RenderSystem.getShader();
        this.skyBuffer.bind();
        this.skyBuffer.drawWithShader($$7.last().pose(), p_324386_, $$13);
        VertexBuffer.unbind();
        RenderSystem.enableBlend();
        float[] $$14 = this.level.effects().getSunriseColor(this.level.getTimeOfDay(p_202426_), p_202426_);
        if ($$14 != null) {
            RenderSystem.setShader(GameRenderer::getPositionColorShader);
            RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
            $$7.pushPose();
            $$7.mulPose(Axis.XP.rotationDegrees(90.0f));
            float $$15 = Mth.sin(this.level.getSunAngle(p_202426_)) < 0.0f ? 180.0f : 0.0f;
            $$7.mulPose(Axis.ZP.rotationDegrees($$15));
            $$7.mulPose(Axis.ZP.rotationDegrees(90.0f));
            float $$16 = $$14[0];
            float $$17 = $$14[1];
            float $$18 = $$14[2];
            Matrix4f $$19 = $$7.last().pose();
            BufferBuilder $$20 = $$12.begin(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.POSITION_COLOR);
            $$20.addVertex($$19, 0.0f, 100.0f, 0.0f).setColor($$16, $$17, $$18, $$14[3]);
            int $$21 = 16;
            for (int $$22 = 0; $$22 <= 16; ++$$22) {
                float $$23 = (float)$$22 * ((float)Math.PI * 2) / 16.0f;
                float $$24 = Mth.sin($$23);
                float $$25 = Mth.cos($$23);
                $$20.addVertex($$19, $$24 * 120.0f, $$25 * 120.0f, -$$25 * 40.0f * $$14[3]).setColor($$14[0], $$14[1], $$14[2], 0.0f);
            }
            BufferUploader.drawWithShader($$20.buildOrThrow());
            $$7.popPose();
        }
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        $$7.pushPose();
        float $$26 = 1.0f - this.level.getRainLevel(p_202426_);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, $$26);
        $$7.mulPose(Axis.YP.rotationDegrees(-90.0f));
        $$7.mulPose(Axis.XP.rotationDegrees(this.level.getTimeOfDay(p_202426_) * 360.0f));
        Matrix4f $$27 = $$7.last().pose();
        float $$28 = 30.0f;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture(0, SUN_LOCATION);
        BufferBuilder $$29 = $$12.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        $$29.addVertex($$27, -$$28, 100.0f, -$$28).setUv(0.0f, 0.0f);
        $$29.addVertex($$27, $$28, 100.0f, -$$28).setUv(1.0f, 0.0f);
        $$29.addVertex($$27, $$28, 100.0f, $$28).setUv(1.0f, 1.0f);
        $$29.addVertex($$27, -$$28, 100.0f, $$28).setUv(0.0f, 1.0f);
        BufferUploader.drawWithShader($$29.buildOrThrow());
        $$28 = 20.0f;
        RenderSystem.setShaderTexture(0, MOON_LOCATION);
        int $$30 = this.level.getMoonPhase();
        int $$31 = $$30 % 4;
        int $$32 = $$30 / 4 % 2;
        float $$33 = (float)($$31 + 0) / 4.0f;
        float $$34 = (float)($$32 + 0) / 2.0f;
        float $$35 = (float)($$31 + 1) / 4.0f;
        float $$36 = (float)($$32 + 1) / 2.0f;
        $$29 = $$12.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        $$29.addVertex($$27, -$$28, -100.0f, $$28).setUv($$35, $$36);
        $$29.addVertex($$27, $$28, -100.0f, $$28).setUv($$33, $$36);
        $$29.addVertex($$27, $$28, -100.0f, -$$28).setUv($$33, $$34);
        $$29.addVertex($$27, -$$28, -100.0f, -$$28).setUv($$35, $$34);
        BufferUploader.drawWithShader($$29.buildOrThrow());
        float $$37 = this.level.getStarBrightness(p_202426_) * $$26;
        if ($$37 > 0.0f) {
            RenderSystem.setShaderColor($$37, $$37, $$37, $$37);
            FogRenderer.setupNoFog();
            this.starBuffer.bind();
            this.starBuffer.drawWithShader($$7.last().pose(), p_324386_, GameRenderer.getPositionShader());
            VertexBuffer.unbind();
            p_202429_.run();
        }
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        $$7.popPose();
        RenderSystem.setShaderColor(0.0f, 0.0f, 0.0f, 1.0f);
        double $$38 = this.minecraft.player.getEyePosition((float)p_202426_).y - this.level.getLevelData().getHorizonHeight(this.level);
        if ($$38 < 0.0) {
            $$7.pushPose();
            $$7.translate(0.0f, 12.0f, 0.0f);
            this.darkBuffer.bind();
            this.darkBuffer.drawWithShader($$7.last().pose(), p_324386_, $$13);
            VertexBuffer.unbind();
            $$7.popPose();
        }
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.depthMask(true);
    }

    private boolean doesMobEffectBlockSky(Camera p_234311_) {
        Entity entity = p_234311_.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity $$1 = (LivingEntity)entity;
            return $$1.hasEffect(MobEffects.BLINDNESS) || $$1.hasEffect(MobEffects.DARKNESS);
        }
        return false;
    }

    public void renderClouds(PoseStack p_254145_, Matrix4f p_254537_, Matrix4f p_324366_, float p_254364_, double p_253843_, double p_253663_, double p_253795_) {
        float $$7 = this.level.effects().getCloudHeight();
        if (Float.isNaN($$7)) {
            return;
        }
        float $$8 = 12.0f;
        float $$9 = 4.0f;
        double $$10 = 2.0E-4;
        double $$11 = ((float)this.ticks + p_254364_) * 0.03f;
        double $$12 = (p_253843_ + $$11) / 12.0;
        double $$13 = $$7 - (float)p_253663_ + 0.33f;
        double $$14 = p_253795_ / 12.0 + (double)0.33f;
        $$12 -= (double)(Mth.floor($$12 / 2048.0) * 2048);
        $$14 -= (double)(Mth.floor($$14 / 2048.0) * 2048);
        float $$15 = (float)($$12 - (double)Mth.floor($$12));
        float $$16 = (float)($$13 / 4.0 - (double)Mth.floor($$13 / 4.0)) * 4.0f;
        float $$17 = (float)($$14 - (double)Mth.floor($$14));
        Vec3 $$18 = this.level.getCloudColor(p_254364_);
        int $$19 = (int)Math.floor($$12);
        int $$20 = (int)Math.floor($$13 / 4.0);
        int $$21 = (int)Math.floor($$14);
        if ($$19 != this.prevCloudX || $$20 != this.prevCloudY || $$21 != this.prevCloudZ || this.minecraft.options.getCloudsType() != this.prevCloudsType || this.prevCloudColor.distanceToSqr($$18) > 2.0E-4) {
            this.prevCloudX = $$19;
            this.prevCloudY = $$20;
            this.prevCloudZ = $$21;
            this.prevCloudColor = $$18;
            this.prevCloudsType = this.minecraft.options.getCloudsType();
            this.generateClouds = true;
        }
        if (this.generateClouds) {
            this.generateClouds = false;
            if (this.cloudBuffer != null) {
                this.cloudBuffer.close();
            }
            this.cloudBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            this.cloudBuffer.bind();
            this.cloudBuffer.upload(this.buildClouds(Tesselator.getInstance(), $$12, $$13, $$14, $$18));
            VertexBuffer.unbind();
        }
        FogRenderer.levelFogColor();
        p_254145_.pushPose();
        p_254145_.mulPose(p_254537_);
        p_254145_.scale(12.0f, 1.0f, 12.0f);
        p_254145_.translate(-$$15, $$16, -$$17);
        if (this.cloudBuffer != null) {
            int $$22;
            this.cloudBuffer.bind();
            for (int $$23 = $$22 = this.prevCloudsType == CloudStatus.FANCY ? 0 : 1; $$23 < 2; ++$$23) {
                RenderType $$24 = $$23 == 0 ? RenderType.cloudsDepthOnly() : RenderType.clouds();
                $$24.setupRenderState();
                ShaderInstance $$25 = RenderSystem.getShader();
                this.cloudBuffer.drawWithShader(p_254145_.last().pose(), p_324366_, $$25);
                $$24.clearRenderState();
            }
            VertexBuffer.unbind();
        }
        p_254145_.popPose();
    }

    private MeshData buildClouds(Tesselator p_350398_, double p_234263_, double p_234264_, double p_234265_, Vec3 p_234266_) {
        float $$5 = 4.0f;
        float $$6 = 0.00390625f;
        int $$7 = 8;
        int $$8 = 4;
        float $$9 = 9.765625E-4f;
        float $$10 = (float)Mth.floor(p_234263_) * 0.00390625f;
        float $$11 = (float)Mth.floor(p_234265_) * 0.00390625f;
        float $$12 = (float)p_234266_.x;
        float $$13 = (float)p_234266_.y;
        float $$14 = (float)p_234266_.z;
        float $$15 = $$12 * 0.9f;
        float $$16 = $$13 * 0.9f;
        float $$17 = $$14 * 0.9f;
        float $$18 = $$12 * 0.7f;
        float $$19 = $$13 * 0.7f;
        float $$20 = $$14 * 0.7f;
        float $$21 = $$12 * 0.8f;
        float $$22 = $$13 * 0.8f;
        float $$23 = $$14 * 0.8f;
        BufferBuilder $$24 = p_350398_.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX_COLOR_NORMAL);
        float $$25 = (float)Math.floor(p_234264_ / 4.0) * 4.0f;
        if (this.prevCloudsType == CloudStatus.FANCY) {
            for (int $$26 = -3; $$26 <= 4; ++$$26) {
                for (int $$27 = -3; $$27 <= 4; ++$$27) {
                    float $$28 = $$26 * 8;
                    float $$29 = $$27 * 8;
                    if ($$25 > -5.0f) {
                        $$24.addVertex($$28 + 0.0f, $$25 + 0.0f, $$29 + 8.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$18, $$19, $$20, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 0.0f, $$29 + 8.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$18, $$19, $$20, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 0.0f, $$29 + 0.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$18, $$19, $$20, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                        $$24.addVertex($$28 + 0.0f, $$25 + 0.0f, $$29 + 0.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$18, $$19, $$20, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    }
                    if ($$25 <= 5.0f) {
                        $$24.addVertex($$28 + 0.0f, $$25 + 4.0f - 9.765625E-4f, $$29 + 8.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 4.0f - 9.765625E-4f, $$29 + 8.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 4.0f - 9.765625E-4f, $$29 + 0.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                        $$24.addVertex($$28 + 0.0f, $$25 + 4.0f - 9.765625E-4f, $$29 + 0.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, 1.0f, 0.0f);
                    }
                    if ($$26 > -1) {
                        for (int $$30 = 0; $$30 < 8; ++$$30) {
                            $$24.addVertex($$28 + (float)$$30 + 0.0f, $$25 + 0.0f, $$29 + 8.0f).setUv(($$28 + (float)$$30 + 0.5f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$30 + 0.0f, $$25 + 4.0f, $$29 + 8.0f).setUv(($$28 + (float)$$30 + 0.5f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$30 + 0.0f, $$25 + 4.0f, $$29 + 0.0f).setUv(($$28 + (float)$$30 + 0.5f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$30 + 0.0f, $$25 + 0.0f, $$29 + 0.0f).setUv(($$28 + (float)$$30 + 0.5f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(-1.0f, 0.0f, 0.0f);
                        }
                    }
                    if ($$26 <= 1) {
                        for (int $$31 = 0; $$31 < 8; ++$$31) {
                            $$24.addVertex($$28 + (float)$$31 + 1.0f - 9.765625E-4f, $$25 + 0.0f, $$29 + 8.0f).setUv(($$28 + (float)$$31 + 0.5f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$31 + 1.0f - 9.765625E-4f, $$25 + 4.0f, $$29 + 8.0f).setUv(($$28 + (float)$$31 + 0.5f) * 0.00390625f + $$10, ($$29 + 8.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$31 + 1.0f - 9.765625E-4f, $$25 + 4.0f, $$29 + 0.0f).setUv(($$28 + (float)$$31 + 0.5f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                            $$24.addVertex($$28 + (float)$$31 + 1.0f - 9.765625E-4f, $$25 + 0.0f, $$29 + 0.0f).setUv(($$28 + (float)$$31 + 0.5f) * 0.00390625f + $$10, ($$29 + 0.0f) * 0.00390625f + $$11).setColor($$15, $$16, $$17, 0.8f).setNormal(1.0f, 0.0f, 0.0f);
                        }
                    }
                    if ($$27 > -1) {
                        for (int $$32 = 0; $$32 < 8; ++$$32) {
                            $$24.addVertex($$28 + 0.0f, $$25 + 4.0f, $$29 + (float)$$32 + 0.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + (float)$$32 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            $$24.addVertex($$28 + 8.0f, $$25 + 4.0f, $$29 + (float)$$32 + 0.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + (float)$$32 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            $$24.addVertex($$28 + 8.0f, $$25 + 0.0f, $$29 + (float)$$32 + 0.0f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + (float)$$32 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                            $$24.addVertex($$28 + 0.0f, $$25 + 0.0f, $$29 + (float)$$32 + 0.0f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + (float)$$32 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, -1.0f);
                        }
                    }
                    if ($$27 > 1) continue;
                    for (int $$33 = 0; $$33 < 8; ++$$33) {
                        $$24.addVertex($$28 + 0.0f, $$25 + 4.0f, $$29 + (float)$$33 + 1.0f - 9.765625E-4f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + (float)$$33 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 4.0f, $$29 + (float)$$33 + 1.0f - 9.765625E-4f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + (float)$$33 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        $$24.addVertex($$28 + 8.0f, $$25 + 0.0f, $$29 + (float)$$33 + 1.0f - 9.765625E-4f).setUv(($$28 + 8.0f) * 0.00390625f + $$10, ($$29 + (float)$$33 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                        $$24.addVertex($$28 + 0.0f, $$25 + 0.0f, $$29 + (float)$$33 + 1.0f - 9.765625E-4f).setUv(($$28 + 0.0f) * 0.00390625f + $$10, ($$29 + (float)$$33 + 0.5f) * 0.00390625f + $$11).setColor($$21, $$22, $$23, 0.8f).setNormal(0.0f, 0.0f, 1.0f);
                    }
                }
            }
        } else {
            boolean $$34 = true;
            int $$35 = 32;
            for (int $$36 = -32; $$36 < 32; $$36 += 32) {
                for (int $$37 = -32; $$37 < 32; $$37 += 32) {
                    $$24.addVertex($$36 + 0, $$25, $$37 + 32).setUv((float)($$36 + 0) * 0.00390625f + $$10, (float)($$37 + 32) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    $$24.addVertex($$36 + 32, $$25, $$37 + 32).setUv((float)($$36 + 32) * 0.00390625f + $$10, (float)($$37 + 32) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    $$24.addVertex($$36 + 32, $$25, $$37 + 0).setUv((float)($$36 + 32) * 0.00390625f + $$10, (float)($$37 + 0) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                    $$24.addVertex($$36 + 0, $$25, $$37 + 0).setUv((float)($$36 + 0) * 0.00390625f + $$10, (float)($$37 + 0) * 0.00390625f + $$11).setColor($$12, $$13, $$14, 0.8f).setNormal(0.0f, -1.0f, 0.0f);
                }
            }
        }
        return $$24.buildOrThrow();
    }

    private void compileSections(Camera p_194371_) {
        this.minecraft.getProfiler().push("populate_sections_to_compile");
        LevelLightEngine $$1 = this.level.getLightEngine();
        RenderRegionCache $$2 = new RenderRegionCache();
        BlockPos $$3 = p_194371_.getBlockPosition();
        ArrayList $$4 = Lists.newArrayList();
        for (SectionRenderDispatcher.RenderSection $$5 : this.visibleSections) {
            SectionPos $$6 = SectionPos.of($$5.getOrigin());
            if (!$$5.isDirty() || !$$1.lightOnInSection($$6)) continue;
            boolean $$7 = false;
            if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.NEARBY) {
                BlockPos $$8 = $$5.getOrigin().offset(8, 8, 8);
                $$7 = $$8.distSqr($$3) < 768.0 || $$5.isDirtyFromPlayer();
            } else if (this.minecraft.options.prioritizeChunkUpdates().get() == PrioritizeChunkUpdates.PLAYER_AFFECTED) {
                $$7 = $$5.isDirtyFromPlayer();
            }
            if ($$7) {
                this.minecraft.getProfiler().push("build_near_sync");
                this.sectionRenderDispatcher.rebuildSectionSync($$5, $$2);
                $$5.setNotDirty();
                this.minecraft.getProfiler().pop();
                continue;
            }
            $$4.add($$5);
        }
        this.minecraft.getProfiler().popPush("upload");
        this.sectionRenderDispatcher.uploadAllPendingUploads();
        this.minecraft.getProfiler().popPush("schedule_async_compile");
        for (SectionRenderDispatcher.RenderSection $$9 : $$4) {
            $$9.rebuildSectionAsync(this.sectionRenderDispatcher, $$2);
            $$9.setNotDirty();
        }
        this.minecraft.getProfiler().pop();
    }

    private void renderWorldBorder(Camera p_173013_) {
        MeshData $$34;
        WorldBorder $$1 = this.level.getWorldBorder();
        double $$2 = this.minecraft.options.getEffectiveRenderDistance() * 16;
        if (p_173013_.getPosition().x < $$1.getMaxX() - $$2 && p_173013_.getPosition().x > $$1.getMinX() + $$2 && p_173013_.getPosition().z < $$1.getMaxZ() - $$2 && p_173013_.getPosition().z > $$1.getMinZ() + $$2) {
            return;
        }
        double $$3 = 1.0 - $$1.getDistanceToBorder(p_173013_.getPosition().x, p_173013_.getPosition().z) / $$2;
        $$3 = Math.pow($$3, 4.0);
        $$3 = Mth.clamp($$3, 0.0, 1.0);
        double $$4 = p_173013_.getPosition().x;
        double $$5 = p_173013_.getPosition().z;
        double $$6 = this.minecraft.gameRenderer.getDepthFar();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.blendFuncSeparate(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        RenderSystem.setShaderTexture(0, FORCEFIELD_LOCATION);
        RenderSystem.depthMask(Minecraft.useShaderTransparency());
        int $$7 = $$1.getStatus().getColor();
        float $$8 = (float)($$7 >> 16 & 0xFF) / 255.0f;
        float $$9 = (float)($$7 >> 8 & 0xFF) / 255.0f;
        float $$10 = (float)($$7 & 0xFF) / 255.0f;
        RenderSystem.setShaderColor($$8, $$9, $$10, (float)$$3);
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.polygonOffset(-3.0f, -3.0f);
        RenderSystem.enablePolygonOffset();
        RenderSystem.disableCull();
        float $$11 = (float)(Util.getMillis() % 3000L) / 3000.0f;
        float $$12 = (float)(-Mth.frac(p_173013_.getPosition().y * 0.5));
        float $$13 = $$12 + (float)$$6;
        BufferBuilder $$14 = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        double $$15 = Math.max((double)Mth.floor($$5 - $$2), $$1.getMinZ());
        double $$16 = Math.min((double)Mth.ceil($$5 + $$2), $$1.getMaxZ());
        float $$17 = (float)(Mth.floor($$15) & 1) * 0.5f;
        if ($$4 > $$1.getMaxX() - $$2) {
            float $$18 = $$17;
            double $$19 = $$15;
            while ($$19 < $$16) {
                double $$20 = Math.min(1.0, $$16 - $$19);
                float $$21 = (float)$$20 * 0.5f;
                $$14.addVertex((float)($$1.getMaxX() - $$4), (float)(-$$6), (float)($$19 - $$5)).setUv($$11 - $$18, $$11 + $$13);
                $$14.addVertex((float)($$1.getMaxX() - $$4), (float)(-$$6), (float)($$19 + $$20 - $$5)).setUv($$11 - ($$21 + $$18), $$11 + $$13);
                $$14.addVertex((float)($$1.getMaxX() - $$4), (float)$$6, (float)($$19 + $$20 - $$5)).setUv($$11 - ($$21 + $$18), $$11 + $$12);
                $$14.addVertex((float)($$1.getMaxX() - $$4), (float)$$6, (float)($$19 - $$5)).setUv($$11 - $$18, $$11 + $$12);
                $$19 += 1.0;
                $$18 += 0.5f;
            }
        }
        if ($$4 < $$1.getMinX() + $$2) {
            float $$22 = $$17;
            double $$23 = $$15;
            while ($$23 < $$16) {
                double $$24 = Math.min(1.0, $$16 - $$23);
                float $$25 = (float)$$24 * 0.5f;
                $$14.addVertex((float)($$1.getMinX() - $$4), (float)(-$$6), (float)($$23 - $$5)).setUv($$11 + $$22, $$11 + $$13);
                $$14.addVertex((float)($$1.getMinX() - $$4), (float)(-$$6), (float)($$23 + $$24 - $$5)).setUv($$11 + $$25 + $$22, $$11 + $$13);
                $$14.addVertex((float)($$1.getMinX() - $$4), (float)$$6, (float)($$23 + $$24 - $$5)).setUv($$11 + $$25 + $$22, $$11 + $$12);
                $$14.addVertex((float)($$1.getMinX() - $$4), (float)$$6, (float)($$23 - $$5)).setUv($$11 + $$22, $$11 + $$12);
                $$23 += 1.0;
                $$22 += 0.5f;
            }
        }
        $$15 = Math.max((double)Mth.floor($$4 - $$2), $$1.getMinX());
        $$16 = Math.min((double)Mth.ceil($$4 + $$2), $$1.getMaxX());
        $$17 = (float)(Mth.floor($$15) & 1) * 0.5f;
        if ($$5 > $$1.getMaxZ() - $$2) {
            float $$26 = $$17;
            double $$27 = $$15;
            while ($$27 < $$16) {
                double $$28 = Math.min(1.0, $$16 - $$27);
                float $$29 = (float)$$28 * 0.5f;
                $$14.addVertex((float)($$27 - $$4), (float)(-$$6), (float)($$1.getMaxZ() - $$5)).setUv($$11 + $$26, $$11 + $$13);
                $$14.addVertex((float)($$27 + $$28 - $$4), (float)(-$$6), (float)($$1.getMaxZ() - $$5)).setUv($$11 + $$29 + $$26, $$11 + $$13);
                $$14.addVertex((float)($$27 + $$28 - $$4), (float)$$6, (float)($$1.getMaxZ() - $$5)).setUv($$11 + $$29 + $$26, $$11 + $$12);
                $$14.addVertex((float)($$27 - $$4), (float)$$6, (float)($$1.getMaxZ() - $$5)).setUv($$11 + $$26, $$11 + $$12);
                $$27 += 1.0;
                $$26 += 0.5f;
            }
        }
        if ($$5 < $$1.getMinZ() + $$2) {
            float $$30 = $$17;
            double $$31 = $$15;
            while ($$31 < $$16) {
                double $$32 = Math.min(1.0, $$16 - $$31);
                float $$33 = (float)$$32 * 0.5f;
                $$14.addVertex((float)($$31 - $$4), (float)(-$$6), (float)($$1.getMinZ() - $$5)).setUv($$11 - $$30, $$11 + $$13);
                $$14.addVertex((float)($$31 + $$32 - $$4), (float)(-$$6), (float)($$1.getMinZ() - $$5)).setUv($$11 - ($$33 + $$30), $$11 + $$13);
                $$14.addVertex((float)($$31 + $$32 - $$4), (float)$$6, (float)($$1.getMinZ() - $$5)).setUv($$11 - ($$33 + $$30), $$11 + $$12);
                $$14.addVertex((float)($$31 - $$4), (float)$$6, (float)($$1.getMinZ() - $$5)).setUv($$11 - $$30, $$11 + $$12);
                $$31 += 1.0;
                $$30 += 0.5f;
            }
        }
        if (($$34 = $$14.build()) != null) {
            BufferUploader.drawWithShader($$34);
        }
        RenderSystem.enableCull();
        RenderSystem.polygonOffset(0.0f, 0.0f);
        RenderSystem.disablePolygonOffset();
        RenderSystem.disableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        RenderSystem.depthMask(true);
    }

    private void renderHitOutline(PoseStack p_109638_, VertexConsumer p_109639_, Entity p_109640_, double p_109641_, double p_109642_, double p_109643_, BlockPos p_109644_, BlockState p_109645_) {
        LevelRenderer.renderShape(p_109638_, p_109639_, p_109645_.getShape(this.level, p_109644_, CollisionContext.of(p_109640_)), (double)p_109644_.getX() - p_109641_, (double)p_109644_.getY() - p_109642_, (double)p_109644_.getZ() - p_109643_, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    private static Vec3 mixColor(float p_286899_) {
        float $$1 = 5.99999f;
        int $$2 = (int)(Mth.clamp(p_286899_, 0.0f, 1.0f) * 5.99999f);
        float $$3 = p_286899_ * 5.99999f - (float)$$2;
        return switch ($$2) {
            case 0 -> new Vec3(1.0, $$3, 0.0);
            case 1 -> new Vec3(1.0f - $$3, 1.0, 0.0);
            case 2 -> new Vec3(0.0, 1.0, $$3);
            case 3 -> new Vec3(0.0, 1.0 - (double)$$3, 1.0);
            case 4 -> new Vec3($$3, 0.0, 1.0);
            case 5 -> new Vec3(1.0, 0.0, 1.0 - (double)$$3);
            default -> throw new IllegalStateException("Unexpected value: " + $$2);
        };
    }

    private static Vec3 shiftHue(float p_286907_, float p_286536_, float p_286318_, float p_286590_) {
        Vec3 $$4 = LevelRenderer.mixColor(p_286590_).scale(p_286907_);
        Vec3 $$5 = LevelRenderer.mixColor((p_286590_ + 0.33333334f) % 1.0f).scale(p_286536_);
        Vec3 $$6 = LevelRenderer.mixColor((p_286590_ + 0.6666667f) % 1.0f).scale(p_286318_);
        Vec3 $$7 = $$4.add($$5).add($$6);
        double $$8 = Math.max(Math.max(1.0, $$7.x), Math.max($$7.y, $$7.z));
        return new Vec3($$7.x / $$8, $$7.y / $$8, $$7.z / $$8);
    }

    public static void renderVoxelShape(PoseStack p_286791_, VertexConsumer p_286416_, VoxelShape p_286863_, double p_286432_, double p_286836_, double p_286774_, float p_286612_, float p_286516_, float p_286787_, float p_286300_, boolean p_286443_) {
        List<AABB> $$11 = p_286863_.toAabbs();
        if ($$11.isEmpty()) {
            return;
        }
        int $$12 = p_286443_ ? $$11.size() : $$11.size() * 8;
        LevelRenderer.renderShape(p_286791_, p_286416_, Shapes.create($$11.get(0)), p_286432_, p_286836_, p_286774_, p_286612_, p_286516_, p_286787_, p_286300_);
        for (int $$13 = 1; $$13 < $$11.size(); ++$$13) {
            AABB $$14 = $$11.get($$13);
            float $$15 = (float)$$13 / (float)$$12;
            Vec3 $$16 = LevelRenderer.shiftHue(p_286612_, p_286516_, p_286787_, $$15);
            LevelRenderer.renderShape(p_286791_, p_286416_, Shapes.create($$14), p_286432_, p_286836_, p_286774_, (float)$$16.x, (float)$$16.y, (float)$$16.z, p_286300_);
        }
    }

    private static void renderShape(PoseStack p_109783_, VertexConsumer p_109784_, VoxelShape p_109785_, double p_109786_, double p_109787_, double p_109788_, float p_109789_, float p_109790_, float p_109791_, float p_109792_) {
        PoseStack.Pose $$10 = p_109783_.last();
        p_109785_.forAllEdges((p_323073_, p_323074_, p_323075_, p_323076_, p_323077_, p_323078_) -> {
            float $$15 = (float)(p_323076_ - p_323073_);
            float $$16 = (float)(p_323077_ - p_323074_);
            float $$17 = (float)(p_323078_ - p_323075_);
            float $$18 = Mth.sqrt($$15 * $$15 + $$16 * $$16 + $$17 * $$17);
            p_109784_.addVertex($$10, (float)(p_323073_ + p_109786_), (float)(p_323074_ + p_109787_), (float)(p_323075_ + p_109788_)).setColor(p_109789_, p_109790_, p_109791_, p_109792_).setNormal($$10, $$15 /= $$18, $$16 /= $$18, $$17 /= $$18);
            p_109784_.addVertex($$10, (float)(p_323076_ + p_109786_), (float)(p_323077_ + p_109787_), (float)(p_323078_ + p_109788_)).setColor(p_109789_, p_109790_, p_109791_, p_109792_).setNormal($$10, $$15, $$16, $$17);
        });
    }

    public static void renderLineBox(VertexConsumer p_172966_, double p_172967_, double p_172968_, double p_172969_, double p_172970_, double p_172971_, double p_172972_, float p_172973_, float p_172974_, float p_172975_, float p_172976_) {
        LevelRenderer.renderLineBox(new PoseStack(), p_172966_, p_172967_, p_172968_, p_172969_, p_172970_, p_172971_, p_172972_, p_172973_, p_172974_, p_172975_, p_172976_, p_172973_, p_172974_, p_172975_);
    }

    public static void renderLineBox(PoseStack p_109647_, VertexConsumer p_109648_, AABB p_109649_, float p_109650_, float p_109651_, float p_109652_, float p_109653_) {
        LevelRenderer.renderLineBox(p_109647_, p_109648_, p_109649_.minX, p_109649_.minY, p_109649_.minZ, p_109649_.maxX, p_109649_.maxY, p_109649_.maxZ, p_109650_, p_109651_, p_109652_, p_109653_, p_109650_, p_109651_, p_109652_);
    }

    public static void renderLineBox(PoseStack p_109609_, VertexConsumer p_109610_, double p_109611_, double p_109612_, double p_109613_, double p_109614_, double p_109615_, double p_109616_, float p_109617_, float p_109618_, float p_109619_, float p_109620_) {
        LevelRenderer.renderLineBox(p_109609_, p_109610_, p_109611_, p_109612_, p_109613_, p_109614_, p_109615_, p_109616_, p_109617_, p_109618_, p_109619_, p_109620_, p_109617_, p_109618_, p_109619_);
    }

    public static void renderLineBox(PoseStack p_109622_, VertexConsumer p_109623_, double p_109624_, double p_109625_, double p_109626_, double p_109627_, double p_109628_, double p_109629_, float p_109630_, float p_109631_, float p_109632_, float p_109633_, float p_109634_, float p_109635_, float p_109636_) {
        PoseStack.Pose $$15 = p_109622_.last();
        float $$16 = (float)p_109624_;
        float $$17 = (float)p_109625_;
        float $$18 = (float)p_109626_;
        float $$19 = (float)p_109627_;
        float $$20 = (float)p_109628_;
        float $$21 = (float)p_109629_;
        p_109623_.addVertex($$15, $$16, $$17, $$18).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$18).setColor(p_109630_, p_109635_, p_109636_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$17, $$18).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$18).setColor(p_109634_, p_109631_, p_109636_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$17, $$18).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
        p_109623_.addVertex($$15, $$16, $$17, $$21).setColor(p_109634_, p_109635_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, -1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, -1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, -1.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$17, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, -1.0f, 0.0f);
        p_109623_.addVertex($$15, $$16, $$17, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, -1.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, -1.0f);
        p_109623_.addVertex($$15, $$16, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 1.0f, 0.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$17, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 1.0f, 0.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$18).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
        p_109623_.addVertex($$15, $$19, $$20, $$21).setColor(p_109630_, p_109631_, p_109632_, p_109633_).setNormal($$15, 0.0f, 0.0f, 1.0f);
    }

    public static void addChainedFilledBoxVertices(PoseStack p_270343_, VertexConsumer p_270926_, double p_270503_, double p_270353_, double p_270642_, double p_270676_, double p_270711_, double p_270601_, float p_270523_, float p_270382_, float p_270089_, float p_270335_) {
        LevelRenderer.addChainedFilledBoxVertices(p_270343_, p_270926_, (float)p_270503_, (float)p_270353_, (float)p_270642_, (float)p_270676_, (float)p_270711_, (float)p_270601_, p_270523_, p_270382_, p_270089_, p_270335_);
    }

    public static void addChainedFilledBoxVertices(PoseStack p_270352_, VertexConsumer p_271015_, float p_270144_, float p_270901_, float p_270546_, float p_270102_, float p_270605_, float p_271006_, float p_270864_, float p_270181_, float p_270220_, float p_270293_) {
        Matrix4f $$12 = p_270352_.last().pose();
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270901_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270144_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_270546_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
        p_271015_.addVertex($$12, p_270102_, p_270605_, p_271006_).setColor(p_270864_, p_270181_, p_270220_, p_270293_);
    }

    public static void renderFace(PoseStack p_352330_, VertexConsumer p_352130_, Direction p_352308_, float p_352429_, float p_352303_, float p_352424_, float p_352369_, float p_352439_, float p_352140_, float p_352061_, float p_352352_, float p_352098_, float p_352096_) {
        Matrix4f $$13 = p_352330_.last().pose();
        switch (p_352308_) {
            case DOWN: {
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                break;
            }
            case UP: {
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                break;
            }
            case NORTH: {
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                break;
            }
            case SOUTH: {
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                break;
            }
            case WEST: {
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352429_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                break;
            }
            case EAST: {
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352424_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352439_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
                p_352130_.addVertex($$13, p_352369_, p_352303_, p_352140_).setColor(p_352061_, p_352352_, p_352098_, p_352096_);
            }
        }
    }

    public void blockChanged(BlockGetter p_109545_, BlockPos p_109546_, BlockState p_109547_, BlockState p_109548_, int p_109549_) {
        this.setBlockDirty(p_109546_, (p_109549_ & 8) != 0);
    }

    private void setBlockDirty(BlockPos p_109733_, boolean p_109734_) {
        for (int $$2 = p_109733_.getZ() - 1; $$2 <= p_109733_.getZ() + 1; ++$$2) {
            for (int $$3 = p_109733_.getX() - 1; $$3 <= p_109733_.getX() + 1; ++$$3) {
                for (int $$4 = p_109733_.getY() - 1; $$4 <= p_109733_.getY() + 1; ++$$4) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord($$3), SectionPos.blockToSectionCoord($$4), SectionPos.blockToSectionCoord($$2), p_109734_);
                }
            }
        }
    }

    public void setBlocksDirty(int p_109495_, int p_109496_, int p_109497_, int p_109498_, int p_109499_, int p_109500_) {
        for (int $$6 = p_109497_ - 1; $$6 <= p_109500_ + 1; ++$$6) {
            for (int $$7 = p_109495_ - 1; $$7 <= p_109498_ + 1; ++$$7) {
                for (int $$8 = p_109496_ - 1; $$8 <= p_109499_ + 1; ++$$8) {
                    this.setSectionDirty(SectionPos.blockToSectionCoord($$7), SectionPos.blockToSectionCoord($$8), SectionPos.blockToSectionCoord($$6));
                }
            }
        }
    }

    public void setBlockDirty(BlockPos p_109722_, BlockState p_109723_, BlockState p_109724_) {
        if (this.minecraft.getModelManager().requiresRender(p_109723_, p_109724_)) {
            this.setBlocksDirty(p_109722_.getX(), p_109722_.getY(), p_109722_.getZ(), p_109722_.getX(), p_109722_.getY(), p_109722_.getZ());
        }
    }

    public void setSectionDirtyWithNeighbors(int p_109491_, int p_109492_, int p_109493_) {
        for (int $$3 = p_109493_ - 1; $$3 <= p_109493_ + 1; ++$$3) {
            for (int $$4 = p_109491_ - 1; $$4 <= p_109491_ + 1; ++$$4) {
                for (int $$5 = p_109492_ - 1; $$5 <= p_109492_ + 1; ++$$5) {
                    this.setSectionDirty($$4, $$5, $$3);
                }
            }
        }
    }

    public void setSectionDirty(int p_109771_, int p_109772_, int p_109773_) {
        this.setSectionDirty(p_109771_, p_109772_, p_109773_, false);
    }

    private void setSectionDirty(int p_109502_, int p_109503_, int p_109504_, boolean p_109505_) {
        this.viewArea.setDirty(p_109502_, p_109503_, p_109504_, p_109505_);
    }

    public void playJukeboxSong(Holder<JukeboxSong> p_350918_, BlockPos p_350830_) {
        if (this.level == null) {
            return;
        }
        this.stopJukeboxSong(p_350830_);
        JukeboxSong $$2 = p_350918_.value();
        SoundEvent $$3 = $$2.soundEvent().value();
        SimpleSoundInstance $$4 = SimpleSoundInstance.forJukeboxSong($$3, Vec3.atCenterOf(p_350830_));
        this.playingJukeboxSongs.put(p_350830_, $$4);
        this.minecraft.getSoundManager().play($$4);
        this.minecraft.gui.setNowPlaying($$2.description());
        this.notifyNearbyEntities(this.level, p_350830_, true);
    }

    private void stopJukeboxSong(BlockPos p_350526_) {
        SoundInstance $$1 = this.playingJukeboxSongs.remove(p_350526_);
        if ($$1 != null) {
            this.minecraft.getSoundManager().stop($$1);
        }
    }

    public void stopJukeboxSongAndNotifyNearby(BlockPos p_350385_) {
        this.stopJukeboxSong(p_350385_);
        if (this.level != null) {
            this.notifyNearbyEntities(this.level, p_350385_, false);
        }
    }

    private void notifyNearbyEntities(Level p_109551_, BlockPos p_109552_, boolean p_109553_) {
        List<LivingEntity> $$3 = p_109551_.getEntitiesOfClass(LivingEntity.class, new AABB(p_109552_).inflate(3.0));
        for (LivingEntity $$4 : $$3) {
            $$4.setRecordPlayingNearby(p_109552_, p_109553_);
        }
    }

    public void addParticle(ParticleOptions p_109744_, boolean p_109745_, double p_109746_, double p_109747_, double p_109748_, double p_109749_, double p_109750_, double p_109751_) {
        this.addParticle(p_109744_, p_109745_, false, p_109746_, p_109747_, p_109748_, p_109749_, p_109750_, p_109751_);
    }

    public void addParticle(ParticleOptions p_109753_, boolean p_109754_, boolean p_109755_, double p_109756_, double p_109757_, double p_109758_, double p_109759_, double p_109760_, double p_109761_) {
        try {
            this.addParticleInternal(p_109753_, p_109754_, p_109755_, p_109756_, p_109757_, p_109758_, p_109759_, p_109760_, p_109761_);
        }
        catch (Throwable $$9) {
            CrashReport $$10 = CrashReport.forThrowable($$9, "Exception while adding particle");
            CrashReportCategory $$11 = $$10.addCategory("Particle being added");
            $$11.setDetail("ID", BuiltInRegistries.PARTICLE_TYPE.getKey(p_109753_.getType()));
            $$11.setDetail("Parameters", () -> ParticleTypes.CODEC.encodeStart(this.level.registryAccess().createSerializationContext(NbtOps.INSTANCE), (Object)p_109753_).toString());
            $$11.setDetail("Position", () -> CrashReportCategory.formatLocation((LevelHeightAccessor)this.level, p_109756_, p_109757_, p_109758_));
            throw new ReportedException($$10);
        }
    }

    private <T extends ParticleOptions> void addParticle(T p_109736_, double p_109737_, double p_109738_, double p_109739_, double p_109740_, double p_109741_, double p_109742_) {
        this.addParticle(p_109736_, p_109736_.getType().getOverrideLimiter(), p_109737_, p_109738_, p_109739_, p_109740_, p_109741_, p_109742_);
    }

    @Nullable
    private Particle addParticleInternal(ParticleOptions p_109796_, boolean p_109797_, double p_109798_, double p_109799_, double p_109800_, double p_109801_, double p_109802_, double p_109803_) {
        return this.addParticleInternal(p_109796_, p_109797_, false, p_109798_, p_109799_, p_109800_, p_109801_, p_109802_, p_109803_);
    }

    @Nullable
    private Particle addParticleInternal(ParticleOptions p_109805_, boolean p_109806_, boolean p_109807_, double p_109808_, double p_109809_, double p_109810_, double p_109811_, double p_109812_, double p_109813_) {
        Camera $$9 = this.minecraft.gameRenderer.getMainCamera();
        ParticleStatus $$10 = this.calculateParticleLevel(p_109807_);
        if (p_109806_) {
            return this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
        }
        if ($$9.getPosition().distanceToSqr(p_109808_, p_109809_, p_109810_) > 1024.0) {
            return null;
        }
        if ($$10 == ParticleStatus.MINIMAL) {
            return null;
        }
        return this.minecraft.particleEngine.createParticle(p_109805_, p_109808_, p_109809_, p_109810_, p_109811_, p_109812_, p_109813_);
    }

    private ParticleStatus calculateParticleLevel(boolean p_109768_) {
        ParticleStatus $$1 = this.minecraft.options.particles().get();
        if (p_109768_ && $$1 == ParticleStatus.MINIMAL && this.level.random.nextInt(10) == 0) {
            $$1 = ParticleStatus.DECREASED;
        }
        if ($$1 == ParticleStatus.DECREASED && this.level.random.nextInt(3) == 0) {
            $$1 = ParticleStatus.MINIMAL;
        }
        return $$1;
    }

    public void clear() {
    }

    public void globalLevelEvent(int p_109507_, BlockPos p_109508_, int p_109509_) {
        switch (p_109507_) {
            case 1023: 
            case 1028: 
            case 1038: {
                Camera $$3 = this.minecraft.gameRenderer.getMainCamera();
                if (!$$3.isInitialized()) break;
                double $$4 = (double)p_109508_.getX() - $$3.getPosition().x;
                double $$5 = (double)p_109508_.getY() - $$3.getPosition().y;
                double $$6 = (double)p_109508_.getZ() - $$3.getPosition().z;
                double $$7 = Math.sqrt($$4 * $$4 + $$5 * $$5 + $$6 * $$6);
                double $$8 = $$3.getPosition().x;
                double $$9 = $$3.getPosition().y;
                double $$10 = $$3.getPosition().z;
                if ($$7 > 0.0) {
                    $$8 += $$4 / $$7 * 2.0;
                    $$9 += $$5 / $$7 * 2.0;
                    $$10 += $$6 / $$7 * 2.0;
                }
                if (p_109507_ == 1023) {
                    this.level.playLocalSound($$8, $$9, $$10, SoundEvents.WITHER_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                if (p_109507_ == 1038) {
                    this.level.playLocalSound($$8, $$9, $$10, SoundEvents.END_PORTAL_SPAWN, SoundSource.HOSTILE, 1.0f, 1.0f, false);
                    break;
                }
                this.level.playLocalSound($$8, $$9, $$10, SoundEvents.ENDER_DRAGON_DEATH, SoundSource.HOSTILE, 5.0f, 1.0f, false);
            }
        }
    }

    public void levelEvent(int p_234305_, BlockPos p_234306_, int p_234307_) {
        RandomSource $$3 = this.level.random;
        switch (p_234305_) {
            case 1035: {
                this.level.playLocalSound(p_234306_, SoundEvents.BREWING_STAND_BREW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1033: {
                this.level.playLocalSound(p_234306_, SoundEvents.CHORUS_FLOWER_GROW, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1034: {
                this.level.playLocalSound(p_234306_, SoundEvents.CHORUS_FLOWER_DEATH, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1032: {
                this.minecraft.getSoundManager().play(SimpleSoundInstance.forLocalAmbience(SoundEvents.PORTAL_TRAVEL, $$3.nextFloat() * 0.4f + 0.8f, 0.25f));
                break;
            }
            case 1001: {
                this.level.playLocalSound(p_234306_, SoundEvents.DISPENSER_FAIL, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1000: {
                this.level.playLocalSound(p_234306_, SoundEvents.DISPENSER_DISPENSE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1049: {
                this.level.playLocalSound(p_234306_, SoundEvents.CRAFTER_CRAFT, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1050: {
                this.level.playLocalSound(p_234306_, SoundEvents.CRAFTER_FAIL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 1004: {
                this.level.playLocalSound(p_234306_, SoundEvents.FIREWORK_ROCKET_SHOOT, SoundSource.NEUTRAL, 1.0f, 1.2f, false);
                break;
            }
            case 1002: {
                this.level.playLocalSound(p_234306_, SoundEvents.DISPENSER_LAUNCH, SoundSource.BLOCKS, 1.0f, 1.2f, false);
                break;
            }
            case 1051: {
                this.level.playLocalSound(p_234306_, SoundEvents.WIND_CHARGE_THROW, SoundSource.BLOCKS, 0.5f, 0.4f / (this.level.getRandom().nextFloat() * 0.4f + 0.8f), false);
            }
            case 2010: {
                this.shootParticles(p_234307_, p_234306_, $$3, ParticleTypes.WHITE_SMOKE);
                break;
            }
            case 2000: {
                this.shootParticles(p_234307_, p_234306_, $$3, ParticleTypes.SMOKE);
                break;
            }
            case 2003: {
                double $$4 = (double)p_234306_.getX() + 0.5;
                double $$5 = p_234306_.getY();
                double $$6 = (double)p_234306_.getZ() + 0.5;
                for (int $$7 = 0; $$7 < 8; ++$$7) {
                    this.addParticle(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.ENDER_EYE)), $$4, $$5, $$6, $$3.nextGaussian() * 0.15, $$3.nextDouble() * 0.2, $$3.nextGaussian() * 0.15);
                }
                for (double $$8 = 0.0; $$8 < Math.PI * 2; $$8 += 0.15707963267948966) {
                    this.addParticle(ParticleTypes.PORTAL, $$4 + Math.cos($$8) * 5.0, $$5 - 0.4, $$6 + Math.sin($$8) * 5.0, Math.cos($$8) * -5.0, 0.0, Math.sin($$8) * -5.0);
                    this.addParticle(ParticleTypes.PORTAL, $$4 + Math.cos($$8) * 5.0, $$5 - 0.4, $$6 + Math.sin($$8) * 5.0, Math.cos($$8) * -7.0, 0.0, Math.sin($$8) * -7.0);
                }
                break;
            }
            case 2002: 
            case 2007: {
                Vec3 $$9 = Vec3.atBottomCenterOf(p_234306_);
                for (int $$10 = 0; $$10 < 8; ++$$10) {
                    this.addParticle(new ItemParticleOption(ParticleTypes.ITEM, new ItemStack(Items.SPLASH_POTION)), $$9.x, $$9.y, $$9.z, $$3.nextGaussian() * 0.15, $$3.nextDouble() * 0.2, $$3.nextGaussian() * 0.15);
                }
                float $$11 = (float)(p_234307_ >> 16 & 0xFF) / 255.0f;
                float $$12 = (float)(p_234307_ >> 8 & 0xFF) / 255.0f;
                float $$13 = (float)(p_234307_ >> 0 & 0xFF) / 255.0f;
                SimpleParticleType $$14 = p_234305_ == 2007 ? ParticleTypes.INSTANT_EFFECT : ParticleTypes.EFFECT;
                for (int $$15 = 0; $$15 < 100; ++$$15) {
                    double $$16 = $$3.nextDouble() * 4.0;
                    double $$17 = $$3.nextDouble() * Math.PI * 2.0;
                    double $$18 = Math.cos($$17) * $$16;
                    double $$19 = 0.01 + $$3.nextDouble() * 0.5;
                    double $$20 = Math.sin($$17) * $$16;
                    Particle $$21 = this.addParticleInternal($$14, $$14.getType().getOverrideLimiter(), $$9.x + $$18 * 0.1, $$9.y + 0.3, $$9.z + $$20 * 0.1, $$18, $$19, $$20);
                    if ($$21 == null) continue;
                    float $$22 = 0.75f + $$3.nextFloat() * 0.25f;
                    $$21.setColor($$11 * $$22, $$12 * $$22, $$13 * $$22);
                    $$21.setPower((float)$$16);
                }
                this.level.playLocalSound(p_234306_, SoundEvents.SPLASH_POTION_BREAK, SoundSource.NEUTRAL, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2001: {
                BlockState $$23 = Block.stateById(p_234307_);
                if (!$$23.isAir()) {
                    SoundType $$24 = $$23.getSoundType();
                    this.level.playLocalSound(p_234306_, $$24.getBreakSound(), SoundSource.BLOCKS, ($$24.getVolume() + 1.0f) / 2.0f, $$24.getPitch() * 0.8f, false);
                }
                this.level.addDestroyBlockEffect(p_234306_, $$23);
                break;
            }
            case 3008: {
                BlockState $$25 = Block.stateById(p_234307_);
                Block $$13 = $$25.getBlock();
                if ($$13 instanceof BrushableBlock) {
                    BrushableBlock $$26 = (BrushableBlock)$$13;
                    this.level.playLocalSound(p_234306_, $$26.getBrushCompletedSound(), SoundSource.PLAYERS, 1.0f, 1.0f, false);
                }
                this.level.addDestroyBlockEffect(p_234306_, $$25);
                break;
            }
            case 2004: {
                for (int $$27 = 0; $$27 < 20; ++$$27) {
                    double $$28 = (double)p_234306_.getX() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    double $$29 = (double)p_234306_.getY() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    double $$30 = (double)p_234306_.getZ() + 0.5 + ($$3.nextDouble() - 0.5) * 2.0;
                    this.level.addParticle(ParticleTypes.SMOKE, $$28, $$29, $$30, 0.0, 0.0, 0.0);
                    this.level.addParticle(ParticleTypes.FLAME, $$28, $$29, $$30, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 3011: {
                TrialSpawner.addSpawnParticles(this.level, p_234306_, $$3, TrialSpawner.FlameParticle.decode((int)p_234307_).particleType);
                break;
            }
            case 3012: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_234306_, $$3, TrialSpawner.FlameParticle.decode((int)p_234307_).particleType);
                break;
            }
            case 3021: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_SPAWN_ITEM, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addSpawnParticles(this.level, p_234306_, $$3, TrialSpawner.FlameParticle.decode((int)p_234307_).particleType);
                break;
            }
            case 3013: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_234306_, $$3, p_234307_, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER);
                break;
            }
            case 3019: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_DETECT_PLAYER, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_234306_, $$3, p_234307_, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                break;
            }
            case 3020: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_OMINOUS_ACTIVATE, SoundSource.BLOCKS, p_234307_ == 0 ? 0.3f : 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addDetectPlayerParticles(this.level, p_234306_, $$3, 0, ParticleTypes.TRIAL_SPAWNER_DETECTED_PLAYER_OMINOUS);
                TrialSpawner.addBecomeOminousParticles(this.level, p_234306_, $$3);
                break;
            }
            case 3014: {
                this.level.playLocalSound(p_234306_, SoundEvents.TRIAL_SPAWNER_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                TrialSpawner.addEjectItemParticles(this.level, p_234306_, $$3);
                break;
            }
            case 3017: {
                TrialSpawner.addEjectItemParticles(this.level, p_234306_, $$3);
                break;
            }
            case 3015: {
                BlockEntity $$28 = this.level.getBlockEntity(p_234306_);
                if (!($$28 instanceof VaultBlockEntity)) break;
                VaultBlockEntity $$31 = (VaultBlockEntity)$$28;
                VaultBlockEntity.Client.emitActivationParticles(this.level, $$31.getBlockPos(), $$31.getBlockState(), $$31.getSharedData(), p_234307_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME);
                this.level.playLocalSound(p_234306_, SoundEvents.VAULT_ACTIVATE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3016: {
                VaultBlockEntity.Client.emitDeactivationParticles(this.level, p_234306_, p_234307_ == 0 ? ParticleTypes.SMALL_FLAME : ParticleTypes.SOUL_FIRE_FLAME);
                this.level.playLocalSound(p_234306_, SoundEvents.VAULT_DEACTIVATE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 3018: {
                for (int $$32 = 0; $$32 < 10; ++$$32) {
                    double $$33 = $$3.nextGaussian() * 0.02;
                    double $$34 = $$3.nextGaussian() * 0.02;
                    double $$35 = $$3.nextGaussian() * 0.02;
                    this.level.addParticle(ParticleTypes.POOF, (double)p_234306_.getX() + $$3.nextDouble(), (double)p_234306_.getY() + $$3.nextDouble(), (double)p_234306_.getZ() + $$3.nextDouble(), $$33, $$34, $$35);
                }
                this.level.playLocalSound(p_234306_, SoundEvents.COBWEB_PLACE, SoundSource.BLOCKS, 1.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, true);
                break;
            }
            case 1505: {
                BoneMealItem.addGrowthParticles(this.level, p_234306_, p_234307_);
                this.level.playLocalSound(p_234306_, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 2011: {
                ParticleUtils.spawnParticleInBlock(this.level, p_234306_, p_234307_, ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 2012: {
                ParticleUtils.spawnParticleInBlock(this.level, p_234306_, p_234307_, ParticleTypes.HAPPY_VILLAGER);
                break;
            }
            case 3009: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_234306_, ParticleTypes.EGG_CRACK, UniformInt.of(3, 6));
                break;
            }
            case 3002: {
                if (p_234307_ >= 0 && p_234307_ < Direction.Axis.VALUES.length) {
                    ParticleUtils.spawnParticlesAlongAxis(Direction.Axis.VALUES[p_234307_], this.level, p_234306_, 0.125, ParticleTypes.ELECTRIC_SPARK, UniformInt.of(10, 19));
                    break;
                }
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_234306_, ParticleTypes.ELECTRIC_SPARK, UniformInt.of(3, 5));
                break;
            }
            case 2013: {
                ParticleUtils.spawnSmashAttackParticles(this.level, p_234306_, p_234307_);
                break;
            }
            case 3006: {
                int $$36 = p_234307_ >> 6;
                if ($$36 > 0) {
                    if ($$3.nextFloat() < 0.3f + (float)$$36 * 0.1f) {
                        float $$37 = 0.15f + 0.02f * (float)$$36 * (float)$$36 * $$3.nextFloat();
                        float $$38 = 0.4f + 0.3f * (float)$$36 * $$3.nextFloat();
                        this.level.playLocalSound(p_234306_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, $$37, $$38, false);
                    }
                    byte $$39 = (byte)(p_234307_ & 0x3F);
                    UniformInt $$40 = UniformInt.of(0, $$36);
                    float $$41 = 0.005f;
                    Supplier<Vec3> $$42 = () -> new Vec3(Mth.nextDouble($$3, -0.005f, 0.005f), Mth.nextDouble($$3, -0.005f, 0.005f), Mth.nextDouble($$3, -0.005f, 0.005f));
                    if ($$39 == 0) {
                        for (Direction $$43 : Direction.values()) {
                            float $$44 = $$43 == Direction.DOWN ? (float)Math.PI : 0.0f;
                            double $$45 = $$43.getAxis() == Direction.Axis.Y ? 0.65 : 0.57;
                            ParticleUtils.spawnParticlesOnBlockFace(this.level, p_234306_, new SculkChargeParticleOptions($$44), $$40, $$43, $$42, $$45);
                        }
                    } else {
                        for (Direction $$46 : MultifaceBlock.unpack($$39)) {
                            float $$47 = $$46 == Direction.UP ? (float)Math.PI : 0.0f;
                            double $$48 = 0.35;
                            ParticleUtils.spawnParticlesOnBlockFace(this.level, p_234306_, new SculkChargeParticleOptions($$47), $$40, $$46, $$42, 0.35);
                        }
                    }
                } else {
                    this.level.playLocalSound(p_234306_, SoundEvents.SCULK_BLOCK_CHARGE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                    boolean $$49 = this.level.getBlockState(p_234306_).isCollisionShapeFullBlock(this.level, p_234306_);
                    int $$50 = $$49 ? 40 : 20;
                    float $$51 = $$49 ? 0.45f : 0.25f;
                    float $$52 = 0.07f;
                    for (int $$53 = 0; $$53 < $$50; ++$$53) {
                        float $$54 = 2.0f * $$3.nextFloat() - 1.0f;
                        float $$55 = 2.0f * $$3.nextFloat() - 1.0f;
                        float $$56 = 2.0f * $$3.nextFloat() - 1.0f;
                        this.level.addParticle(ParticleTypes.SCULK_CHARGE_POP, (double)p_234306_.getX() + 0.5 + (double)($$54 * $$51), (double)p_234306_.getY() + 0.5 + (double)($$55 * $$51), (double)p_234306_.getZ() + 0.5 + (double)($$56 * $$51), $$54 * 0.07f, $$55 * 0.07f, $$56 * 0.07f);
                    }
                }
                break;
            }
            case 3007: {
                boolean $$59;
                for (int $$57 = 0; $$57 < 10; ++$$57) {
                    this.level.addParticle(new ShriekParticleOption($$57 * 5), false, (double)p_234306_.getX() + 0.5, (double)p_234306_.getY() + SculkShriekerBlock.TOP_Y, (double)p_234306_.getZ() + 0.5, 0.0, 0.0, 0.0);
                }
                BlockState $$58 = this.level.getBlockState(p_234306_);
                boolean bl = $$59 = $$58.hasProperty(BlockStateProperties.WATERLOGGED) && $$58.getValue(BlockStateProperties.WATERLOGGED) != false;
                if ($$59) break;
                this.level.playLocalSound((double)p_234306_.getX() + 0.5, (double)p_234306_.getY() + SculkShriekerBlock.TOP_Y, (double)p_234306_.getZ() + 0.5, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 2.0f, 0.6f + this.level.random.nextFloat() * 0.4f, false);
                break;
            }
            case 3003: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_234306_, ParticleTypes.WAX_ON, UniformInt.of(3, 5));
                this.level.playLocalSound(p_234306_, SoundEvents.HONEYCOMB_WAX_ON, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                break;
            }
            case 3004: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_234306_, ParticleTypes.WAX_OFF, UniformInt.of(3, 5));
                break;
            }
            case 3005: {
                ParticleUtils.spawnParticlesOnBlockFaces(this.level, p_234306_, ParticleTypes.SCRAPE, UniformInt.of(3, 5));
                break;
            }
            case 2008: {
                this.level.addParticle(ParticleTypes.EXPLOSION, (double)p_234306_.getX() + 0.5, (double)p_234306_.getY() + 0.5, (double)p_234306_.getZ() + 0.5, 0.0, 0.0, 0.0);
                break;
            }
            case 1500: {
                ComposterBlock.handleFill(this.level, p_234306_, p_234307_ > 0);
                break;
            }
            case 1504: {
                PointedDripstoneBlock.spawnDripParticle(this.level, p_234306_, this.level.getBlockState(p_234306_));
                break;
            }
            case 1501: {
                this.level.playLocalSound(p_234306_, SoundEvents.LAVA_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                for (int $$60 = 0; $$60 < 8; ++$$60) {
                    this.level.addParticle(ParticleTypes.LARGE_SMOKE, (double)p_234306_.getX() + $$3.nextDouble(), (double)p_234306_.getY() + 1.2, (double)p_234306_.getZ() + $$3.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1502: {
                this.level.playLocalSound(p_234306_, SoundEvents.REDSTONE_TORCH_BURNOUT, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                for (int $$61 = 0; $$61 < 5; ++$$61) {
                    double $$62 = (double)p_234306_.getX() + $$3.nextDouble() * 0.6 + 0.2;
                    double $$63 = (double)p_234306_.getY() + $$3.nextDouble() * 0.6 + 0.2;
                    double $$64 = (double)p_234306_.getZ() + $$3.nextDouble() * 0.6 + 0.2;
                    this.level.addParticle(ParticleTypes.SMOKE, $$62, $$63, $$64, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1503: {
                this.level.playLocalSound(p_234306_, SoundEvents.END_PORTAL_FRAME_FILL, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                for (int $$65 = 0; $$65 < 16; ++$$65) {
                    double $$66 = (double)p_234306_.getX() + (5.0 + $$3.nextDouble() * 6.0) / 16.0;
                    double $$67 = (double)p_234306_.getY() + 0.8125;
                    double $$68 = (double)p_234306_.getZ() + (5.0 + $$3.nextDouble() * 6.0) / 16.0;
                    this.level.addParticle(ParticleTypes.SMOKE, $$66, $$67, $$68, 0.0, 0.0, 0.0);
                }
                break;
            }
            case 2006: {
                for (int $$69 = 0; $$69 < 200; ++$$69) {
                    float $$70 = $$3.nextFloat() * 4.0f;
                    float $$71 = $$3.nextFloat() * ((float)Math.PI * 2);
                    double $$72 = Mth.cos($$71) * $$70;
                    double $$73 = 0.01 + $$3.nextDouble() * 0.5;
                    double $$74 = Mth.sin($$71) * $$70;
                    Particle $$75 = this.addParticleInternal(ParticleTypes.DRAGON_BREATH, false, (double)p_234306_.getX() + $$72 * 0.1, (double)p_234306_.getY() + 0.3, (double)p_234306_.getZ() + $$74 * 0.1, $$72, $$73, $$74);
                    if ($$75 == null) continue;
                    $$75.setPower($$70);
                }
                if (p_234307_ != 1) break;
                this.level.playLocalSound(p_234306_, SoundEvents.DRAGON_FIREBALL_EXPLODE, SoundSource.HOSTILE, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 2009: {
                for (int $$76 = 0; $$76 < 8; ++$$76) {
                    this.level.addParticle(ParticleTypes.CLOUD, (double)p_234306_.getX() + $$3.nextDouble(), (double)p_234306_.getY() + 1.2, (double)p_234306_.getZ() + $$3.nextDouble(), 0.0, 0.0, 0.0);
                }
                break;
            }
            case 1009: {
                if (p_234307_ == 0) {
                    this.level.playLocalSound(p_234306_, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.8f, false);
                    break;
                }
                if (p_234307_ != 1) break;
                this.level.playLocalSound(p_234306_, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.7f, 1.6f + ($$3.nextFloat() - $$3.nextFloat()) * 0.4f, false);
                break;
            }
            case 1029: {
                this.level.playLocalSound(p_234306_, SoundEvents.ANVIL_DESTROY, SoundSource.BLOCKS, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1030: {
                this.level.playLocalSound(p_234306_, SoundEvents.ANVIL_USE, SoundSource.BLOCKS, 1.0f, $$3.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1044: {
                this.level.playLocalSound(p_234306_, SoundEvents.SMITHING_TABLE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1031: {
                this.level.playLocalSound(p_234306_, SoundEvents.ANVIL_LAND, SoundSource.BLOCKS, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1039: {
                this.level.playLocalSound(p_234306_, SoundEvents.PHANTOM_BITE, SoundSource.HOSTILE, 0.3f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1010: {
                this.level.registryAccess().registryOrThrow(Registries.JUKEBOX_SONG).getHolder(p_234307_).ifPresent(p_349870_ -> this.playJukeboxSong((Holder<JukeboxSong>)p_349870_, p_234306_));
                break;
            }
            case 1011: {
                this.stopJukeboxSongAndNotifyNearby(p_234306_);
                break;
            }
            case 1015: {
                this.level.playLocalSound(p_234306_, SoundEvents.GHAST_WARN, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1017: {
                this.level.playLocalSound(p_234306_, SoundEvents.ENDER_DRAGON_SHOOT, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1016: {
                this.level.playLocalSound(p_234306_, SoundEvents.GHAST_SHOOT, SoundSource.HOSTILE, 10.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1019: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_ATTACK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1022: {
                this.level.playLocalSound(p_234306_, SoundEvents.WITHER_BREAK_BLOCK, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1021: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1020: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_ATTACK_IRON_DOOR, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1018: {
                this.level.playLocalSound(p_234306_, SoundEvents.BLAZE_SHOOT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1024: {
                this.level.playLocalSound(p_234306_, SoundEvents.WITHER_SHOOT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1026: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_INFECT, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1027: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_VILLAGER_CONVERTED, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1040: {
                this.level.playLocalSound(p_234306_, SoundEvents.ZOMBIE_CONVERTED_TO_DROWNED, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1041: {
                this.level.playLocalSound(p_234306_, SoundEvents.HUSK_CONVERTED_TO_ZOMBIE, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1025: {
                this.level.playLocalSound(p_234306_, SoundEvents.BAT_TAKEOFF, SoundSource.NEUTRAL, 0.05f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
                break;
            }
            case 1042: {
                this.level.playLocalSound(p_234306_, SoundEvents.GRINDSTONE_USE, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1043: {
                this.level.playLocalSound(p_234306_, SoundEvents.BOOK_PAGE_TURN, SoundSource.BLOCKS, 1.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 3000: {
                this.level.addParticle(ParticleTypes.EXPLOSION_EMITTER, true, (double)p_234306_.getX() + 0.5, (double)p_234306_.getY() + 0.5, (double)p_234306_.getZ() + 0.5, 0.0, 0.0, 0.0);
                this.level.playLocalSound(p_234306_, SoundEvents.END_GATEWAY_SPAWN, SoundSource.BLOCKS, 10.0f, (1.0f + (this.level.random.nextFloat() - this.level.random.nextFloat()) * 0.2f) * 0.7f, false);
                break;
            }
            case 3001: {
                this.level.playLocalSound(p_234306_, SoundEvents.ENDER_DRAGON_GROWL, SoundSource.HOSTILE, 64.0f, 0.8f + this.level.random.nextFloat() * 0.3f, false);
                break;
            }
            case 1045: {
                this.level.playLocalSound(p_234306_, SoundEvents.POINTED_DRIPSTONE_LAND, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1046: {
                this.level.playLocalSound(p_234306_, SoundEvents.POINTED_DRIPSTONE_DRIP_LAVA_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1047: {
                this.level.playLocalSound(p_234306_, SoundEvents.POINTED_DRIPSTONE_DRIP_WATER_INTO_CAULDRON, SoundSource.BLOCKS, 2.0f, this.level.random.nextFloat() * 0.1f + 0.9f, false);
                break;
            }
            case 1048: {
                this.level.playLocalSound(p_234306_, SoundEvents.SKELETON_CONVERTED_TO_STRAY, SoundSource.HOSTILE, 2.0f, ($$3.nextFloat() - $$3.nextFloat()) * 0.2f + 1.0f, false);
            }
        }
    }

    public void destroyBlockProgress(int p_109775_, BlockPos p_109776_, int p_109777_) {
        if (p_109777_ < 0 || p_109777_ >= 10) {
            BlockDestructionProgress $$3 = (BlockDestructionProgress)this.destroyingBlocks.remove(p_109775_);
            if ($$3 != null) {
                this.removeProgress($$3);
            }
        } else {
            BlockDestructionProgress $$4 = (BlockDestructionProgress)this.destroyingBlocks.get(p_109775_);
            if ($$4 != null) {
                this.removeProgress($$4);
            }
            if ($$4 == null || $$4.getPos().getX() != p_109776_.getX() || $$4.getPos().getY() != p_109776_.getY() || $$4.getPos().getZ() != p_109776_.getZ()) {
                $$4 = new BlockDestructionProgress(p_109775_, p_109776_);
                this.destroyingBlocks.put(p_109775_, (Object)$$4);
            }
            $$4.setProgress(p_109777_);
            $$4.updateTick(this.ticks);
            ((SortedSet)this.destructionProgress.computeIfAbsent($$4.getPos().asLong(), p_234254_ -> Sets.newTreeSet())).add($$4);
        }
    }

    public boolean hasRenderedAllSections() {
        return this.sectionRenderDispatcher.isQueueEmpty();
    }

    public void onChunkLoaded(ChunkPos p_295808_) {
        this.sectionOcclusionGraph.onChunkLoaded(p_295808_);
    }

    public void needsUpdate() {
        this.sectionOcclusionGraph.invalidate();
        this.generateClouds = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateGlobalBlockEntities(Collection<BlockEntity> p_109763_, Collection<BlockEntity> p_109764_) {
        Set<BlockEntity> set = this.globalBlockEntities;
        synchronized (set) {
            this.globalBlockEntities.removeAll(p_109763_);
            this.globalBlockEntities.addAll(p_109764_);
        }
    }

    public static int getLightColor(BlockAndTintGetter p_109542_, BlockPos p_109543_) {
        return LevelRenderer.getLightColor(p_109542_, p_109542_.getBlockState(p_109543_), p_109543_);
    }

    public static int getLightColor(BlockAndTintGetter p_109538_, BlockState p_109539_, BlockPos p_109540_) {
        int $$5;
        if (p_109539_.emissiveRendering(p_109538_, p_109540_)) {
            return 0xF000F0;
        }
        int $$3 = p_109538_.getBrightness(LightLayer.SKY, p_109540_);
        int $$4 = p_109538_.getBrightness(LightLayer.BLOCK, p_109540_);
        if ($$4 < ($$5 = p_109539_.getLightEmission())) {
            $$4 = $$5;
        }
        return $$3 << 20 | $$4 << 4;
    }

    public boolean isSectionCompiled(BlockPos p_295788_) {
        SectionRenderDispatcher.RenderSection $$1 = this.viewArea.getRenderSectionAt(p_295788_);
        return $$1 != null && $$1.compiled.get() != SectionRenderDispatcher.CompiledSection.UNCOMPILED;
    }

    @Nullable
    public RenderTarget entityTarget() {
        return this.entityTarget;
    }

    @Nullable
    public RenderTarget getTranslucentTarget() {
        return this.translucentTarget;
    }

    @Nullable
    public RenderTarget getItemEntityTarget() {
        return this.itemEntityTarget;
    }

    @Nullable
    public RenderTarget getParticlesTarget() {
        return this.particlesTarget;
    }

    @Nullable
    public RenderTarget getWeatherTarget() {
        return this.weatherTarget;
    }

    @Nullable
    public RenderTarget getCloudsTarget() {
        return this.cloudsTarget;
    }

    private void shootParticles(int p_307280_, BlockPos p_307603_, RandomSource p_307547_, SimpleParticleType p_307590_) {
        Direction $$4 = Direction.from3DDataValue(p_307280_);
        int $$5 = $$4.getStepX();
        int $$6 = $$4.getStepY();
        int $$7 = $$4.getStepZ();
        double $$8 = (double)p_307603_.getX() + (double)$$5 * 0.6 + 0.5;
        double $$9 = (double)p_307603_.getY() + (double)$$6 * 0.6 + 0.5;
        double $$10 = (double)p_307603_.getZ() + (double)$$7 * 0.6 + 0.5;
        for (int $$11 = 0; $$11 < 10; ++$$11) {
            double $$12 = p_307547_.nextDouble() * 0.2 + 0.01;
            double $$13 = $$8 + (double)$$5 * 0.01 + (p_307547_.nextDouble() - 0.5) * (double)$$7 * 0.5;
            double $$14 = $$9 + (double)$$6 * 0.01 + (p_307547_.nextDouble() - 0.5) * (double)$$6 * 0.5;
            double $$15 = $$10 + (double)$$7 * 0.01 + (p_307547_.nextDouble() - 0.5) * (double)$$5 * 0.5;
            double $$16 = (double)$$5 * $$12 + p_307547_.nextGaussian() * 0.01;
            double $$17 = (double)$$6 * $$12 + p_307547_.nextGaussian() * 0.01;
            double $$18 = (double)$$7 * $$12 + p_307547_.nextGaussian() * 0.01;
            this.addParticle(p_307590_, $$13, $$14, $$15, $$16, $$17, $$18);
        }
    }

    public static class TransparencyShaderException
    extends RuntimeException {
        public TransparencyShaderException(String p_109868_, Throwable p_109869_) {
            super(p_109868_, p_109869_);
        }
    }
}

