/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.StuckInBodyLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class BeeStingerLayer<T extends LivingEntity, M extends PlayerModel<T>>
extends StuckInBodyLayer<T, M> {
    private static final ResourceLocation BEE_STINGER_LOCATION = ResourceLocation.withDefaultNamespace("textures/entity/bee/bee_stinger.png");

    public BeeStingerLayer(LivingEntityRenderer<T, M> p_116580_) {
        super(p_116580_);
    }

    @Override
    protected int numStuck(T p_116582_) {
        return ((LivingEntity)p_116582_).getStingerCount();
    }

    @Override
    protected void renderStuckItem(PoseStack p_116584_, MultiBufferSource p_116585_, int p_116586_, Entity p_116587_, float p_116588_, float p_116589_, float p_116590_, float p_116591_) {
        float $$8 = Mth.sqrt(p_116588_ * p_116588_ + p_116590_ * p_116590_);
        float $$9 = (float)(Math.atan2(p_116588_, p_116590_) * 57.2957763671875);
        float $$10 = (float)(Math.atan2(p_116589_, $$8) * 57.2957763671875);
        p_116584_.translate(0.0f, 0.0f, 0.0f);
        p_116584_.mulPose(Axis.YP.rotationDegrees($$9 - 90.0f));
        p_116584_.mulPose(Axis.ZP.rotationDegrees($$10));
        float $$11 = 0.0f;
        float $$12 = 0.125f;
        float $$13 = 0.0f;
        float $$14 = 0.0625f;
        float $$15 = 0.03125f;
        p_116584_.mulPose(Axis.XP.rotationDegrees(45.0f));
        p_116584_.scale(0.03125f, 0.03125f, 0.03125f);
        p_116584_.translate(2.5f, 0.0f, 0.0f);
        VertexConsumer $$16 = p_116585_.getBuffer(RenderType.entityCutoutNoCull(BEE_STINGER_LOCATION));
        for (int $$17 = 0; $$17 < 4; ++$$17) {
            p_116584_.mulPose(Axis.XP.rotationDegrees(90.0f));
            PoseStack.Pose $$18 = p_116584_.last();
            BeeStingerLayer.vertex($$16, $$18, -4.5f, -1, 0.0f, 0.0f, p_116586_);
            BeeStingerLayer.vertex($$16, $$18, 4.5f, -1, 0.125f, 0.0f, p_116586_);
            BeeStingerLayer.vertex($$16, $$18, 4.5f, 1, 0.125f, 0.0625f, p_116586_);
            BeeStingerLayer.vertex($$16, $$18, -4.5f, 1, 0.0f, 0.0625f, p_116586_);
        }
    }

    private static void vertex(VertexConsumer p_254470_, PoseStack.Pose p_324141_, float p_253749_, int p_254520_, float p_254099_, float p_253914_, int p_254168_) {
        p_254470_.addVertex(p_324141_, p_253749_, (float)p_254520_, 0.0f).setColor(-1).setUv(p_254099_, p_253914_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(p_254168_).setNormal(p_324141_, 0.0f, 1.0f, 0.0f);
    }
}

