/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.coordinates.LocalCoordinates;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public class BlockPosArgument
implements ArgumentType<Coordinates> {
    private static final Collection<String> EXAMPLES = Arrays.asList("0 0 0", "~ ~ ~", "^ ^ ^", "^1 ^ ^-5", "~0.5 ~1 ~-5");
    public static final SimpleCommandExceptionType ERROR_NOT_LOADED = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.unloaded"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_WORLD = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.outofworld"));
    public static final SimpleCommandExceptionType ERROR_OUT_OF_BOUNDS = new SimpleCommandExceptionType((Message)Component.translatable("argument.pos.outofbounds"));

    public static BlockPosArgument blockPos() {
        return new BlockPosArgument();
    }

    public static BlockPos getLoadedBlockPos(CommandContext<CommandSourceStack> p_118243_, String p_118244_) throws CommandSyntaxException {
        ServerLevel $$2 = ((CommandSourceStack)p_118243_.getSource()).getLevel();
        return BlockPosArgument.getLoadedBlockPos(p_118243_, $$2, p_118244_);
    }

    public static BlockPos getLoadedBlockPos(CommandContext<CommandSourceStack> p_265283_, ServerLevel p_265219_, String p_265677_) throws CommandSyntaxException {
        BlockPos $$3 = BlockPosArgument.getBlockPos(p_265283_, p_265677_);
        if (!p_265219_.hasChunkAt($$3)) {
            throw ERROR_NOT_LOADED.create();
        }
        if (!p_265219_.isInWorldBounds($$3)) {
            throw ERROR_OUT_OF_WORLD.create();
        }
        return $$3;
    }

    public static BlockPos getBlockPos(CommandContext<CommandSourceStack> p_265651_, String p_265039_) {
        return ((Coordinates)p_265651_.getArgument(p_265039_, Coordinates.class)).getBlockPos((CommandSourceStack)p_265651_.getSource());
    }

    public static BlockPos getSpawnablePos(CommandContext<CommandSourceStack> p_174396_, String p_174397_) throws CommandSyntaxException {
        BlockPos $$2 = BlockPosArgument.getBlockPos(p_174396_, p_174397_);
        if (!Level.isInSpawnableBounds($$2)) {
            throw ERROR_OUT_OF_BOUNDS.create();
        }
        return $$2;
    }

    public Coordinates parse(StringReader p_118241_) throws CommandSyntaxException {
        if (p_118241_.canRead() && p_118241_.peek() == '^') {
            return LocalCoordinates.parse(p_118241_);
        }
        return WorldCoordinates.parseInt(p_118241_);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> p_118250_, SuggestionsBuilder p_118251_) {
        if (p_118250_.getSource() instanceof SharedSuggestionProvider) {
            Collection<SharedSuggestionProvider.TextCoordinates> $$4;
            String $$2 = p_118251_.getRemaining();
            if (!$$2.isEmpty() && $$2.charAt(0) == '^') {
                Set<SharedSuggestionProvider.TextCoordinates> $$3 = Collections.singleton(SharedSuggestionProvider.TextCoordinates.DEFAULT_LOCAL);
            } else {
                $$4 = ((SharedSuggestionProvider)p_118250_.getSource()).getRelevantCoordinates();
            }
            return SharedSuggestionProvider.suggestCoordinates($$2, $$4, p_118251_, Commands.createValidator(this::parse));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

