/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CrafterBlock
extends BaseEntityBlock {
    public static final MapCodec<CrafterBlock> CODEC = CrafterBlock.simpleCodec(CrafterBlock::new);
    public static final BooleanProperty CRAFTING = BlockStateProperties.CRAFTING;
    public static final BooleanProperty TRIGGERED = BlockStateProperties.TRIGGERED;
    private static final EnumProperty<FrontAndTop> ORIENTATION = BlockStateProperties.ORIENTATION;
    private static final int MAX_CRAFTING_TICKS = 6;
    private static final int CRAFTING_TICK_DELAY = 4;
    private static final RecipeCache RECIPE_CACHE = new RecipeCache(10);
    private static final int CRAFTER_ADVANCEMENT_DIAMETER = 17;

    public CrafterBlock(BlockBehaviour.Properties p_307674_) {
        super(p_307674_);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(ORIENTATION, FrontAndTop.NORTH_UP)).setValue(TRIGGERED, false)).setValue(CRAFTING, false));
    }

    protected MapCodec<CrafterBlock> codec() {
        return CODEC;
    }

    @Override
    protected boolean hasAnalogOutputSignal(BlockState p_307445_) {
        return true;
    }

    @Override
    protected int getAnalogOutputSignal(BlockState p_307633_, Level p_307264_, BlockPos p_307557_) {
        BlockEntity $$3 = p_307264_.getBlockEntity(p_307557_);
        if ($$3 instanceof CrafterBlockEntity) {
            CrafterBlockEntity $$4 = (CrafterBlockEntity)$$3;
            return $$4.getRedstoneSignal();
        }
        return 0;
    }

    @Override
    protected void neighborChanged(BlockState p_307205_, Level p_307451_, BlockPos p_307272_, Block p_307542_, BlockPos p_307508_, boolean p_307540_) {
        boolean $$6 = p_307451_.hasNeighborSignal(p_307272_);
        boolean $$7 = p_307205_.getValue(TRIGGERED);
        BlockEntity $$8 = p_307451_.getBlockEntity(p_307272_);
        if ($$6 && !$$7) {
            p_307451_.scheduleTick(p_307272_, this, 4);
            p_307451_.setBlock(p_307272_, (BlockState)p_307205_.setValue(TRIGGERED, true), 2);
            this.setBlockEntityTriggered($$8, true);
        } else if (!$$6 && $$7) {
            p_307451_.setBlock(p_307272_, (BlockState)((BlockState)p_307205_.setValue(TRIGGERED, false)).setValue(CRAFTING, false), 2);
            this.setBlockEntityTriggered($$8, false);
        }
    }

    @Override
    protected void tick(BlockState p_307471_, ServerLevel p_307641_, BlockPos p_307339_, RandomSource p_307565_) {
        this.dispenseFrom(p_307471_, p_307641_, p_307339_);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level p_307308_, BlockState p_307639_, BlockEntityType<T> p_307651_) {
        return p_307308_.isClientSide ? null : CrafterBlock.createTickerHelper(p_307651_, BlockEntityType.CRAFTER, CrafterBlockEntity::serverTick);
    }

    private void setBlockEntityTriggered(@Nullable BlockEntity p_307610_, boolean p_307577_) {
        if (p_307610_ instanceof CrafterBlockEntity) {
            CrafterBlockEntity $$2 = (CrafterBlockEntity)p_307610_;
            $$2.setTriggered(p_307577_);
        }
    }

    @Override
    public BlockEntity newBlockEntity(BlockPos p_307381_, BlockState p_307601_) {
        CrafterBlockEntity $$2 = new CrafterBlockEntity(p_307381_, p_307601_);
        $$2.setTriggered(p_307601_.hasProperty(TRIGGERED) && p_307601_.getValue(TRIGGERED) != false);
        return $$2;
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext p_307251_) {
        Direction $$1 = p_307251_.getNearestLookingDirection().getOpposite();
        Direction $$2 = switch ($$1) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> p_307251_.getHorizontalDirection().getOpposite();
            case Direction.UP -> p_307251_.getHorizontalDirection();
            case Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST -> Direction.UP;
        };
        return (BlockState)((BlockState)this.defaultBlockState().setValue(ORIENTATION, FrontAndTop.fromFrontAndTop($$1, $$2))).setValue(TRIGGERED, p_307251_.getLevel().hasNeighborSignal(p_307251_.getClickedPos()));
    }

    @Override
    public void setPlacedBy(Level p_307219_, BlockPos p_307681_, BlockState p_307383_, LivingEntity p_307647_, ItemStack p_307190_) {
        if (p_307383_.getValue(TRIGGERED).booleanValue()) {
            p_307219_.scheduleTick(p_307681_, this, 4);
        }
    }

    @Override
    protected void onRemove(BlockState p_307425_, Level p_307460_, BlockPos p_307342_, BlockState p_307466_, boolean p_307349_) {
        Containers.dropContentsOnDestroy(p_307425_, p_307466_, p_307460_, p_307342_);
        super.onRemove(p_307425_, p_307460_, p_307342_, p_307466_, p_307349_);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState p_307454_, Level p_307255_, BlockPos p_307303_, Player p_307670_, BlockHitResult p_307546_) {
        if (p_307255_.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity $$5 = p_307255_.getBlockEntity(p_307303_);
        if ($$5 instanceof CrafterBlockEntity) {
            p_307670_.openMenu((CrafterBlockEntity)$$5);
        }
        return InteractionResult.CONSUME;
    }

    /*
     * WARNING - void declaration
     */
    protected void dispenseFrom(BlockState p_307495_, ServerLevel p_307310_, BlockPos p_307672_) {
        void $$4;
        BlockEntity blockEntity = p_307310_.getBlockEntity(p_307672_);
        if (!(blockEntity instanceof CrafterBlockEntity)) {
            return;
        }
        CrafterBlockEntity $$3 = (CrafterBlockEntity)blockEntity;
        CraftingInput $$5 = $$4.asCraftInput();
        Optional<RecipeHolder<CraftingRecipe>> $$6 = CrafterBlock.getPotentialResults(p_307310_, $$5);
        if ($$6.isEmpty()) {
            p_307310_.levelEvent(1050, p_307672_, 0);
            return;
        }
        RecipeHolder<CraftingRecipe> $$7 = $$6.get();
        ItemStack $$8 = $$7.value().assemble($$5, p_307310_.registryAccess());
        if ($$8.isEmpty()) {
            p_307310_.levelEvent(1050, p_307672_, 0);
            return;
        }
        $$4.setCraftingTicksRemaining(6);
        p_307310_.setBlock(p_307672_, (BlockState)p_307495_.setValue(CRAFTING, true), 2);
        $$8.onCraftedBySystem(p_307310_);
        this.dispenseItem(p_307310_, p_307672_, (CrafterBlockEntity)$$4, $$8, p_307495_, $$7);
        for (ItemStack $$9 : $$7.value().getRemainingItems($$5)) {
            if ($$9.isEmpty()) continue;
            this.dispenseItem(p_307310_, p_307672_, (CrafterBlockEntity)$$4, $$9, p_307495_, $$7);
        }
        $$4.getItems().forEach(p_307295_ -> {
            if (p_307295_.isEmpty()) {
                return;
            }
            p_307295_.shrink(1);
        });
        $$4.setChanged();
    }

    public static Optional<RecipeHolder<CraftingRecipe>> getPotentialResults(Level p_307625_, CraftingInput p_345096_) {
        return RECIPE_CACHE.get(p_307625_, p_345096_);
    }

    private void dispenseItem(ServerLevel p_335887_, BlockPos p_307620_, CrafterBlockEntity p_307387_, ItemStack p_307296_, BlockState p_307501_, RecipeHolder<CraftingRecipe> p_335494_) {
        Direction $$6 = p_307501_.getValue(ORIENTATION).front();
        Container $$7 = HopperBlockEntity.getContainerAt(p_335887_, p_307620_.relative($$6));
        ItemStack $$8 = p_307296_.copy();
        if ($$7 != null && ($$7 instanceof CrafterBlockEntity || p_307296_.getCount() > $$7.getMaxStackSize(p_307296_))) {
            ItemStack $$9;
            ItemStack $$10;
            while (!$$8.isEmpty() && ($$10 = HopperBlockEntity.addItem(p_307387_, $$7, $$9 = $$8.copyWithCount(1), $$6.getOpposite())).isEmpty()) {
                $$8.shrink(1);
            }
        } else if ($$7 != null) {
            int $$11;
            while (!$$8.isEmpty() && ($$11 = $$8.getCount()) != ($$8 = HopperBlockEntity.addItem(p_307387_, $$7, $$8, $$6.getOpposite())).getCount()) {
            }
        }
        if (!$$8.isEmpty()) {
            Vec3 $$12 = Vec3.atCenterOf(p_307620_);
            Vec3 $$13 = $$12.relative($$6, 0.7);
            DefaultDispenseItemBehavior.spawnItem(p_335887_, $$8, 6, $$6, $$13);
            for (ServerPlayer $$14 : p_335887_.getEntitiesOfClass(ServerPlayer.class, AABB.ofSize($$12, 17.0, 17.0, 17.0))) {
                CriteriaTriggers.CRAFTER_RECIPE_CRAFTED.trigger($$14, p_335494_.id(), p_307387_.getItems());
            }
            p_335887_.levelEvent(1049, p_307620_, 0);
            p_335887_.levelEvent(2010, p_307620_, $$6.get3DDataValue());
        }
    }

    @Override
    protected RenderShape getRenderShape(BlockState p_307427_) {
        return RenderShape.MODEL;
    }

    @Override
    protected BlockState rotate(BlockState p_307240_, Rotation p_307431_) {
        return (BlockState)p_307240_.setValue(ORIENTATION, p_307431_.rotation().rotate(p_307240_.getValue(ORIENTATION)));
    }

    @Override
    protected BlockState mirror(BlockState p_307514_, Mirror p_307198_) {
        return (BlockState)p_307514_.setValue(ORIENTATION, p_307198_.rotation().rotate(p_307514_.getValue(ORIENTATION)));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_307200_) {
        p_307200_.add(ORIENTATION, TRIGGERED, CRAFTING);
    }
}

